/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.cmap;

import java.util.logging.Level;
import java.util.logging.Logger;

class CodeSpace {
    private byte[] begin;
    private byte[] end;
    private static final Logger LOGGER = Logger.getLogger(CodeSpace.class.getCanonicalName());

    CodeSpace(byte[] begin, byte[] end) {
        if (begin.length == end.length) {
            for (int i = 0; i < begin.length; ++i) {
                int beginNum = begin[i] & 0xFF;
                int endNum = end[i] & 0xFF;
                if (beginNum <= endNum) continue;
                this.begin = new byte[0];
                this.end = new byte[0];
                LOGGER.log(Level.FINE, "In codespace byte " + i + "in begin array is bigger than in end array.");
                return;
            }
            this.begin = begin;
            this.end = end;
        } else {
            this.begin = new byte[0];
            this.end = new byte[0];
            LOGGER.log(Level.FINE, "In codespace two passed arrays have different lengths");
        }
    }

    public boolean contains(byte[] character) {
        if (this.begin.length == character.length) {
            for (int i = 0; i < character.length; ++i) {
                int beginNum = this.begin[i] & 0xFF;
                int endNum = this.end[i] & 0xFF;
                int charNum = character[i] & 0xFF;
                if (charNum >= beginNum && charNum <= endNum) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isPartialMatch(byte toBeMatched, int position) {
        int beginNum = this.begin[position] & 0xFF;
        int endNum = this.end[position] & 0xFF;
        int charNum = toBeMatched & 0xFF;
        return charNum >= beginNum && charNum <= endNum;
    }

    public boolean overlaps(CodeSpace another) {
        int minLen = Math.min(this.getLength(), another.getLength());
        for (int i = 0; i < minLen; ++i) {
            int begin1 = this.begin[i] & 0xFF;
            int begin2 = another.begin[i] & 0xFF;
            int end1 = this.end[i] & 0xFF;
            int end2 = another.end[i] & 0xFF;
            if ((begin2 <= end1 || end2 <= end1) && (begin2 >= begin1 || end2 >= begin1)) continue;
            return false;
        }
        return true;
    }

    int getLength() {
        return this.begin.length;
    }
}

