/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.type1;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.as.io.ASMemoryInStream;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.parser.COSParser;
import org.verapdf.pd.font.Encoding;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.PDFontDescriptor;
import org.verapdf.pd.font.PDSimpleFont;
import org.verapdf.pd.font.cff.CFFFontProgram;
import org.verapdf.pd.font.opentype.OpenTypeFontProgram;
import org.verapdf.pd.font.stdmetrics.StandardFontMetrics;
import org.verapdf.pd.font.stdmetrics.StandardFontMetricsFactory;
import org.verapdf.pd.font.truetype.AdobeGlyphList;
import org.verapdf.pd.font.truetype.TrueTypePredefined;
import org.verapdf.pd.font.type1.SymbolSet;
import org.verapdf.pd.font.type1.Type1FontProgram;
import org.verapdf.tools.FontProgramIDGenerator;
import org.verapdf.tools.StaticResources;

public class PDType1Font
extends PDSimpleFont {
    private static final Logger LOGGER = Logger.getLogger(PDType1Font.class.getCanonicalName());
    private static final ASAtom[] STANDARD_FONT_NAMES = new ASAtom[]{ASAtom.COURIER_BOLD, ASAtom.COURIER_BOLD_OBLIQUE, ASAtom.COURIER, ASAtom.COURIER_OBLIQUE, ASAtom.HELVETICA, ASAtom.HELVETICA_BOLD, ASAtom.HELVETICA_BOLD_OBLIQUE, ASAtom.HELVETICA_OBLIQUE, ASAtom.SYMBOL, ASAtom.TIMES_BOLD, ASAtom.TIMES_BOLD_ITALIC, ASAtom.TIMES_ITALIC, ASAtom.TIMES_ROMAN, ASAtom.ZAPF_DINGBATS};
    private Boolean isStandard = null;
    private StandardFontMetrics fontMetrics;

    public PDType1Font(COSDictionary dictionary) {
        super(dictionary);
        if (this.isNameStandard() && this.fontDescriptor.getObject().size() == 0) {
            this.fontMetrics = StandardFontMetricsFactory.getFontMetrics(this.getName());
            this.fontDescriptor = PDFontDescriptor.getDescriptorFromMetrics(this.fontMetrics);
        }
    }

    public Set<String> getDescriptorCharSet() {
        String descriptorCharSetString = this.fontDescriptor.getCharSet();
        if (descriptorCharSetString != null) {
            try {
                ASMemoryInStream stream = new ASMemoryInStream(descriptorCharSetString.getBytes(StandardCharsets.ISO_8859_1));
                TreeSet<String> descriptorCharSet = new TreeSet<String>();
                COSParser parser = new COSParser(stream);
                COSObject glyphName = parser.nextObject();
                while (!glyphName.empty()) {
                    if (glyphName.getType() == COSObjType.COS_NAME) {
                        descriptorCharSet.add(glyphName.getString());
                    }
                    glyphName = parser.nextObject();
                }
                return descriptorCharSet;
            }
            catch (IOException ex) {
                LOGGER.log(Level.FINE, "Can't parse /CharSet entry in Type 1 font descriptor", ex);
                return Collections.emptySet();
            }
        }
        return Collections.emptySet();
    }

    @Override
    public FontProgram getFontProgram() {
        if (!this.isFontParsed) {
            this.isFontParsed = true;
            if (this.fontDescriptor.canParseFontFile(ASAtom.FONT_FILE)) {
                this.parseType1FontProgram(ASAtom.FONT_FILE);
            } else if (this.fontDescriptor.canParseFontFile(ASAtom.FONT_FILE3)) {
                this.parseType1FontProgram(ASAtom.FONT_FILE3);
            } else {
                this.fontProgram = null;
            }
        }
        return this.fontProgram;
    }

    private void parseType1FontProgram(ASAtom fontFileType) {
        block46: {
            if (this.fontDescriptor.canParseFontFile(fontFileType)) {
                COSStream type1FontFile = null;
                if (fontFileType == ASAtom.FONT_FILE) {
                    type1FontFile = this.fontDescriptor.getFontFile();
                } else if (fontFileType == ASAtom.FONT_FILE3) {
                    type1FontFile = this.fontDescriptor.getFontFile3();
                }
                if (type1FontFile != null) {
                    COSKey key = type1FontFile.getObjectKey();
                    try {
                        if (fontFileType == ASAtom.FONT_FILE) {
                            String fontProgramID = FontProgramIDGenerator.getType1FontProgramID(key);
                            this.fontProgram = StaticResources.getCachedFont(fontProgramID);
                            if (this.fontProgram != null) break block46;
                            try (ASInputStream fontData = type1FontFile.getData(COSStream.FilterFlags.DECODE);){
                                this.fontProgram = new Type1FontProgram(fontData);
                                StaticResources.cacheFontProgram(fontProgramID, this.fontProgram);
                                break block46;
                            }
                        }
                        ASAtom subtype = type1FontFile.getNameKey(ASAtom.SUBTYPE);
                        boolean isSubset = this.isSubset();
                        if (subtype == ASAtom.TYPE1C) {
                            String fontProgramID = FontProgramIDGenerator.getCFFFontProgramID(key, null, isSubset);
                            this.fontProgram = StaticResources.getCachedFont(fontProgramID);
                            if (this.fontProgram != null) break block46;
                            try (ASInputStream fontData = type1FontFile.getData(COSStream.FilterFlags.DECODE);){
                                this.fontProgram = new CFFFontProgram(fontData, null, isSubset);
                                StaticResources.cacheFontProgram(fontProgramID, this.fontProgram);
                                break block46;
                            }
                        }
                        if (subtype == ASAtom.OPEN_TYPE) {
                            boolean isSymbolic = this.isSymbolic();
                            COSObject encoding = this.getEncoding();
                            String fontProgramID = FontProgramIDGenerator.getOpenTypeFontProgramID(key, true, isSymbolic, encoding, null, isSubset);
                            this.fontProgram = StaticResources.getCachedFont(fontProgramID);
                            if (this.fontProgram != null) break block46;
                            try (ASInputStream fontData = type1FontFile.getData(COSStream.FilterFlags.DECODE);){
                                this.fontProgram = new OpenTypeFontProgram(fontData, true, isSymbolic, encoding, null, isSubset);
                                StaticResources.cacheFontProgram(fontProgramID, this.fontProgram);
                                break block46;
                            }
                        }
                        LOGGER.warning("Invalid subtype of the embedded font stream");
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.FINE, "Can't read Type 1 font program.", e);
                    }
                }
            }
        }
    }

    public Boolean isStandard() {
        if (this.isStandard == null) {
            if (!this.isEmbedded() && this.isNameStandard()) {
                this.isStandard = true;
                return this.isStandard;
            }
            this.isStandard = false;
            return this.isStandard;
        }
        return this.isStandard;
    }

    private static String[] getBaseEncoding(COSDictionary encoding) {
        ASAtom baseEncoding = encoding.getNameKey(ASAtom.BASE_ENCODING);
        if (baseEncoding == null) {
            return new String[0];
        }
        if (baseEncoding == ASAtom.MAC_ROMAN_ENCODING) {
            return Arrays.copyOf(TrueTypePredefined.MAC_ROMAN_ENCODING, TrueTypePredefined.MAC_ROMAN_ENCODING.length);
        }
        if (baseEncoding == ASAtom.MAC_EXPERT_ENCODING) {
            return Arrays.copyOf(TrueTypePredefined.MAC_EXPERT_ENCODING, TrueTypePredefined.MAC_EXPERT_ENCODING.length);
        }
        if (baseEncoding == ASAtom.WIN_ANSI_ENCODING) {
            return Arrays.copyOf(TrueTypePredefined.WIN_ANSI_ENCODING, TrueTypePredefined.WIN_ANSI_ENCODING.length);
        }
        return new String[0];
    }

    @Override
    public Double getWidth(int code) {
        if (this.getFontProgram() != null) {
            return super.getWidth(code);
        }
        if (this.fontMetrics != null) {
            StandardFontMetrics metrics = StandardFontMetricsFactory.getFontMetrics(this.getName());
            Encoding enc = this.getEncodingMapping();
            if (metrics != null) {
                return metrics.getWidth(enc.getName(code));
            }
        }
        LOGGER.log(Level.FINE, "Can't get standard metrics");
        return null;
    }

    @Override
    public float getWidthFromProgram(int code) {
        Encoding pdEncoding = this.getEncodingMapping();
        String glyphName = pdEncoding.getName(code);
        FontProgram fontProgram = this.getFontProgram();
        return glyphName != null ? fontProgram.getWidth(glyphName) : fontProgram.getWidth(code);
    }

    @Override
    public boolean glyphIsPresent(int code) {
        String glyphName;
        Encoding pdEncoding = this.getEncodingMapping();
        if (pdEncoding != null && (glyphName = pdEncoding.getName(code)) != null) {
            return this.getFontProgram().containsGlyph(glyphName);
        }
        return this.getFontProgram().containsCode(code);
    }

    private boolean isEmbedded() {
        return this.getFontProgram() != null;
    }

    private boolean isNameStandard() {
        ASAtom fontName = ASAtom.getASAtom(this.getName());
        for (ASAtom standard : STANDARD_FONT_NAMES) {
            if (standard != fontName) continue;
            return true;
        }
        return false;
    }

    public String toUnicodePDFA1(int code) {
        String unicodeString = super.cMapToUnicode(code);
        if (unicodeString != null) {
            return unicodeString;
        }
        Encoding fontEncoding = this.getEncodingMapping();
        String glyphName = null;
        if (fontEncoding != null) {
            glyphName = fontEncoding.getName(code);
        }
        if (glyphName == null && this.getFontProgram() != null) {
            glyphName = this.fontProgram.getGlyphName(code);
        }
        if (glyphName != null) {
            if (AdobeGlyphList.contains(glyphName) || SymbolSet.hasGlyphName(glyphName)) {
                return " ";
            }
            return null;
        }
        LOGGER.log(Level.FINE, "Cannot find encoding for glyph with code" + code + " in font " + this.getName());
        return null;
    }
}

