/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.colors;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASMemoryInStream;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.external.ICCProfile;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.colors.PDDeviceCMYK;
import org.verapdf.pd.colors.PDDeviceGray;
import org.verapdf.pd.colors.PDDeviceRGB;

public class PDICCBased
extends PDColorSpace {
    private static final Logger LOGGER = Logger.getLogger(PDICCBased.class.getCanonicalName());
    private final ICCProfile iccProfile;
    private final int numberOfComponents;

    public PDICCBased(int numberOfComponents) {
        this.iccProfile = null;
        this.numberOfComponents = numberOfComponents;
    }

    public PDICCBased(int numberOfComponents, byte[] profile) {
        ASMemoryInStream iccProfileStream = new ASMemoryInStream(profile);
        COSObject cosObject = COSStream.construct(iccProfileStream);
        cosObject.setIntegerKey(ASAtom.N, numberOfComponents);
        this.setObject(cosObject);
        this.iccProfile = new ICCProfile(cosObject);
        Long n = this.iccProfile.getNumberOfColorants();
        this.numberOfComponents = n == null ? -1 : n.intValue();
    }

    public PDICCBased(COSObject obj) {
        super(obj);
        COSObject stream = obj.at(1);
        if (stream != null && stream.getType() == COSObjType.COS_STREAM) {
            this.iccProfile = new ICCProfile(stream);
            Long n = this.iccProfile.getNumberOfColorants();
            this.numberOfComponents = n == null ? -1 : n.intValue();
        } else {
            this.iccProfile = null;
            this.numberOfComponents = -1;
        }
    }

    public ICCProfile getICCProfile() {
        return this.iccProfile;
    }

    @Override
    public int getNumberOfComponents() {
        return this.numberOfComponents;
    }

    @Override
    public ASAtom getType() {
        return ASAtom.ICCBASED;
    }

    public String getColorSpaceType() {
        String colorSpaceType = null;
        if (this.iccProfile != null) {
            colorSpaceType = this.iccProfile.getColorSpace();
        }
        return colorSpaceType;
    }

    public String getICCProfileIndirect() {
        COSKey key;
        if (this.iccProfile != null && (key = this.iccProfile.getObject().getKey()) != null) {
            return String.valueOf(key.getNumber() + " " + key.getGeneration());
        }
        return null;
    }

    public String getICCProfileMD5() {
        return this.iccProfile != null ? this.iccProfile.getMD5() : null;
    }

    public double[] getRange() {
        return this.iccProfile == null ? null : this.iccProfile.getRange();
    }

    public PDColorSpace getAlternate() {
        if (this.iccProfile == null) {
            return null;
        }
        PDColorSpace res = this.iccProfile.getAlternate();
        if (res == null) {
            switch (this.numberOfComponents) {
                case 1: {
                    res = PDDeviceGray.INSTANCE;
                    break;
                }
                case 3: {
                    res = PDDeviceRGB.INSTANCE;
                    break;
                }
                case 4: {
                    res = PDDeviceCMYK.INSTANCE;
                    break;
                }
                default: {
                    LOGGER.log(Level.FINE, "Unknown amount of components in icc based colorspace (" + this.numberOfComponents + ")");
                }
            }
        }
        return res;
    }
}

