/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.type1;

import java.io.IOException;
import java.util.Map;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.pd.font.CFFNumber;
import org.verapdf.pd.font.type1.BaseCharStringParser;

public class Type1CharStringParser
extends BaseCharStringParser {
    public Type1CharStringParser(ASInputStream decodedCharString) throws IOException {
        super(decodedCharString);
    }

    public Type1CharStringParser(ASInputStream decodedCharString, Map<Integer, CFFNumber> subrWidths) throws IOException {
        super(decodedCharString, subrWidths);
    }

    @Override
    protected boolean processNextOperator(int firstByte) throws IOException {
        block24: {
            block23: {
                if (firstByte == 12) break block23;
                switch (firstByte) {
                    case 9: 
                    case 11: 
                    case 14: {
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 7: 
                    case 22: {
                        this.popStack(1);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 21: {
                        this.popStack(2);
                        break;
                    }
                    case 30: 
                    case 31: {
                        this.popStack(4);
                        break;
                    }
                    case 8: {
                        this.popStack(6);
                        break;
                    }
                    case 13: {
                        if (!this.stack.empty()) {
                            this.setWidth((CFFNumber)this.stack.pop());
                            this.popStack(1);
                        }
                        return true;
                    }
                    case 10: {
                        if (!this.stack.empty()) {
                            CFFNumber width;
                            CFFNumber number = (CFFNumber)this.stack.pop();
                            if (this.subrWidths != null && (width = (CFFNumber)this.subrWidths.get((int)number.getInteger())) != null) {
                                this.setWidth(width);
                                return true;
                            } else {
                                break;
                            }
                        } else {
                            break;
                        }
                    }
                }
                break block24;
            }
            byte[] buf = new byte[1];
            this.readStreams(buf, 1);
            switch (buf[0] & 0xFF) {
                case 0: {
                    break;
                }
                case 33: {
                    this.popStack(2);
                    break;
                }
                case 6: {
                    this.popStack(5);
                    break;
                }
                case 1: 
                case 2: {
                    this.popStack(6);
                    break;
                }
                case 16: {
                    break;
                }
                case 17: {
                    this.popStack(1);
                    break;
                }
                case 7: {
                    this.popStack(1);
                    if (!this.stack.empty()) {
                        this.setWidth((CFFNumber)this.stack.pop());
                        this.popStack(2);
                    }
                    return true;
                }
                case 12: {
                    if (this.stack.size() <= 1) break;
                    int num2 = (int)((CFFNumber)this.stack.pop()).getInteger();
                    int num1 = (int)((CFFNumber)this.stack.pop()).getInteger();
                    this.stack.push(new CFFNumber(num1 / num2));
                    break;
                }
            }
        }
        return false;
    }

    @Override
    protected CFFNumber readNextNumber(int firstByte) throws IOException {
        byte[] buf = new byte[4];
        this.readStreams(buf, 4);
        int res = 0;
        for (int i = 0; i < 3; ++i) {
            res |= buf[i] & 0xFF;
            res <<= 8;
        }
        return new CFFNumber(res |= buf[3] & 0xFF);
    }
}

