/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.parser;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBoolean;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSDocument;
import org.verapdf.cos.COSIndirect;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSNull;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSReal;
import org.verapdf.cos.COSString;
import org.verapdf.parser.NotSeekableBaseParser;
import org.verapdf.parser.Token;
import org.verapdf.parser.postscript.PSObject;
import org.verapdf.pd.encryption.StandardSecurityHandler;

public class NotSeekableCOSParser
extends NotSeekableBaseParser {
    private static final Logger LOGGER = Logger.getLogger(NotSeekableCOSParser.class.getCanonicalName());
    protected COSDocument document;
    protected Queue<COSObject> objects = new LinkedList<COSObject>();
    protected Queue<Long> integers = new LinkedList<Long>();
    protected COSKey keyOfCurrentObject;
    protected boolean flag = true;

    public NotSeekableCOSParser(ASInputStream stream) throws IOException {
        super(stream);
    }

    public NotSeekableCOSParser(ASInputStream stream, boolean isPSParser) throws IOException {
        super(stream, isPSParser);
    }

    public NotSeekableCOSParser(ASInputStream stream, COSDocument document) throws IOException {
        super(stream);
        this.document = document;
    }

    public COSObject nextObject() throws IOException {
        if (!this.objects.isEmpty()) {
            COSObject result = this.objects.peek();
            this.objects.remove();
            return result;
        }
        if (this.flag) {
            this.initializeToken();
            this.nextToken();
        }
        this.flag = true;
        Token token = this.getToken();
        if (token.type == Token.Type.TT_INTEGER) {
            this.integers.add(token.integer);
            if (this.integers.size() == 3) {
                COSObject result = COSInteger.construct(this.integers.peek());
                this.integers.remove();
                return result;
            }
            return this.nextObject();
        }
        if (token.type == Token.Type.TT_KEYWORD && token.keyword == Token.Keyword.KW_R && this.integers.size() == 2) {
            int number = this.integers.peek().intValue();
            this.integers.remove();
            int generation = this.integers.peek().intValue();
            this.integers.remove();
            return COSIndirect.construct(new COSKey(number, generation), this.document);
        }
        if (!this.integers.isEmpty()) {
            COSObject result = COSInteger.construct(this.integers.peek());
            this.integers.remove();
            while (!this.integers.isEmpty()) {
                this.objects.add(COSInteger.construct(this.integers.peek()));
                this.integers.remove();
            }
            this.flag = false;
            return result;
        }
        block0 : switch (token.type) {
            case TT_NONE: {
                break;
            }
            case TT_KEYWORD: {
                if (token.keyword == null && this.isPSParser) {
                    return PSObject.getPSObject(COSName.construct(token.getValue()), true);
                }
                if (token.keyword == null) break;
                switch (token.keyword) {
                    case KW_NONE: {
                        break block0;
                    }
                    case KW_NULL: {
                        return COSNull.construct();
                    }
                    case KW_TRUE: {
                        return COSBoolean.construct(true);
                    }
                    case KW_FALSE: {
                        return COSBoolean.construct(false);
                    }
                    case KW_STREAM: 
                    case KW_ENDSTREAM: 
                    case KW_OBJ: 
                    case KW_ENDOBJ: 
                    case KW_R: 
                    case KW_N: 
                    case KW_F: 
                    case KW_XREF: 
                    case KW_STARTXREF: 
                    case KW_TRAILER: {
                        break block0;
                    }
                }
                break;
            }
            case TT_INTEGER: {
                break;
            }
            case TT_REAL: {
                return COSReal.construct(token.real);
            }
            case TT_LITSTRING: {
                return COSString.construct(token.getByteValue());
            }
            case TT_HEXSTRING: {
                COSObject res = COSString.construct(token.getByteValue(), true, token.getHexCount(), token.isContainsOnlyHex());
                if (this.document == null || !this.document.isEncrypted()) {
                    return res;
                }
                return this.decryptCOSString(res);
            }
            case TT_NAME: {
                return COSName.construct(token.getValue());
            }
            case TT_OPENARRAY: {
                this.flag = false;
                return this.getArray();
            }
            case TT_CLOSEARRAY: {
                return new COSObject();
            }
            case TT_OPENDICT: {
                this.flag = false;
                return this.getDictionary();
            }
            case TT_CLOSEDICT: {
                return this.getCloseDictionary();
            }
            case TT_EOF: {
                return new COSObject();
            }
            case TT_STARTPROC: {
                this.flag = false;
                COSObject proc = this.getArray();
                return PSObject.getPSObject(proc, true);
            }
        }
        return new COSObject();
    }

    protected COSObject getArray() throws IOException {
        if (this.flag) {
            this.nextToken();
        }
        this.flag = true;
        Token token = this.getToken();
        if (!(token.type == Token.Type.TT_OPENARRAY || this.isPSParser && token.type == Token.Type.TT_STARTPROC)) {
            return new COSObject();
        }
        COSObject arr = COSArray.construct();
        COSObject obj = this.nextObject();
        while (!obj.empty()) {
            arr.add(obj);
            obj = this.nextObject();
        }
        if (!(token.type == Token.Type.TT_CLOSEARRAY || this.isPSParser && token.type == Token.Type.TT_ENDPROC)) {
            throw new IOException("PDFParser::GetArray()invalid pdf array");
        }
        return arr;
    }

    protected COSObject getName() throws IOException {
        if (this.flag) {
            this.nextToken();
        }
        this.flag = true;
        Token token = this.getToken();
        if (token.type != Token.Type.TT_NAME) {
            return new COSObject();
        }
        return COSName.construct(token.getValue());
    }

    protected COSObject getCloseDictionary() {
        return new COSObject();
    }

    protected COSObject getDictionary() throws IOException {
        if (this.flag) {
            this.nextToken();
        }
        this.flag = true;
        Token token = this.getToken();
        if (token.type != Token.Type.TT_OPENDICT) {
            return new COSObject();
        }
        COSObject dict = COSDictionary.construct();
        COSObject key = this.getName();
        while (!key.empty()) {
            COSObject obj = this.nextObject();
            dict.setKey(key.getName(), obj);
            key = this.getName();
        }
        if (token.type != Token.Type.TT_CLOSEDICT) {
            throw new IOException("PDFParser::GetDictionary()invalid pdf dictonary");
        }
        return dict;
    }

    private COSObject decryptCOSString(COSObject string) {
        StandardSecurityHandler ssh = this.document.getStandardSecurityHandler();
        try {
            ssh.decryptString((COSString)string.getDirectBase(), this.keyOfCurrentObject);
            return string;
        }
        catch (IOException | GeneralSecurityException e) {
            LOGGER.log(Level.WARNING, "Can't decrypt string in object " + this.keyOfCurrentObject);
            return string;
        }
    }
}

