/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.exceptions.LoopedException;
import org.verapdf.pd.PDObject;
import org.verapdf.pd.structure.NameTreeIterator;

public class PDNameTreeNode
extends PDObject
implements Iterable<COSObject> {
    private Set<COSKey> parents = null;
    private List<PDNameTreeNode> kids = null;
    private Map<String, COSObject> names = null;

    private PDNameTreeNode(COSObject obj, Set<COSKey> parents) {
        super(obj);
        COSKey objectKey = obj.getObjectKey();
        this.parents = new HashSet<COSKey>(parents);
        if (objectKey != null) {
            if (parents.contains(objectKey)) {
                throw new LoopedException("Loop in name tree");
            }
            this.parents.add(objectKey);
        }
    }

    public static PDNameTreeNode create(COSObject object) {
        if (object == null || !object.getType().isDictionaryBased()) {
            throw new IllegalArgumentException("Argument object shall be dictionary or stream type");
        }
        return new PDNameTreeNode(object, new HashSet<COSKey>());
    }

    public List<PDNameTreeNode> getKids() {
        if (this.kids == null) {
            this.kids = this.parseKids();
        }
        return Collections.unmodifiableList(this.kids);
    }

    private List<PDNameTreeNode> parseKids() {
        COSObject kids = this.getKey(ASAtom.KIDS);
        if (kids != null && kids.getType() == COSObjType.COS_ARRAY) {
            ArrayList<PDNameTreeNode> res = new ArrayList<PDNameTreeNode>();
            for (COSObject obj : (COSArray)kids.getDirectBase()) {
                if (obj == null || !obj.getType().isDictionaryBased()) continue;
                res.add(new PDNameTreeNode(obj, this.parents));
            }
            return res;
        }
        return Collections.emptyList();
    }

    public Map<String, COSObject> getNames() {
        if (this.names == null) {
            this.names = this.parseNames();
        }
        return Collections.unmodifiableMap(this.names);
    }

    private Map<String, COSObject> parseNames() {
        COSObject names = this.getKey(ASAtom.NAMES);
        if (names != null && names.getType() == COSObjType.COS_ARRAY) {
            LinkedHashMap<String, COSObject> res = new LinkedHashMap<String, COSObject>();
            for (int i = 0; i < names.size(); i += 2) {
                String key;
                COSObject keyObj = names.at(i);
                String string = key = keyObj == null ? null : keyObj.getString();
                if (key == null) continue;
                COSObject value = names.at(i + 1);
                res.put(key, value);
            }
            return res;
        }
        return Collections.emptyMap();
    }

    public String[] getLimitsArray() {
        COSObject limits = this.getKey(ASAtom.LIMITS);
        if (limits != null && !limits.empty() && limits.getType() == COSObjType.COS_ARRAY && limits.size() >= 2 && limits.at(0).getType() == COSObjType.COS_STRING && limits.at(1).getType() == COSObjType.COS_STRING) {
            String[] res = new String[]{limits.at(0).getString(), limits.at(1).getString()};
            return res;
        }
        return null;
    }

    public COSObject getObject(String key) {
        HashSet<COSKey> visitedKeys = new HashSet<COSKey>();
        COSKey objectKey = this.getObject().getObjectKey();
        if (objectKey != null) {
            visitedKeys.add(objectKey);
        }
        return this.getObject(key, visitedKeys);
    }

    private COSObject getObject(String key, Set<COSKey> visitedKeys) {
        List<PDNameTreeNode> kids;
        String[] limits = this.getLimitsArray();
        if (limits != null && (key.compareTo(limits[0]) < 0 || key.compareTo(limits[1]) > 0)) {
            return null;
        }
        if (this.knownKey(ASAtom.NAMES)) {
            Map<String, COSObject> names = this.getNames();
            return names == null ? null : names.get(key);
        }
        if (this.knownKey(ASAtom.KIDS) && (kids = this.getKids()) != null) {
            for (PDNameTreeNode kid : kids) {
                COSObject res;
                COSKey kidObjectKey = kid.getObject().getObjectKey();
                if (kidObjectKey != null) {
                    if (visitedKeys.contains(kidObjectKey)) {
                        throw new LoopedException("Loop inside name tree");
                    }
                    visitedKeys.add(kidObjectKey);
                }
                if ((res = kid.getObject(key, visitedKeys)) == null) continue;
                return res;
            }
        }
        return null;
    }

    public NameTreeIterator iterator() {
        return new NameTreeIterator(this);
    }

    public Long size() {
        long i = 0L;
        NameTreeIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        return i;
    }
}

