/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSReal;
import org.verapdf.pd.function.PDFunction;

public class PDType2Function
extends PDFunction {
    private static final Double ZERO = 0.0;
    private static final Double ONE = 1.0;
    private static final double EPS = 1.0E-7;
    private List<COSObject> C0 = this.getCOSArrayAsList(ASAtom.C0, ZERO);
    private List<COSObject> C1 = this.getCOSArrayAsList(ASAtom.C1, ONE);
    private Double N;
    private static final Logger LOGGER = Logger.getLogger(PDType2Function.class.getCanonicalName());

    protected PDType2Function(COSObject obj) {
        super(obj);
    }

    private List<COSObject> getCOSArrayAsList(ASAtom key, double defaultValue) {
        ArrayList<COSObject> result = new ArrayList<COSObject>();
        COSArray array = this.getCOSArray(key);
        if (array == null) {
            result.add(COSReal.construct(defaultValue));
        } else {
            for (COSObject item : array) {
                result.add(item);
            }
        }
        return result;
    }

    public Double getN() {
        if (this.N == null) {
            if (this.getObject().getKey(ASAtom.N) == null) {
                LOGGER.log(Level.WARNING, "Invalid N key value in Type 2 Function dictionary");
                return null;
            }
            this.N = this.getObject().getKey(ASAtom.N).getReal();
        }
        return this.N;
    }

    public void setN(double N) {
        this.N = N;
    }

    public void setC0(List<COSObject> C0) {
        this.C0 = C0;
    }

    public void setC1(List<COSObject> C1) {
        this.C1 = C1;
    }

    private boolean checkOperand(COSObject operand) {
        if (Math.abs(this.N - Math.floor(this.N)) > 1.0E-7) {
            if (this.N < 0.0) {
                return operand.getReal() > ZERO;
            }
            return operand.getReal() >= ZERO;
        }
        if (this.N < 0.0) {
            return !ZERO.equals(operand.getReal());
        }
        return true;
    }

    @Override
    public List<COSObject> getResult(List<COSObject> ops) {
        List<COSObject> operands = new ArrayList<COSObject>();
        if (ops.size() > 1) {
            LOGGER.log(Level.WARNING, "Too many operands. The first one will be chosen");
        }
        operands.add(ops.get(0));
        operands = this.getValuesInIntervals(operands, this.getDomain());
        COSObject operand = operands.get(0);
        if (this.getN() == null || !this.checkOperand(operand)) {
            LOGGER.log(Level.WARNING, "Invalid operands stream or N key value in Type 2 Function dictionary");
            return null;
        }
        ArrayList<COSObject> result = new ArrayList<COSObject>();
        if (ZERO.equals(operand.getReal())) {
            return this.C0;
        }
        if (ONE.equals(operand.getReal())) {
            return this.C1;
        }
        for (int i = 0; i < this.C0.size(); ++i) {
            result.add(COSReal.construct(this.C0.get(i).getReal() + (this.C1.get(i).getReal() - this.C0.get(i).getReal()) * Math.pow(operand.getReal(), this.N)));
        }
        return Collections.unmodifiableList(this.getValuesInIntervals(result, this.getRange()));
    }
}

