/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.structure;

import java.util.Iterator;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.PDNameTreeNode;

public class NameTreeIterator
implements Iterator<COSObject> {
    private NameTreeIterator innerCurrentIterator;
    private final Iterator<COSObject> namesIterator;
    private final Iterator<PDNameTreeNode> kidsIterator;

    public NameTreeIterator(PDNameTreeNode root) {
        this.namesIterator = root.getNames().values().iterator();
        this.kidsIterator = root.getKids().iterator();
        this.nextInnerIterator();
    }

    @Override
    public boolean hasNext() {
        return this.innerCurrentIterator != null && this.innerCurrentIterator.hasNext() || this.kidsIterator.hasNext() || this.namesIterator.hasNext();
    }

    @Override
    public COSObject next() {
        if (this.namesIterator.hasNext()) {
            return this.namesIterator.next();
        }
        if (!this.innerCurrentIterator.hasNext()) {
            this.nextInnerIterator();
        }
        return this.innerCurrentIterator.next();
    }

    private void nextInnerIterator() {
        this.innerCurrentIterator = this.kidsIterator.hasNext() ? new NameTreeIterator(this.kidsIterator.next()) : null;
    }
}

