/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.structure;

import java.util.Iterator;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.structure.PDNumberTreeNode;

public class NumberTreeIterator
implements Iterator<COSObject> {
    private NumberTreeIterator innerCurrentIterator;
    private final Iterator<COSObject> numbersIterator;
    private final Iterator<PDNumberTreeNode> kidsIterator;

    public NumberTreeIterator(PDNumberTreeNode root) {
        this.numbersIterator = root.getNums().values().iterator();
        this.kidsIterator = root.getKids().iterator();
        this.nextInnerIterator();
    }

    @Override
    public boolean hasNext() {
        return this.innerCurrentIterator != null && this.innerCurrentIterator.hasNext() || this.kidsIterator.hasNext() || this.numbersIterator.hasNext();
    }

    @Override
    public COSObject next() {
        if (this.numbersIterator.hasNext()) {
            return this.numbersIterator.next();
        }
        if (!this.innerCurrentIterator.hasNext()) {
            this.nextInnerIterator();
        }
        return this.innerCurrentIterator.next();
    }

    private void nextInnerIterator() {
        this.innerCurrentIterator = this.kidsIterator.hasNext() ? new NumberTreeIterator(this.kidsIterator.next()) : null;
    }
}

