/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.stdmetrics;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.io.InternalInputStream;
import org.verapdf.io.SeekableInputStream;
import org.verapdf.pd.font.stdmetrics.AFMParser;
import org.verapdf.pd.font.stdmetrics.StandardFontMetrics;

public class StandardFontMetricsFactory {
    private static final Logger LOGGER = Logger.getLogger(StandardFontMetricsFactory.class.getCanonicalName());
    private static final String DIR_PATH = "/font/stdmetrics/";
    private static final String EXTENSION = ".afm";
    private static final Map<String, StandardFontMetrics> FONT_METRICS_MAP = new HashMap<String, StandardFontMetrics>();

    private StandardFontMetricsFactory() {
    }

    public static StandardFontMetrics getFontMetrics(String fontName) {
        StandardFontMetrics res = FONT_METRICS_MAP.get(fontName);
        if (res == null) {
            String afmPath = DIR_PATH + fontName + EXTENSION;
            try (ASInputStream afmStream = StandardFontMetricsFactory.load(afmPath);){
                AFMParser parser = new AFMParser(afmStream, fontName);
                res = parser.parse();
                FONT_METRICS_MAP.put(fontName, res);
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Can't open file input stream for predefined font file /font/stdmetrics/" + fontName + EXTENSION, e);
                return null;
            }
        }
        return res;
    }

    private static ASInputStream load(String fileName) {
        SeekableInputStream seekableInputStream;
        block9: {
            File afmFile = new File(StandardFontMetricsFactory.class.getResource(fileName).getFile());
            if (afmFile.exists()) {
                return new InternalInputStream(afmFile);
            }
            InputStream input = StandardFontMetrics.class.getResourceAsStream(fileName);
            try {
                seekableInputStream = SeekableInputStream.getSeekableStream(input);
                if (input == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Error in opening predefined font metrics file " + fileName, e);
                    return null;
                }
            }
            input.close();
        }
        return seekableInputStream;
    }
}

