/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.tools;

public class RC4Encryption {
    private final int[] s = new int[256];
    private final int[] key;
    private int i;
    private int j;

    public RC4Encryption(byte[] key) {
        this.key = new int[key.length];
        RC4Encryption.arraysCopy(key, this.key);
        this.reset();
    }

    public byte[] process(byte[] data) {
        return this.process(data, 0, data.length);
    }

    public byte[] process(byte[] data, int offset, int size) {
        if (size >= 0 && data.length >= offset) {
            int actualSize = Math.min(size, data.length - offset);
            byte[] res = new byte[actualSize];
            for (int k = offset; k < actualSize; ++k) {
                res[k] = (byte)(data[k] ^ this.getNextPseudoRandomByte());
            }
            return res;
        }
        return new byte[0];
    }

    public void reset() {
        this.i = 0;
        this.j = 0;
        this.keySchedulingAlgorithm();
    }

    private void keySchedulingAlgorithm() {
        for (int i = 0; i < 256; ++i) {
            this.s[i] = i;
        }
        int j = 0;
        for (int i = 0; i < 256; ++i) {
            j = (j + this.s[i] + this.key[i % this.key.length]) % 256;
            this.swapSElements(i, j);
        }
    }

    private byte getNextPseudoRandomByte() {
        this.i = (this.i + 1) % 256;
        this.j = (this.j + this.s[this.i]) % 256;
        this.swapSElements(this.i, this.j);
        return (byte)this.s[(this.s[this.i] + this.s[this.j]) % 256];
    }

    private void swapSElements(int i, int j) {
        int tmp = this.s[i];
        this.s[i] = this.s[j];
        this.s[j] = tmp;
    }

    private static void arraysCopy(byte[] src, int[] dst) {
        for (int i = 0; i < src.length; ++i) {
            dst[i] = src[i] & 0xFF;
        }
    }
}

