/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd;

import java.util.Calendar;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.pd.PDObject;
import org.verapdf.tools.TypeConverter;

public class PDSignature
extends PDObject {
    public PDSignature(COSDictionary dict) {
        super(new COSObject(dict));
    }

    public int[] getByteRange() {
        COSArray array;
        COSObject cosByteRange = this.getKey(ASAtom.BYTERANGE);
        if (cosByteRange.getType() == COSObjType.COS_ARRAY && (array = (COSArray)cosByteRange.getDirectBase()).size() >= 4) {
            int[] res = new int[4];
            for (int i = 0; i < 4; ++i) {
                res[i] = array.at(i).getInteger().intValue();
            }
            return res;
        }
        return null;
    }

    public COSArray getReference() {
        COSObject res = this.getKey(ASAtom.REFERENCE);
        if (res.getType() == COSObjType.COS_ARRAY) {
            return (COSArray)res.getDirectBase();
        }
        return null;
    }

    public COSString getContents() {
        COSObject res = this.getKey(ASAtom.CONTENTS);
        if (res.getType() == COSObjType.COS_STRING) {
            return (COSString)res.getDirectBase();
        }
        return null;
    }

    public ASAtom getFilter() {
        return this.getNameKey(ASAtom.FILTER);
    }

    public Calendar getSignDate() {
        return TypeConverter.parseDate(this.getStringKey(ASAtom.M));
    }

    public String getContactInfo() {
        return this.getStringKey(ASAtom.CONTACT_INFO);
    }

    public ASAtom getSubfilter() {
        return this.getNameKey(ASAtom.SUB_FILTER);
    }

    public String getName() {
        return this.getStringKey(ASAtom.NAME);
    }

    public String getLocation() {
        return this.getStringKey(ASAtom.LOCATION);
    }

    public String getReason() {
        return this.getStringKey(ASAtom.REASON);
    }
}

