/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.images;

import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.PDResource;
import org.verapdf.pd.PDResources;
import org.verapdf.pd.images.PDXForm;
import org.verapdf.pd.images.PDXImage;
import org.verapdf.pd.images.PDXPostScript;

public abstract class PDXObject
extends PDResource {
    protected PDXObject(COSObject obj) {
        super(obj);
    }

    public abstract ASAtom getType();

    public ASAtom getSubtype() {
        return this.getObject().getNameKey(ASAtom.SUBTYPE);
    }

    public COSDictionary getOPI() {
        COSObject opi = this.getKey(ASAtom.OPI);
        if (opi != null && opi.getType() == COSObjType.COS_DICT) {
            return (COSDictionary)opi.getDirectBase();
        }
        return null;
    }

    public PDXImage getSMask() {
        COSObject smask = this.getKey(ASAtom.SMASK);
        if (smask != null && smask.getType() == COSObjType.COS_STREAM) {
            return new PDXImage(smask, null);
        }
        return null;
    }

    public static PDXObject getTypedPDXObject(COSObject object, PDResources resources) {
        ASAtom type = object.getNameKey(ASAtom.SUBTYPE);
        if (ASAtom.IMAGE.equals(type)) {
            return new PDXImage(object, resources);
        }
        if (ASAtom.FORM.equals(type)) {
            return new PDXForm(object);
        }
        if (ASAtom.PS.equals(type)) {
            return new PDXPostScript(object);
        }
        return null;
    }
}

