/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.as.io;

import java.io.IOException;
import java.io.InputStream;
import org.verapdf.as.io.ASInputStreamWrapper;
import org.verapdf.tools.IntReference;

public abstract class ASInputStream
extends InputStream {
    protected int nPos = -1;
    protected IntReference resourceUsers = new IntReference(1);

    @Override
    public abstract int read() throws IOException;

    public abstract int read(byte[] var1, int var2) throws IOException;

    public abstract int skip(int var1) throws IOException;

    @Override
    public void close() throws IOException {
        if (!this.resourceUsers.equals(0)) {
            this.resourceUsers.decrement();
        }
        if (this.resourceUsers.equals(0)) {
            this.closeResource();
        }
    }

    @Override
    public abstract void reset() throws IOException;

    public abstract void closeResource() throws IOException;

    public abstract void incrementResourceUsers();

    public static ASInputStream createStreamFromStream(ASInputStream stream) {
        stream.incrementResourceUsers();
        return new ASInputStreamWrapper(stream);
    }
}

