/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.factory.colors;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.PDResources;
import org.verapdf.pd.colors.PDCalGray;
import org.verapdf.pd.colors.PDCalRGB;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.colors.PDDeviceCMYK;
import org.verapdf.pd.colors.PDDeviceGray;
import org.verapdf.pd.colors.PDDeviceN;
import org.verapdf.pd.colors.PDDeviceRGB;
import org.verapdf.pd.colors.PDICCBased;
import org.verapdf.pd.colors.PDIndexed;
import org.verapdf.pd.colors.PDLab;
import org.verapdf.pd.colors.PDSeparation;
import org.verapdf.pd.patterns.PDPattern;
import org.verapdf.pd.patterns.PDShadingPattern;
import org.verapdf.pd.patterns.PDTilingPattern;

public class ColorSpaceFactory {
    private static final Logger LOGGER = Logger.getLogger(ColorSpaceFactory.class.getCanonicalName());

    private ColorSpaceFactory() {
    }

    public static ASAtom getDefaultValue(PDResources resources, ASAtom name) {
        if (resources != null) {
            if (name.equals(ASAtom.DEVICECMYK) && resources.hasColorSpace(ASAtom.DEFAULT_CMYK)) {
                return ASAtom.DEFAULT_CMYK;
            }
            if (name.equals(ASAtom.DEVICERGB) && resources.hasColorSpace(ASAtom.DEFAULT_RGB)) {
                return ASAtom.DEFAULT_RGB;
            }
            if (name.equals(ASAtom.DEVICEGRAY) && resources.hasColorSpace(ASAtom.DEFAULT_GRAY)) {
                return ASAtom.DEFAULT_GRAY;
            }
        }
        return null;
    }

    public static PDColorSpace getColorSpace(COSObject base) {
        return ColorSpaceFactory.getColorSpace(base, null);
    }

    public static PDColorSpace getColorSpace(COSObject base, PDResources resources) {
        return ColorSpaceFactory.getColorSpace(base, resources, false);
    }

    public static PDColorSpace getColorSpace(COSObject base, PDResources resources, boolean wasDefault) {
        if (base == null) {
            return null;
        }
        COSObjType type = base.getType();
        if (type == COSObjType.COS_NAME) {
            PDColorSpace cs = ColorSpaceFactory.getColorSpaceFromName(base, resources, wasDefault);
            return cs;
        }
        if (type == COSObjType.COS_ARRAY) {
            return ColorSpaceFactory.getColorSpaceFromArray(base, resources);
        }
        if (type != null && type.isDictionaryBased()) {
            return ColorSpaceFactory.getPattern(base);
        }
        LOGGER.log(Level.FINE, "COSObject has to be a name or array, but it is not");
        return null;
    }

    private static PDColorSpace getColorSpaceFromName(COSObject base, PDResources resources, boolean wasDefault) {
        PDColorSpace res;
        ASAtom defaultName = ColorSpaceFactory.getDefaultValue(resources, base.getName());
        if (resources != null && defaultName != null && !wasDefault) {
            return resources.getColorSpace(defaultName, true);
        }
        ASAtom name = base.getName();
        if (ASAtom.DEVICEGRAY.equals(name)) {
            return PDDeviceGray.INSTANCE;
        }
        if (ASAtom.DEVICERGB.equals(name)) {
            return PDDeviceRGB.INSTANCE;
        }
        if (ASAtom.DEVICECMYK.equals(name)) {
            return PDDeviceCMYK.INSTANCE;
        }
        if (ASAtom.PATTERN.equals(name)) {
            return PDPattern.INSTANCE;
        }
        if (resources != null && resources.hasColorSpace(name) && (res = resources.getColorSpace(name)) != null) {
            return res;
        }
        LOGGER.log(Level.FINE, "Unknown ColorSpace name");
        return null;
    }

    private static PDColorSpace getColorSpaceFromArray(COSObject base, PDResources resources) {
        if (base.size() < 2) {
            LOGGER.log(Level.FINE, "ColorSpace array can not contain less than two elements");
            return null;
        }
        ASAtom name = base.at(0).getName();
        if (ASAtom.CALGRAY.equals(name)) {
            return new PDCalGray(base);
        }
        if (ASAtom.CALRGB.equals(name)) {
            return new PDCalRGB(base);
        }
        if (ASAtom.LAB.equals(name)) {
            return new PDLab(base);
        }
        if (ASAtom.ICCBASED.equals(name)) {
            return new PDICCBased(base);
        }
        if (ASAtom.SEPARATION.equals(name)) {
            return new PDSeparation(base, resources);
        }
        if (ASAtom.DEVICEN.equals(name)) {
            return new PDDeviceN(base, resources);
        }
        if (ASAtom.INDEXED.equals(name)) {
            return new PDIndexed(base, resources);
        }
        if (ASAtom.PATTERN == name) {
            return PDPattern.INSTANCE;
        }
        LOGGER.log(Level.FINE, "Unknown ColorSpace name");
        return null;
    }

    private static PDPattern getPattern(COSObject base) {
        Long patternType = base.getIntegerKey(ASAtom.PATTERN_TYPE);
        if (patternType != null) {
            int simplePatternType = patternType.intValue();
            switch (simplePatternType) {
                case 1: {
                    return new PDTilingPattern(base);
                }
                case 2: {
                    return new PDShadingPattern(base);
                }
            }
            LOGGER.log(Level.FINE, "PatternType value is not correct");
            return null;
        }
        LOGGER.log(Level.FINE, "COSObject doesn't contain PatternType key");
        return null;
    }
}

