/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.type1;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.io.ASMemoryInStream;
import org.verapdf.parser.COSParser;
import org.verapdf.parser.Token;
import org.verapdf.pd.font.Encoding;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.truetype.TrueTypePredefined;
import org.verapdf.pd.font.type1.EexecFilterDecode;
import org.verapdf.pd.font.type1.Type1PrivateParser;
import org.verapdf.tools.resource.ASFileStreamCloser;

public class Type1FontProgram
extends COSParser
implements FontProgram {
    public static final Logger LOGGER = Logger.getLogger(Type1FontProgram.class.getCanonicalName());
    static final double[] DEFAULT_FONT_MATRIX = new double[]{0.001, 0.0, 0.0, 0.001, 0.0, 0.0};
    private Encoding pdfEncoding;
    private double[] fontMatrix = Arrays.copyOf(DEFAULT_FONT_MATRIX, DEFAULT_FONT_MATRIX.length);
    private String[] encoding = new String[256];
    private Map<String, Integer> glyphWidths;
    private static final byte[] CLEAR_TO_MARK_BYTES = "cleartomark".getBytes();
    private boolean attemptedParsing = false;
    private boolean successfullyParsed = false;

    public Type1FontProgram(String fileName) throws IOException {
        super(fileName);
    }

    public Type1FontProgram(InputStream fileStream, Encoding pdfEncoding) throws IOException {
        super(fileStream);
        this.pdfEncoding = pdfEncoding;
    }

    @Override
    public void parseFont() throws IOException {
        if (!this.attemptedParsing) {
            try {
                this.attemptedParsing = true;
                this.initializeToken();
                this.skipSpaces(true);
                while (this.getToken().type != Token.Type.TT_EOF) {
                    this.nextToken();
                    this.processToken();
                }
                if (this.glyphWidths == null) {
                    throw new IOException("Type 1 font doesn't contain charstrings.");
                }
                this.successfullyParsed = true;
            }
            finally {
                this.source.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void processToken() throws IOException {
        block40: {
            block5 : switch (1.$SwitchMap$org$verapdf$parser$Token$Type[this.getToken().type.ordinal()]) {
                case 1: {
                    var1_1 = this.getToken().getValue();
                    var2_3 = -1;
                    switch (var1_1.hashCode()) {
                        case 969389328: {
                            if (!var1_1.equals("FontMatrix")) break;
                            var2_3 = 0;
                            break;
                        }
                        case 1775866227: {
                            if (!var1_1.equals("Encoding")) break;
                            var2_3 = 1;
                        }
                    }
                    block13 : switch (var2_3) {
                        case 0: {
                            this.skipSpaces();
                            this.nextToken();
                            if (this.getToken().type == Token.Type.TT_OPENARRAY) {
                                this.source.unread();
                                cosFontMatrix = this.nextObject();
                                if (cosFontMatrix.size() != 6) break block5;
                                for (i = 0; i < 6; ++i) {
                                    this.fontMatrix[i] = cosFontMatrix.at(i).getReal();
                                }
                                break block5;
                            }
                            break block40;
                        }
                        case 1: {
                            if (this.isEncodingName()) break;
                            do {
                                this.nextToken();
                            } while (!this.getToken().getValue().equals("dup") && this.getToken().type != Token.Type.TT_EOF);
                            if (this.getToken().type == Token.Type.TT_EOF) {
                                throw new IOException("Can't parse Type 1 font program");
                            }
                            this.source.unread(3);
                            while (true) {
                                this.nextToken();
                                token = this.getToken().getValue();
                                if (token.equals("def")) break block13;
                                if (token.equals("readonly")) break block13;
                                if (this.getToken().type == Token.Type.TT_EOF) {
                                    throw new IOException("Can't parse Type 1 font program");
                                }
                                this.skipSpaces();
                                this.readNumber();
                                key = this.getToken().integer;
                                this.nextToken();
                                if (key < 256L) {
                                    this.encoding[(int)key] = this.getToken().getValue();
                                } else {
                                    Type1FontProgram.LOGGER.log(Level.FINE, "Found glyph with encoding " + key + " in Type 1 font, value less than 256 expected.");
                                }
                                this.nextToken();
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    var1_2 = this.getToken().getValue();
                    var2_4 = -1;
                    switch (var1_2.hashCode()) {
                        case 96403062: {
                            if (!var1_2.equals("eexec")) break;
                            var2_4 = 0;
                        }
                    }
                    switch (var2_4) {
                        case 0: {
                            this.skipSpaces();
                            clearToMarkOffset = this.findOffsetCleartomark();
                            eexecEncoded = this.source.getStream(this.source.getOffset(), clearToMarkOffset - this.source.getOffset());
                            var6_11 = null;
                            eexecDecoded = new EexecFilterDecode(eexecEncoded, false);
                            parser = new Type1PrivateParser(eexecDecoded, this.fontMatrix);
                            try {
                                parser.parse();
                            }
                            finally {
                                parser.closeInputStream();
                            }
                            this.glyphWidths = parser.getGlyphWidths();
                            this.source.seek(clearToMarkOffset);
                            if (eexecEncoded == null) break;
                            if (var6_11 == null) ** GOTO lbl84
                            try {
                                eexecEncoded.close();
                            }
                            catch (Throwable var9_16) {
                                var6_11.addSuppressed(var9_16);
                            }
                            break;
lbl84:
                            // 1 sources

                            eexecEncoded.close();
                            break;
                            catch (Throwable var7_13) {
                                try {
                                    var6_11 = var7_13;
                                    throw var7_13;
                                }
                                catch (Throwable var10_17) {
                                    if (eexecEncoded != null) {
                                        if (var6_11 != null) {
                                            try {
                                                eexecEncoded.close();
                                            }
                                            catch (Throwable var11_18) {
                                                var6_11.addSuppressed(var11_18);
                                            }
                                        } else {
                                            eexecEncoded.close();
                                        }
                                    }
                                    throw var10_17;
                                }
                            }
                        }
                    }
                    break;
                }
            }
        }
    }

    private long findOffsetCleartomark() throws IOException {
        long startingOffset = this.source.getOffset();
        int length = CLEAR_TO_MARK_BYTES.length;
        this.source.seek(this.source.getStreamLength() - (long)length);
        byte[] buf = new byte[length];
        this.source.read(buf, length);
        while (!Arrays.equals(buf, CLEAR_TO_MARK_BYTES) && this.source.getOffset() > (long)length) {
            this.source.unread(length + 1);
            this.source.read(buf, length);
        }
        if (this.source.getOffset() == (long)length) {
            LOGGER.log(Level.FINE, "cleartomark keyword can't be found while parsing Type1 font.");
            this.source.seek(startingOffset);
            return this.source.getStreamLength();
        }
        long res = this.source.getOffset() - (long)length;
        this.source.seek(startingOffset);
        return res - 512L;
    }

    @Override
    public float getWidth(int charCode) {
        try {
            Integer res;
            if (this.glyphWidths != null && (res = this.glyphWidths.get(this.getGlyph(charCode))) != null) {
                return res.intValue();
            }
            return -1.0f;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1.0f;
        }
    }

    @Override
    public float getWidth(String glyphName) {
        Integer res = this.glyphWidths.get(glyphName);
        return res == null ? -1.0f : (float)res.intValue();
    }

    @Override
    public boolean containsCode(int code) {
        String glyphName = this.getGlyph(code);
        return this.glyphWidths != null && this.glyphWidths.keySet().contains(glyphName);
    }

    @Override
    public boolean isAttemptedParsing() {
        return this.attemptedParsing;
    }

    @Override
    public boolean isSuccessfulParsing() {
        return this.successfullyParsed;
    }

    public String[] getEncoding() {
        return this.encoding;
    }

    public String[] getCharSet() {
        Set<String> charSet = this.glyphWidths.keySet();
        return charSet.toArray(new String[charSet.size()]);
    }

    private boolean isEncodingName() throws IOException {
        long startOffset = this.source.getOffset();
        this.nextToken();
        String possibleEncodingName = this.getToken().getValue();
        this.nextToken();
        if ("def".equals(this.getToken().getValue())) {
            if ("StandardEncoding".equals(possibleEncodingName)) {
                this.encoding = TrueTypePredefined.STANDARD_ENCODING;
                this.source.seek(startOffset);
                return true;
            }
            throw new IOException("Can't get encoding " + possibleEncodingName + " as internal encoding of type 1 font program.");
        }
        this.source.seek(startOffset);
        return false;
    }

    private String getGlyph(int code) {
        if (!(this.pdfEncoding != null && this.pdfEncoding.containsCode(code) || code >= this.encoding.length)) {
            return this.encoding[code];
        }
        return this.pdfEncoding.getName(code);
    }

    @Override
    public ASFileStreamCloser getFontProgramResource() {
        if (this.source instanceof ASMemoryInStream) {
            return null;
        }
        return new ASFileStreamCloser(this.source);
    }
}

