/*
 * This file is part of VeraPDF Validation Model API for Arlington PDF Model, a module of the veraPDF project.
 * Copyright (c) 2015-2025, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * VeraPDF Validation Model API for Arlington PDF Model is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with VeraPDF Validation Model API for Arlington PDF Model as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * VeraPDF Validation Model API for Arlington PDF Model as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.alayer;
		
import org.verapdf.model.baselayer.Object;

		
/**
*/
public interface AMovieActivation extends AObject {
	





	/**
	*/
	public Boolean getcontainsDuration();

	/**
	*/
	public String getDurationType();

	/**
	*/
	public Boolean getDurationHasTypeArray();

	/**
	*/
	public Boolean getDurationHasTypeInteger();

	/**
	*/
	public Boolean getDurationHasTypeStringByte();

	/**
	*/
	public Long getDurationIntegerValue();

	/**
	*/
	public Long getDurationStringSize();

	/**
	*/
	public Boolean getcontainsFWPosition();

	/**
	*/
	public String getFWPositionType();

	/**
	*/
	public Boolean getFWPositionHasTypeArray();

	/**
	*/
	public Boolean getcontainsFWScale();

	/**
	*/
	public String getFWScaleType();

	/**
	*/
	public Boolean getFWScaleHasTypeArray();

	/**
	*/
	public Boolean getcontainsMode();

	/**
	*/
	public String getModeType();

	/**
	*/
	public Boolean getModeHasTypeName();

	/**
	*/
	public String getModeNameValue();

	/**
	*/
	public Boolean getcontainsRate();

	/**
	*/
	public String getRateType();

	/**
	*/
	public Boolean getRateHasTypeNumber();

	/**
	*/
	public Boolean getcontainsShowControls();

	/**
	*/
	public String getShowControlsType();

	/**
	*/
	public Boolean getShowControlsHasTypeBoolean();

	/**
	*/
	public Boolean getcontainsStart();

	/**
	*/
	public String getStartType();

	/**
	*/
	public Boolean getStartHasTypeArray();

	/**
	*/
	public Boolean getStartHasTypeInteger();

	/**
	*/
	public Boolean getStartHasTypeStringByte();

	/**
	*/
	public Long getStartIntegerValue();

	/**
	*/
	public Long getStartStringSize();

	/**
	*/
	public Boolean getcontainsSynchronous();

	/**
	*/
	public String getSynchronousType();

	/**
	*/
	public Boolean getSynchronousHasTypeBoolean();

	/**
	*/
	public Boolean getcontainsVolume();

	/**
	*/
	public String getVolumeType();

	/**
	*/
	public Boolean getVolumeHasTypeNumber();

	/**
	*/
	public Double getVolumeNumberValue();

	/**
	*/
	public Double getFWPosition0NumberValue();

	/**
	*/
	public Double getFWPosition1NumberValue();

	/**
	*/
	public Long getFWScale0IntegerValue();

	/**
	*/
	public Long getFWScale1IntegerValue();

	/**
	*/
	public Boolean getFWPosition0HasTypeNumber();

	/**
	*/
	public Boolean getFWPosition1HasTypeNumber();

	/**
	*/
	public Boolean getFWScale0HasTypeInteger();

	/**
	*/
	public Boolean getFWScale1HasTypeInteger();
}
