/*
 * This file is part of VeraPDF Validation Model API for Arlington PDF Model, a module of the veraPDF project.
 * Copyright (c) 2015-2025, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * VeraPDF Validation Model API for Arlington PDF Model is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with VeraPDF Validation Model API for Arlington PDF Model as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * VeraPDF Validation Model API for Arlington PDF Model as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.alayer;
		
import org.verapdf.model.baselayer.Object;

		
/**
*/
public interface APaperMetaData extends AObject {
	

	/**
	*/
	public Boolean getcontainsCaption();

	/**
	*/
	public String getCaptionType();

	/**
	*/
	public Boolean getCaptionHasTypeStringText();

	/**
	*/
	public Boolean getcontainsECC();

	/**
	*/
	public String getECCType();

	/**
	*/
	public Boolean getECCHasTypeInteger();

	/**
	*/
	public Long getECCIntegerValue();

	/**
	*/
	public Boolean getcontainsHeight();

	/**
	*/
	public String getHeightType();

	/**
	*/
	public Boolean getHeightHasTypeNumber();

	/**
	*/
	public Double getHeightNumberValue();

	/**
	*/
	public Boolean getcontainsResolution();

	/**
	*/
	public String getResolutionType();

	/**
	*/
	public Boolean getResolutionHasTypeNumber();

	/**
	*/
	public Double getResolutionNumberValue();

	/**
	*/
	public Boolean getcontainsSymbology();

	/**
	*/
	public String getSymbologyType();

	/**
	*/
	public Boolean getSymbologyHasTypeName();

	/**
	*/
	public String getSymbologyNameValue();

	/**
	*/
	public Boolean getcontainsType();

	/**
	*/
	public String getTypeType();

	/**
	*/
	public Boolean getTypeHasTypeName();

	/**
	*/
	public String getTypeNameValue();

	/**
	*/
	public Boolean getcontainsVersion();

	/**
	*/
	public String getVersionType();

	/**
	*/
	public Boolean getVersionHasTypeNumber();

	/**
	*/
	public Double getVersionNumberValue();

	/**
	*/
	public Boolean getcontainsWidth();

	/**
	*/
	public String getWidthType();

	/**
	*/
	public Boolean getWidthHasTypeNumber();

	/**
	*/
	public Double getWidthNumberValue();

	/**
	*/
	public Boolean getcontainsXSymWidth();

	/**
	*/
	public String getXSymWidthType();

	/**
	*/
	public Boolean getXSymWidthHasTypeInteger();

	/**
	*/
	public Long getXSymWidthIntegerValue();

	/**
	*/
	public Boolean getcontainsYSymHeight();

	/**
	*/
	public String getYSymHeightType();

	/**
	*/
	public Boolean getYSymHeightHasTypeInteger();

	/**
	*/
	public Long getYSymHeightIntegerValue();

	/**
	*/
	public Boolean getcontainsnCodeWordCol();

	/**
	*/
	public String getnCodeWordColType();

	/**
	*/
	public Boolean getnCodeWordColHasTypeNumber();

	/**
	*/
	public Boolean getcontainsnCodeWordRow();

	/**
	*/
	public String getnCodeWordRowType();

	/**
	*/
	public Boolean getnCodeWordRowHasTypeNumber();
}
