/*
 * This file is part of VeraPDF Validation Model API for Arlington PDF Model, a module of the veraPDF project.
 * Copyright (c) 2015-2025, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * VeraPDF Validation Model API for Arlington PDF Model is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with VeraPDF Validation Model API for Arlington PDF Model as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * VeraPDF Validation Model API for Arlington PDF Model as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.pdlayer;
		
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosObject;
import org.verapdf.model.coslayer.CosDict;
import org.verapdf.model.coslayer.CosStream;
import org.verapdf.model.coslayer.CosReal;
import org.verapdf.model.coslayer.CosNumber;
import org.verapdf.model.coslayer.CosRenderingIntent;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.model.coslayer.CosIIFilter;
import org.verapdf.model.coslayer.CosBBox;
import org.verapdf.model.coslayer.CosBM;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.coslayer.CosTextString;
import org.verapdf.model.coslayer.CosActualText;
import org.verapdf.model.coslayer.CosAlt;
import org.verapdf.model.operator.Operator;
import org.verapdf.model.external.ICCOutputProfile;
import org.verapdf.model.external.ICCInputProfile;
import org.verapdf.model.external.FontProgram;
import org.verapdf.model.external.CMapFile;
import org.verapdf.model.external.JPEG2000;
import org.verapdf.model.external.PKCSDataObject;
import org.verapdf.model.xmplayer.XMPPackage;
import org.verapdf.model.selayer.SEContentItem;

		
/**
* PDF font dictionary
*/
public interface PDFont extends PDResource {
	

	/**
	* font type (Type entry)
	*/
	public String getType();

	/**
	* font subtype (Subtype entry)
	*/
	public String getSubtype();

	/**
	* font name defined by BaseFont entry in the font dictionary and FontName key in the font descriptor
	*/
	public String getfontName();


	/**
	* true if the font flags in the font descriptor dictionary mark indicate that the font is symbolic (the entry /Flags has bit 3 set to 1 and bit 6 set to 0)
	*/
	public Boolean getisSymbolic();

	/**
	* rendering mode value
	*/
	public Long getrenderingMode();


	/**
	* true if the font dictionary contains the font program
	*/
	public Boolean getcontainsFontFile();

	/**
	* value of the entry /Subtype in the embedded font file stream, or null, if the this entry is not present (or the font is not embedded)
	*/
	public String getfontFileSubtype();

	/**
	* value of Italic flag in Flags entry in the font descriptor
	*/
	public Boolean getisItalic();
}
