/**
 * This file is part of veraPDF Validation Model API, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation Model API is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation Model API as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation Model API as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.pdlayer;
		
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosObject;
import org.verapdf.model.coslayer.CosDict;
import org.verapdf.model.coslayer.CosStream;
import org.verapdf.model.coslayer.CosReal;
import org.verapdf.model.coslayer.CosNumber;
import org.verapdf.model.coslayer.CosRenderingIntent;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.model.coslayer.CosIIFilter;
import org.verapdf.model.coslayer.CosBBox;
import org.verapdf.model.coslayer.CosBM;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.coslayer.CosActualText;
import org.verapdf.model.operator.Operator;
import org.verapdf.model.external.ICCOutputProfile;
import org.verapdf.model.external.ICCInputProfile;
import org.verapdf.model.external.FontProgram;
import org.verapdf.model.external.CMapFile;
import org.verapdf.model.external.JPEG2000;
import org.verapdf.model.external.PKCSDataObject;
import org.verapdf.model.xmplayer.XMPPackage;
import org.verapdf.model.selayer.SEContentItem;

		
/**  XObject resource
 */
public interface PDXObject extends PDResource {
	

	/**  subtype of the XObject resource (Image, Form, PS)
	 */
	public String getSubtype();

	/**  true if the XObject dictionary contains OPI entry
	 */
	public Boolean getcontainsOPI();

	/**  but ISO 19005-1:2005/Cor.2:2011 forbids SMask key for all XObject dictionaries
	 */
	public Boolean getcontainsSMask();
}
