/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ModelHelper {
    private static final Map<String, String> mapOfSuperNames = new HashMap<String, String>();
    private static final Map<String, List<String>> mapOfProperties = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> mapOfLinks = new HashMap<String, List<String>>();
    private static List<String> properties;
    private static List<String> links;

    private ModelHelper() {
    }

    public static List<String> getListOfSuperNames(String objectName) {
        ArrayList<String> res = new ArrayList<String>();
        String currentObject = mapOfSuperNames.get(objectName);
        while (currentObject != null) {
            res.add(currentObject);
            currentObject = mapOfSuperNames.get(currentObject);
        }
        return res;
    }

    public static Set<String> getTypes() {
        return mapOfSuperNames.keySet();
    }

    public static List<String> getListOfProperties(String objectName) {
        ArrayList<String> res = new ArrayList<String>();
        String currentObject = objectName;
        while (currentObject != null) {
            for (String prop : mapOfProperties.get(currentObject)) {
                res.add(prop);
            }
            currentObject = mapOfSuperNames.get(currentObject);
        }
        return res;
    }

    public static List<String> getListOfLinks(String objectName) {
        ArrayList<String> res = new ArrayList<String>();
        String currentObject = objectName;
        while (currentObject != null) {
            for (String link : mapOfLinks.get(currentObject)) {
                res.add(link);
            }
            currentObject = mapOfSuperNames.get(currentObject);
        }
        return res;
    }

    static {
        mapOfSuperNames.put("Object", null);
        properties = new ArrayList<String>();
        mapOfProperties.put("Object", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("Object", links);
        mapOfSuperNames.put("CosObject", "Object");
        mapOfSuperNames.put("CosDocument", "CosObject");
        mapOfSuperNames.put("CosIndirect", "CosObject");
        mapOfSuperNames.put("CosNull", "CosObject");
        mapOfSuperNames.put("CosBool", "CosObject");
        mapOfSuperNames.put("CosNumber", "CosObject");
        mapOfSuperNames.put("CosReal", "CosNumber");
        mapOfSuperNames.put("CosInteger", "CosNumber");
        mapOfSuperNames.put("CosName", "CosObject");
        mapOfSuperNames.put("CosUnicodeName", "CosName");
        mapOfSuperNames.put("CosRenderingIntent", "CosName");
        mapOfSuperNames.put("CosFilter", "CosName");
        mapOfSuperNames.put("CosIIFilter", "CosName");
        mapOfSuperNames.put("CosString", "CosObject");
        mapOfSuperNames.put("CosLang", "CosString");
        mapOfSuperNames.put("CosDict", "CosObject");
        mapOfSuperNames.put("CosStream", "CosDict");
        mapOfSuperNames.put("CosFileSpecification", "CosDict");
        mapOfSuperNames.put("CosTrailer", "CosDict");
        mapOfSuperNames.put("CosArray", "CosObject");
        mapOfSuperNames.put("CosBBox", "CosArray");
        mapOfSuperNames.put("CosXRef", "CosObject");
        properties = new ArrayList<String>();
        mapOfProperties.put("CosObject", properties);
        properties = new ArrayList<String>();
        properties.add("nrIndirects");
        properties.add("version");
        properties.add("isOptionalContentPresent");
        properties.add("postEOFDataSize");
        properties.add("doesInfoMatchXMP");
        properties.add("firstPageID");
        properties.add("lastID");
        properties.add("isLinearized");
        properties.add("headerOffset");
        properties.add("header");
        properties.add("headerByte1");
        properties.add("headerByte2");
        properties.add("headerByte3");
        properties.add("headerByte4");
        properties.add("Marked");
        properties.add("Requirements");
        properties.add("NeedsRendering");
        properties.add("containsEmbeddedFiles");
        mapOfProperties.put("CosDocument", properties);
        properties = new ArrayList<String>();
        properties.add("spacingCompliesPDFA");
        mapOfProperties.put("CosIndirect", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosNull", properties);
        properties = new ArrayList<String>();
        properties.add("value");
        mapOfProperties.put("CosBool", properties);
        properties = new ArrayList<String>();
        properties.add("stringValue");
        properties.add("intValue");
        properties.add("realValue");
        mapOfProperties.put("CosNumber", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosReal", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosInteger", properties);
        properties = new ArrayList<String>();
        properties.add("internalRepresentation");
        mapOfProperties.put("CosName", properties);
        properties = new ArrayList<String>();
        properties.add("isValidUtf8");
        properties.add("unicodeValue");
        mapOfProperties.put("CosUnicodeName", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosRenderingIntent", properties);
        properties = new ArrayList<String>();
        properties.add("decodeParms");
        mapOfProperties.put("CosFilter", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosIIFilter", properties);
        properties = new ArrayList<String>();
        properties.add("value");
        properties.add("isHex");
        properties.add("containsOnlyHex");
        properties.add("hexCount");
        mapOfProperties.put("CosString", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosLang", properties);
        properties = new ArrayList<String>();
        properties.add("size");
        mapOfProperties.put("CosDict", properties);
        properties = new ArrayList<String>();
        properties.add("Length");
        properties.add("F");
        properties.add("FFilter");
        properties.add("FDecodeParms");
        properties.add("streamKeywordCRLFCompliant");
        properties.add("endstreamKeywordEOLCompliant");
        properties.add("isLengthCorrect");
        mapOfProperties.put("CosStream", properties);
        properties = new ArrayList<String>();
        properties.add("containsEF");
        properties.add("F");
        properties.add("UF");
        properties.add("AFRelationship");
        properties.add("isAssociatedFile");
        mapOfProperties.put("CosFileSpecification", properties);
        properties = new ArrayList<String>();
        properties.add("isEncrypted");
        mapOfProperties.put("CosTrailer", properties);
        properties = new ArrayList<String>();
        properties.add("size");
        mapOfProperties.put("CosArray", properties);
        properties = new ArrayList<String>();
        properties.add("top");
        properties.add("bottom");
        properties.add("left");
        properties.add("right");
        mapOfProperties.put("CosBBox", properties);
        properties = new ArrayList<String>();
        properties.add("subsectionHeaderSpaceSeparated");
        properties.add("xrefEOLMarkersComplyPDFA");
        mapOfProperties.put("CosXRef", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("CosObject", links);
        links = new ArrayList<String>();
        links.add("EmbeddedFiles");
        links.add("xref");
        links.add("trailer");
        links.add("indirectObjects");
        links.add("document");
        mapOfLinks.put("CosDocument", links);
        links = new ArrayList<String>();
        links.add("directObject");
        mapOfLinks.put("CosIndirect", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosNull", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosBool", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosNumber", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosReal", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosInteger", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosName", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosUnicodeName", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosRenderingIntent", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosFilter", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosIIFilter", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosString", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosLang", links);
        links = new ArrayList<String>();
        links.add("keys");
        links.add("values");
        links.add("metadata");
        mapOfLinks.put("CosDict", links);
        links = new ArrayList<String>();
        links.add("filters");
        mapOfLinks.put("CosStream", links);
        links = new ArrayList<String>();
        links.add("EF");
        mapOfLinks.put("CosFileSpecification", links);
        links = new ArrayList<String>();
        links.add("Catalog");
        mapOfLinks.put("CosTrailer", links);
        links = new ArrayList<String>();
        links.add("elements");
        mapOfLinks.put("CosArray", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosBBox", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosXRef", links);
        mapOfSuperNames.put("External", "Object");
        mapOfSuperNames.put("ICCProfile", "External");
        mapOfSuperNames.put("ICCInputProfile", "ICCProfile");
        mapOfSuperNames.put("ICCOutputProfile", "ICCProfile");
        mapOfSuperNames.put("FontProgram", "External");
        mapOfSuperNames.put("TrueTypeFontProgram", "FontProgram");
        mapOfSuperNames.put("CMapFile", "External");
        mapOfSuperNames.put("JPEG2000", "External");
        mapOfSuperNames.put("EmbeddedFile", "External");
        mapOfSuperNames.put("PKCSDataObject", "External");
        properties = new ArrayList<String>();
        mapOfProperties.put("External", properties);
        properties = new ArrayList<String>();
        properties.add("N");
        properties.add("deviceClass");
        properties.add("colorSpace");
        properties.add("version");
        properties.add("isValid");
        mapOfProperties.put("ICCProfile", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("ICCInputProfile", properties);
        properties = new ArrayList<String>();
        properties.add("S");
        mapOfProperties.put("ICCOutputProfile", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("FontProgram", properties);
        properties = new ArrayList<String>();
        properties.add("isSymbolic");
        properties.add("nrCmaps");
        properties.add("cmap30Present");
        properties.add("cmap31Present");
        properties.add("cmap10Present");
        mapOfProperties.put("TrueTypeFontProgram", properties);
        properties = new ArrayList<String>();
        properties.add("WMode");
        properties.add("dictWMode");
        properties.add("maximalCID");
        mapOfProperties.put("CMapFile", properties);
        properties = new ArrayList<String>();
        properties.add("nrColorChannels");
        properties.add("nrColorSpaceSpecs");
        properties.add("nrColorSpacesWithApproxField");
        properties.add("colrMethod");
        properties.add("colrEnumCS");
        properties.add("bitDepth");
        properties.add("bpccBoxPresent");
        mapOfProperties.put("JPEG2000", properties);
        properties = new ArrayList<String>();
        properties.add("Subtype");
        properties.add("isValidPDFA12");
        mapOfProperties.put("EmbeddedFile", properties);
        properties = new ArrayList<String>();
        properties.add("SignerInfoCount");
        properties.add("signingCertificatePresent");
        mapOfProperties.put("PKCSDataObject", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("External", links);
        links = new ArrayList<String>();
        mapOfLinks.put("ICCProfile", links);
        links = new ArrayList<String>();
        mapOfLinks.put("ICCInputProfile", links);
        links = new ArrayList<String>();
        mapOfLinks.put("ICCOutputProfile", links);
        links = new ArrayList<String>();
        mapOfLinks.put("FontProgram", links);
        links = new ArrayList<String>();
        mapOfLinks.put("TrueTypeFontProgram", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CMapFile", links);
        links = new ArrayList<String>();
        mapOfLinks.put("JPEG2000", links);
        links = new ArrayList<String>();
        mapOfLinks.put("EmbeddedFile", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PKCSDataObject", links);
        mapOfSuperNames.put("Operator", "Object");
        mapOfSuperNames.put("OpGeneralGS", "Operator");
        mapOfSuperNames.put("Op_w_line_width", "OpGeneralGS");
        mapOfSuperNames.put("Op_J_line_cap", "OpGeneralGS");
        mapOfSuperNames.put("Op_j_line_join", "OpGeneralGS");
        mapOfSuperNames.put("Op_M_miter_limit", "OpGeneralGS");
        mapOfSuperNames.put("Op_d", "OpGeneralGS");
        mapOfSuperNames.put("Op_ri", "OpGeneralGS");
        mapOfSuperNames.put("Op_i", "OpGeneralGS");
        mapOfSuperNames.put("Op_gs", "OpGeneralGS");
        mapOfSuperNames.put("OpSpecialGS", "Operator");
        mapOfSuperNames.put("Op_q_gsave", "OpSpecialGS");
        mapOfSuperNames.put("Op_Q_grestore", "OpSpecialGS");
        mapOfSuperNames.put("Op_cm", "OpSpecialGS");
        mapOfSuperNames.put("OpPathConstruction", "Operator");
        mapOfSuperNames.put("Op_m_moveto", "OpPathConstruction");
        mapOfSuperNames.put("Op_l", "OpPathConstruction");
        mapOfSuperNames.put("Op_c", "OpPathConstruction");
        mapOfSuperNames.put("Op_v", "OpPathConstruction");
        mapOfSuperNames.put("Op_y", "OpPathConstruction");
        mapOfSuperNames.put("Op_h", "OpPathConstruction");
        mapOfSuperNames.put("Op_re", "OpPathConstruction");
        mapOfSuperNames.put("OpPathPaint", "Operator");
        mapOfSuperNames.put("Op_s_close_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_S_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_f_fill", "OpPathPaint");
        mapOfSuperNames.put("Op_F_fill_obsolete", "OpPathPaint");
        mapOfSuperNames.put("Op_FStar", "OpPathPaint");
        mapOfSuperNames.put("Op_B_fill_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_BStar_eofill_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_b_closepath_fill_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_bstar_closepath_eofill_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_n", "OpPathPaint");
        mapOfSuperNames.put("OpClip", "Operator");
        mapOfSuperNames.put("Op_W_clip", "OpClip");
        mapOfSuperNames.put("Op_WStar", "OpClip");
        mapOfSuperNames.put("OpTextObject", "Operator");
        mapOfSuperNames.put("OpTextState", "Operator");
        mapOfSuperNames.put("Op_Tz", "OpTextState");
        mapOfSuperNames.put("Op_Tr", "OpTextState");
        mapOfSuperNames.put("Op_Tc", "OpTextState");
        mapOfSuperNames.put("Op_Tf", "OpTextState");
        mapOfSuperNames.put("Op_Tl", "OpTextState");
        mapOfSuperNames.put("Op_Ts", "OpTextState");
        mapOfSuperNames.put("Op_Tw", "OpTextState");
        mapOfSuperNames.put("OpTextPosition", "Operator");
        mapOfSuperNames.put("Op_Td", "OpTextPosition");
        mapOfSuperNames.put("Op_TD_Big", "OpTextPosition");
        mapOfSuperNames.put("Op_Tm", "OpTextPosition");
        mapOfSuperNames.put("OpTextShow", "Operator");
        mapOfSuperNames.put("Op_Tj", "OpTextShow");
        mapOfSuperNames.put("Op_TJ_Big", "OpTextShow");
        mapOfSuperNames.put("Op_Quote", "OpTextShow");
        mapOfSuperNames.put("Op_DoubleQuote", "OpTextShow");
        mapOfSuperNames.put("OpType3Font", "Operator");
        mapOfSuperNames.put("Op_d0", "OpType3Font");
        mapOfSuperNames.put("Op_d1", "OpType3Font");
        mapOfSuperNames.put("OpSetColor", "Operator");
        mapOfSuperNames.put("OpColor", "OpSetColor");
        mapOfSuperNames.put("OpShading", "Operator");
        mapOfSuperNames.put("Op_sh", "OpShading");
        mapOfSuperNames.put("OpInlineImage", "Operator");
        mapOfSuperNames.put("Op_BI", "OpInlineImage");
        mapOfSuperNames.put("Op_ID", "OpInlineImage");
        mapOfSuperNames.put("Op_EI", "OpInlineImage");
        mapOfSuperNames.put("OpXObject", "Operator");
        mapOfSuperNames.put("Op_Do", "OpXObject");
        mapOfSuperNames.put("OpMarkedContent", "Operator");
        mapOfSuperNames.put("Op_MP", "OpMarkedContent");
        mapOfSuperNames.put("Op_DP", "OpMarkedContent");
        mapOfSuperNames.put("Op_BMC", "OpMarkedContent");
        mapOfSuperNames.put("Op_BDC", "OpMarkedContent");
        mapOfSuperNames.put("Op_EMC", "OpMarkedContent");
        mapOfSuperNames.put("OpCompatibility", "Operator");
        mapOfSuperNames.put("Op_BX", "OpCompatibility");
        mapOfSuperNames.put("Op_EX", "OpCompatibility");
        mapOfSuperNames.put("Op_Undefined", "OpCompatibility");
        mapOfSuperNames.put("Glyph", "Object");
        mapOfSuperNames.put("CIDGlyph", "Glyph");
        properties = new ArrayList<String>();
        mapOfProperties.put("Operator", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpGeneralGS", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_w_line_width", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_J_line_cap", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_j_line_join", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_M_miter_limit", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_d", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_ri", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_i", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_gs", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpSpecialGS", properties);
        properties = new ArrayList<String>();
        properties.add("nestingLevel");
        mapOfProperties.put("Op_q_gsave", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Q_grestore", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_cm", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpPathConstruction", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_m_moveto", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_l", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_c", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_v", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_y", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_h", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_re", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpPathPaint", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_s_close_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_S_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_f_fill", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_F_fill_obsolete", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_FStar", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_B_fill_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BStar_eofill_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_b_closepath_fill_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_bstar_closepath_eofill_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_n", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpClip", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_W_clip", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_WStar", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpTextObject", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpTextState", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tz", properties);
        properties = new ArrayList<String>();
        properties.add("renderingMode");
        mapOfProperties.put("Op_Tr", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tc", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tf", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tl", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Ts", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tw", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpTextPosition", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Td", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_TD_Big", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tm", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpTextShow", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tj", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_TJ_Big", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Quote", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_DoubleQuote", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpType3Font", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_d0", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_d1", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpSetColor", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpColor", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpShading", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_sh", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpInlineImage", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BI", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_ID", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_EI", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpXObject", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Do", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpMarkedContent", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_MP", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_DP", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BMC", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BDC", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_EMC", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpCompatibility", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BX", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_EX", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Undefined", properties);
        properties = new ArrayList<String>();
        properties.add("name");
        properties.add("isWidthConsistent");
        properties.add("isGlyphPresent");
        properties.add("toUnicode");
        properties.add("renderingMode");
        properties.add("unicodePUA");
        properties.add("actualTextPresent");
        mapOfProperties.put("Glyph", properties);
        properties = new ArrayList<String>();
        properties.add("CID");
        mapOfProperties.put("CIDGlyph", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("Operator", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpGeneralGS", links);
        links = new ArrayList<String>();
        links.add("lineWidth");
        mapOfLinks.put("Op_w_line_width", links);
        links = new ArrayList<String>();
        links.add("lineCap");
        mapOfLinks.put("Op_J_line_cap", links);
        links = new ArrayList<String>();
        links.add("lineJoin");
        mapOfLinks.put("Op_j_line_join", links);
        links = new ArrayList<String>();
        links.add("miterLimit");
        mapOfLinks.put("Op_M_miter_limit", links);
        links = new ArrayList<String>();
        links.add("dashArray");
        links.add("dashPhase");
        mapOfLinks.put("Op_d", links);
        links = new ArrayList<String>();
        links.add("renderingIntent");
        mapOfLinks.put("Op_ri", links);
        links = new ArrayList<String>();
        links.add("flatness");
        mapOfLinks.put("Op_i", links);
        links = new ArrayList<String>();
        links.add("extGState");
        mapOfLinks.put("Op_gs", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpSpecialGS", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_q_gsave", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_Q_grestore", links);
        links = new ArrayList<String>();
        links.add("matrix");
        mapOfLinks.put("Op_cm", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpPathConstruction", links);
        links = new ArrayList<String>();
        links.add("point");
        mapOfLinks.put("Op_m_moveto", links);
        links = new ArrayList<String>();
        links.add("point");
        mapOfLinks.put("Op_l", links);
        links = new ArrayList<String>();
        links.add("controlPoints");
        mapOfLinks.put("Op_c", links);
        links = new ArrayList<String>();
        links.add("controlPoints");
        mapOfLinks.put("Op_v", links);
        links = new ArrayList<String>();
        links.add("controlPoints");
        mapOfLinks.put("Op_y", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_h", links);
        links = new ArrayList<String>();
        links.add("rectBox");
        mapOfLinks.put("Op_re", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpPathPaint", links);
        links = new ArrayList<String>();
        links.add("strokeCS");
        mapOfLinks.put("Op_s_close_stroke", links);
        links = new ArrayList<String>();
        links.add("strokeCS");
        mapOfLinks.put("Op_S_stroke", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        mapOfLinks.put("Op_f_fill", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        mapOfLinks.put("Op_F_fill_obsolete", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        mapOfLinks.put("Op_FStar", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("Op_B_fill_stroke", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("Op_BStar_eofill_stroke", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("Op_b_closepath_fill_stroke", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("Op_bstar_closepath_eofill_stroke", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_n", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpClip", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_W_clip", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_WStar", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpTextObject", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpTextState", links);
        links = new ArrayList<String>();
        links.add("scale");
        mapOfLinks.put("Op_Tz", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_Tr", links);
        links = new ArrayList<String>();
        links.add("charSpace");
        mapOfLinks.put("Op_Tc", links);
        links = new ArrayList<String>();
        links.add("size");
        links.add("fontName");
        mapOfLinks.put("Op_Tf", links);
        links = new ArrayList<String>();
        links.add("leading");
        mapOfLinks.put("Op_Tl", links);
        links = new ArrayList<String>();
        links.add("rise");
        mapOfLinks.put("Op_Ts", links);
        links = new ArrayList<String>();
        links.add("wordSpace");
        mapOfLinks.put("Op_Tw", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpTextPosition", links);
        links = new ArrayList<String>();
        links.add("horizontalOffset");
        links.add("verticalOffset");
        mapOfLinks.put("Op_Td", links);
        links = new ArrayList<String>();
        links.add("horizontalOffset");
        links.add("verticalOffset");
        mapOfLinks.put("Op_TD_Big", links);
        links = new ArrayList<String>();
        links.add("controlPoints");
        mapOfLinks.put("Op_Tm", links);
        links = new ArrayList<String>();
        links.add("font");
        links.add("usedGlyphs");
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("OpTextShow", links);
        links = new ArrayList<String>();
        links.add("showString");
        mapOfLinks.put("Op_Tj", links);
        links = new ArrayList<String>();
        links.add("specialStrings");
        mapOfLinks.put("Op_TJ_Big", links);
        links = new ArrayList<String>();
        links.add("showString");
        mapOfLinks.put("Op_Quote", links);
        links = new ArrayList<String>();
        links.add("showString");
        links.add("wordSpacing");
        links.add("characterSpacing");
        mapOfLinks.put("Op_DoubleQuote", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpType3Font", links);
        links = new ArrayList<String>();
        links.add("horizontalDisplacement");
        links.add("verticalDisplacement");
        mapOfLinks.put("Op_d0", links);
        links = new ArrayList<String>();
        links.add("controlPoints");
        mapOfLinks.put("Op_d1", links);
        links = new ArrayList<String>();
        links.add("colorValues");
        mapOfLinks.put("OpSetColor", links);
        links = new ArrayList<String>();
        links.add("colorSpace");
        links.add("patternName");
        mapOfLinks.put("OpColor", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpShading", links);
        links = new ArrayList<String>();
        links.add("shading");
        mapOfLinks.put("Op_sh", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpInlineImage", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_BI", links);
        links = new ArrayList<String>();
        links.add("inlineImageDictionary");
        mapOfLinks.put("Op_ID", links);
        links = new ArrayList<String>();
        links.add("inlineImage");
        mapOfLinks.put("Op_EI", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpXObject", links);
        links = new ArrayList<String>();
        links.add("xObject");
        mapOfLinks.put("Op_Do", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpMarkedContent", links);
        links = new ArrayList<String>();
        links.add("tag");
        mapOfLinks.put("Op_MP", links);
        links = new ArrayList<String>();
        links.add("tag");
        links.add("properties");
        mapOfLinks.put("Op_DP", links);
        links = new ArrayList<String>();
        links.add("tag");
        mapOfLinks.put("Op_BMC", links);
        links = new ArrayList<String>();
        links.add("tag");
        links.add("properties");
        links.add("Lang");
        mapOfLinks.put("Op_BDC", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_EMC", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpCompatibility", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_BX", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_EX", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_Undefined", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Glyph", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CIDGlyph", links);
        mapOfSuperNames.put("PDObject", "Object");
        mapOfSuperNames.put("PDDocument", "PDObject");
        mapOfSuperNames.put("PDPage", "PDObject");
        mapOfSuperNames.put("PDContentStream", "PDObject");
        mapOfSuperNames.put("PDResource", "PDObject");
        mapOfSuperNames.put("PDColorSpace", "PDResource");
        mapOfSuperNames.put("PDDeviceGray", "PDColorSpace");
        mapOfSuperNames.put("PDDeviceRGB", "PDColorSpace");
        mapOfSuperNames.put("PDDeviceCMYK", "PDColorSpace");
        mapOfSuperNames.put("PDICCBased", "PDColorSpace");
        mapOfSuperNames.put("PDICCBasedCMYK", "PDICCBased");
        mapOfSuperNames.put("PDLab", "PDColorSpace");
        mapOfSuperNames.put("PDCalGray", "PDColorSpace");
        mapOfSuperNames.put("PDCalRGB", "PDColorSpace");
        mapOfSuperNames.put("PDSeparation", "PDColorSpace");
        mapOfSuperNames.put("PDDeviceN", "PDColorSpace");
        mapOfSuperNames.put("PDIndexed", "PDColorSpace");
        mapOfSuperNames.put("PDPattern", "PDColorSpace");
        mapOfSuperNames.put("PDTilingPattern", "PDPattern");
        mapOfSuperNames.put("PDShadingPattern", "PDPattern");
        mapOfSuperNames.put("PDFont", "PDResource");
        mapOfSuperNames.put("PDSimpleFont", "PDFont");
        mapOfSuperNames.put("PDTrueTypeFont", "PDSimpleFont");
        mapOfSuperNames.put("PDType1Font", "PDSimpleFont");
        mapOfSuperNames.put("PDType3Font", "PDSimpleFont");
        mapOfSuperNames.put("PDCIDFont", "PDFont");
        mapOfSuperNames.put("PDType0Font", "PDFont");
        mapOfSuperNames.put("PDCMap", "PDObject");
        mapOfSuperNames.put("PDReferencedCMap", "PDCMap");
        mapOfSuperNames.put("PDXObject", "PDResource");
        mapOfSuperNames.put("PDXImage", "PDXObject");
        mapOfSuperNames.put("PDSMaskImage", "PDXImage");
        mapOfSuperNames.put("PDInlineImage", "PDXImage");
        mapOfSuperNames.put("PDXForm", "PDXObject");
        mapOfSuperNames.put("PDGroup", "PDObject");
        mapOfSuperNames.put("PDExtGState", "PDResource");
        mapOfSuperNames.put("PDHalftone", "PDObject");
        mapOfSuperNames.put("PDShading", "PDResource");
        mapOfSuperNames.put("PDAnnot", "PDObject");
        mapOfSuperNames.put("PDAcroForm", "PDObject");
        mapOfSuperNames.put("PDFormField", "PDObject");
        mapOfSuperNames.put("PDSignatureField", "PDFormField");
        mapOfSuperNames.put("PDSignature", "PDObject");
        mapOfSuperNames.put("PDAction", "PDObject");
        mapOfSuperNames.put("PDNamedAction", "PDAction");
        mapOfSuperNames.put("PDGoToAction", "PDAction");
        mapOfSuperNames.put("PDGoToRemoteAction", "PDGoToAction");
        mapOfSuperNames.put("PDMetadata", "PDObject");
        mapOfSuperNames.put("PDOutputIntent", "PDObject");
        mapOfSuperNames.put("PDOCProperties", "PDObject");
        mapOfSuperNames.put("PDOCConfig", "PDObject");
        mapOfSuperNames.put("PDOutline", "PDObject");
        mapOfSuperNames.put("PDStructTreeRoot", "PDObject");
        mapOfSuperNames.put("PDStructElem", "PDObject");
        mapOfSuperNames.put("PDPerms", "PDObject");
        mapOfSuperNames.put("PDSigRef", "PDObject");
        properties = new ArrayList<String>();
        mapOfProperties.put("PDObject", properties);
        properties = new ArrayList<String>();
        properties.add("containsAlternatePresentations");
        properties.add("validPDF");
        properties.add("containsAA");
        mapOfProperties.put("PDDocument", properties);
        properties = new ArrayList<String>();
        properties.add("containsPresSteps");
        properties.add("containsTransparency");
        properties.add("containsGroupCS");
        properties.add("containsAA");
        mapOfProperties.put("PDPage", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDContentStream", properties);
        properties = new ArrayList<String>();
        properties.add("isInherited");
        mapOfProperties.put("PDResource", properties);
        properties = new ArrayList<String>();
        properties.add("nrComponents");
        mapOfProperties.put("PDColorSpace", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDDeviceGray", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDDeviceRGB", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDDeviceCMYK", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDICCBased", properties);
        properties = new ArrayList<String>();
        properties.add("OPM");
        properties.add("overprintFlag");
        mapOfProperties.put("PDICCBasedCMYK", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDLab", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDCalGray", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDCalRGB", properties);
        properties = new ArrayList<String>();
        properties.add("areTintAndAlternateConsistent");
        mapOfProperties.put("PDSeparation", properties);
        properties = new ArrayList<String>();
        properties.add("areColorantsPresent");
        mapOfProperties.put("PDDeviceN", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDIndexed", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDPattern", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDTilingPattern", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDShadingPattern", properties);
        properties = new ArrayList<String>();
        properties.add("Type");
        properties.add("Subtype");
        properties.add("fontName");
        properties.add("isSymbolic");
        properties.add("renderingMode");
        properties.add("fontFileSubtype");
        mapOfProperties.put("PDFont", properties);
        properties = new ArrayList<String>();
        properties.add("isStandard");
        properties.add("FirstChar");
        properties.add("LastChar");
        properties.add("Widths_size");
        properties.add("Encoding");
        mapOfProperties.put("PDSimpleFont", properties);
        properties = new ArrayList<String>();
        properties.add("differencesAreUnicodeCompliant");
        mapOfProperties.put("PDTrueTypeFont", properties);
        properties = new ArrayList<String>();
        properties.add("CharSet");
        properties.add("charSetListsAllGlyphs");
        mapOfProperties.put("PDType1Font", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDType3Font", properties);
        properties = new ArrayList<String>();
        properties.add("CIDToGIDMap");
        properties.add("cidSetListsAllGlyphs");
        mapOfProperties.put("PDCIDFont", properties);
        properties = new ArrayList<String>();
        properties.add("areRegistryOrderingCompatible");
        properties.add("isSupplementCompatible");
        properties.add("cmapName");
        mapOfProperties.put("PDType0Font", properties);
        properties = new ArrayList<String>();
        properties.add("CMapName");
        mapOfProperties.put("PDCMap", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDReferencedCMap", properties);
        properties = new ArrayList<String>();
        properties.add("Subtype");
        properties.add("containsOPI");
        mapOfProperties.put("PDXObject", properties);
        properties = new ArrayList<String>();
        properties.add("Interpolate");
        properties.add("containsAlternates");
        mapOfProperties.put("PDXImage", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDSMaskImage", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDInlineImage", properties);
        properties = new ArrayList<String>();
        properties.add("Subtype2");
        properties.add("containsPS");
        properties.add("containsRef");
        mapOfProperties.put("PDXForm", properties);
        properties = new ArrayList<String>();
        properties.add("S");
        mapOfProperties.put("PDGroup", properties);
        properties = new ArrayList<String>();
        properties.add("TR");
        properties.add("TR2");
        properties.add("containsHTP");
        properties.add("SMask");
        properties.add("BM");
        properties.add("ca");
        properties.add("CA");
        mapOfProperties.put("PDExtGState", properties);
        properties = new ArrayList<String>();
        properties.add("HalftoneType");
        properties.add("HalftoneName");
        properties.add("colorantName");
        properties.add("TransferFunction");
        mapOfProperties.put("PDHalftone", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDShading", properties);
        properties = new ArrayList<String>();
        properties.add("Subtype");
        properties.add("CA");
        properties.add("F");
        properties.add("AP");
        properties.add("FT");
        properties.add("N_type");
        properties.add("width");
        properties.add("height");
        properties.add("containsA");
        properties.add("containsAA");
        mapOfProperties.put("PDAnnot", properties);
        properties = new ArrayList<String>();
        properties.add("NeedAppearances");
        properties.add("containsXFA");
        mapOfProperties.put("PDAcroForm", properties);
        properties = new ArrayList<String>();
        properties.add("FT");
        properties.add("containsAA");
        mapOfProperties.put("PDFormField", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDSignatureField", properties);
        properties = new ArrayList<String>();
        properties.add("doesByteRangeCoverEntireDocument");
        mapOfProperties.put("PDSignature", properties);
        properties = new ArrayList<String>();
        properties.add("S");
        mapOfProperties.put("PDAction", properties);
        properties = new ArrayList<String>();
        properties.add("N");
        mapOfProperties.put("PDNamedAction", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDGoToAction", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDGoToRemoteAction", properties);
        properties = new ArrayList<String>();
        properties.add("Filter");
        mapOfProperties.put("PDMetadata", properties);
        properties = new ArrayList<String>();
        properties.add("destOutputProfileIndirect");
        properties.add("containsDestOutputProfileRef");
        properties.add("OutputConditionIdentifier");
        properties.add("S");
        mapOfProperties.put("PDOutputIntent", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDOCProperties", properties);
        properties = new ArrayList<String>();
        properties.add("Name");
        properties.add("hasDuplicateName");
        properties.add("AS");
        properties.add("doesOrderContainAllOCGs");
        mapOfProperties.put("PDOCConfig", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDOutline", properties);
        properties = new ArrayList<String>();
        properties.add("topLevelFirstElementStandartType");
        mapOfProperties.put("PDStructTreeRoot", properties);
        properties = new ArrayList<String>();
        properties.add("Type");
        properties.add("standardType");
        mapOfProperties.put("PDStructElem", properties);
        properties = new ArrayList<String>();
        properties.add("containsOtherEntries");
        mapOfProperties.put("PDPerms", properties);
        properties = new ArrayList<String>();
        properties.add("containsDigestEntries");
        properties.add("permsContainDocMDP");
        mapOfProperties.put("PDSigRef", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("PDObject", links);
        links = new ArrayList<String>();
        links.add("outputIntents");
        links.add("pages");
        links.add("metadata");
        links.add("AcroForm");
        links.add("AA");
        links.add("OpenAction");
        links.add("Outlines");
        links.add("OCProperties");
        links.add("StructTreeRoot");
        links.add("Lang");
        links.add("Perms");
        mapOfLinks.put("PDDocument", links);
        links = new ArrayList<String>();
        links.add("annots");
        links.add("AA");
        links.add("contentStream");
        links.add("Group");
        links.add("MediaBox");
        links.add("CropBox");
        links.add("BleedBox");
        links.add("TrimBox");
        links.add("ArtBox");
        mapOfLinks.put("PDPage", links);
        links = new ArrayList<String>();
        links.add("operators");
        mapOfLinks.put("PDContentStream", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDResource", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDColorSpace", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDDeviceGray", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDDeviceRGB", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDDeviceCMYK", links);
        links = new ArrayList<String>();
        links.add("iccProfile");
        mapOfLinks.put("PDICCBased", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDICCBasedCMYK", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDLab", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDCalGray", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDCalRGB", links);
        links = new ArrayList<String>();
        links.add("alternate");
        links.add("colorantName");
        mapOfLinks.put("PDSeparation", links);
        links = new ArrayList<String>();
        links.add("alternate");
        links.add("colorantNames");
        links.add("Colorants");
        mapOfLinks.put("PDDeviceN", links);
        links = new ArrayList<String>();
        links.add("base");
        mapOfLinks.put("PDIndexed", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDPattern", links);
        links = new ArrayList<String>();
        links.add("contentStream");
        mapOfLinks.put("PDTilingPattern", links);
        links = new ArrayList<String>();
        links.add("shading");
        mapOfLinks.put("PDShadingPattern", links);
        links = new ArrayList<String>();
        links.add("BaseFont");
        links.add("fontFile");
        mapOfLinks.put("PDFont", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDSimpleFont", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDTrueTypeFont", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDType1Font", links);
        links = new ArrayList<String>();
        links.add("charStrings");
        mapOfLinks.put("PDType3Font", links);
        links = new ArrayList<String>();
        links.add("CIDSet");
        mapOfLinks.put("PDCIDFont", links);
        links = new ArrayList<String>();
        links.add("DescendantFonts");
        links.add("Encoding");
        mapOfLinks.put("PDType0Font", links);
        links = new ArrayList<String>();
        links.add("UseCMap");
        links.add("embeddedFile");
        mapOfLinks.put("PDCMap", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDReferencedCMap", links);
        links = new ArrayList<String>();
        links.add("SMask");
        mapOfLinks.put("PDXObject", links);
        links = new ArrayList<String>();
        links.add("imageCS");
        links.add("Alternates");
        links.add("Intent");
        links.add("jpxStream");
        mapOfLinks.put("PDXImage", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDSMaskImage", links);
        links = new ArrayList<String>();
        links.add("F");
        mapOfLinks.put("PDInlineImage", links);
        links = new ArrayList<String>();
        links.add("contentStream");
        links.add("Group");
        mapOfLinks.put("PDXForm", links);
        links = new ArrayList<String>();
        links.add("colorSpace");
        mapOfLinks.put("PDGroup", links);
        links = new ArrayList<String>();
        links.add("HT");
        links.add("RI");
        links.add("fontSize");
        mapOfLinks.put("PDExtGState", links);
        links = new ArrayList<String>();
        links.add("halftones");
        mapOfLinks.put("PDHalftone", links);
        links = new ArrayList<String>();
        links.add("colorSpace");
        mapOfLinks.put("PDShading", links);
        links = new ArrayList<String>();
        links.add("appearance");
        links.add("C");
        links.add("IC");
        links.add("A");
        links.add("AA");
        mapOfLinks.put("PDAnnot", links);
        links = new ArrayList<String>();
        links.add("formFields");
        mapOfLinks.put("PDAcroForm", links);
        links = new ArrayList<String>();
        links.add("AA");
        mapOfLinks.put("PDFormField", links);
        links = new ArrayList<String>();
        links.add("V");
        mapOfLinks.put("PDSignatureField", links);
        links = new ArrayList<String>();
        links.add("Contents");
        links.add("Reference");
        mapOfLinks.put("PDSignature", links);
        links = new ArrayList<String>();
        links.add("Next");
        mapOfLinks.put("PDAction", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDNamedAction", links);
        links = new ArrayList<String>();
        links.add("D");
        mapOfLinks.put("PDGoToAction", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDGoToRemoteAction", links);
        links = new ArrayList<String>();
        links.add("XMPPackage");
        links.add("stream");
        mapOfLinks.put("PDMetadata", links);
        links = new ArrayList<String>();
        links.add("destProfile");
        mapOfLinks.put("PDOutputIntent", links);
        links = new ArrayList<String>();
        links.add("D");
        links.add("Configs");
        mapOfLinks.put("PDOCProperties", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDOCConfig", links);
        links = new ArrayList<String>();
        links.add("A");
        mapOfLinks.put("PDOutline", links);
        links = new ArrayList<String>();
        links.add("K");
        links.add("roleMapNames");
        mapOfLinks.put("PDStructTreeRoot", links);
        links = new ArrayList<String>();
        links.add("K");
        links.add("S");
        links.add("Lang");
        mapOfLinks.put("PDStructElem", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDPerms", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDSigRef", links);
        mapOfSuperNames.put("XMPObject", "Object");
        mapOfSuperNames.put("XMPPackage", "XMPObject");
        mapOfSuperNames.put("MainXMPPackage", "XMPPackage");
        mapOfSuperNames.put("XMPProperty", "XMPObject");
        mapOfSuperNames.put("XMPMMHistoryProperty", "XMPProperty");
        mapOfSuperNames.put("XMPMMHistoryResourceEvent", "XMPObject");
        mapOfSuperNames.put("PDFAIdentification", "XMPObject");
        mapOfSuperNames.put("ExtensionSchemaObject", "XMPObject");
        mapOfSuperNames.put("ExtensionSchemasContainer", "XMPObject");
        mapOfSuperNames.put("ExtensionSchemaDefinition", "ExtensionSchemaObject");
        mapOfSuperNames.put("ExtensionSchemaProperty", "ExtensionSchemaObject");
        mapOfSuperNames.put("ExtensionSchemaValueType", "ExtensionSchemaObject");
        mapOfSuperNames.put("ExtensionSchemaField", "ExtensionSchemaObject");
        properties = new ArrayList<String>();
        mapOfProperties.put("XMPObject", properties);
        properties = new ArrayList<String>();
        properties.add("isSerializationValid");
        properties.add("bytes");
        properties.add("encoding");
        mapOfProperties.put("XMPPackage", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("MainXMPPackage", properties);
        properties = new ArrayList<String>();
        properties.add("isPredefinedInXMP2004");
        properties.add("isPredefinedInXMP2005");
        properties.add("isDefinedInCurrentPackage");
        properties.add("isDefinedInMainPackage");
        properties.add("isValueTypeCorrect");
        mapOfProperties.put("XMPProperty", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("XMPMMHistoryProperty", properties);
        properties = new ArrayList<String>();
        properties.add("action");
        properties.add("parameters");
        properties.add("when");
        mapOfProperties.put("XMPMMHistoryResourceEvent", properties);
        properties = new ArrayList<String>();
        properties.add("part");
        properties.add("conformance");
        properties.add("partPrefix");
        properties.add("conformancePrefix");
        properties.add("amdPrefix");
        properties.add("corrPrefix");
        mapOfProperties.put("PDFAIdentification", properties);
        properties = new ArrayList<String>();
        properties.add("containsUndefinedFields");
        mapOfProperties.put("ExtensionSchemaObject", properties);
        properties = new ArrayList<String>();
        properties.add("prefix");
        properties.add("isValidBag");
        mapOfProperties.put("ExtensionSchemasContainer", properties);
        properties = new ArrayList<String>();
        properties.add("isNamespaceURIValidURI");
        properties.add("isPrefixValidText");
        properties.add("isPropertyValidSeq");
        properties.add("isSchemaValidText");
        properties.add("isValueTypeValidSeq");
        properties.add("namespaceURIPrefix");
        properties.add("prefixPrefix");
        properties.add("propertyPrefix");
        properties.add("schemaPrefix");
        properties.add("valueTypePrefix");
        mapOfProperties.put("ExtensionSchemaDefinition", properties);
        properties = new ArrayList<String>();
        properties.add("category");
        properties.add("isCategoryValidText");
        properties.add("isDescriptionValidText");
        properties.add("isNameValidText");
        properties.add("isValueTypeValidText");
        properties.add("isValueTypeDefined");
        properties.add("categoryPrefix");
        properties.add("descriptionPrefix");
        properties.add("namePrefix");
        properties.add("valueTypePrefix");
        mapOfProperties.put("ExtensionSchemaProperty", properties);
        properties = new ArrayList<String>();
        properties.add("isDescriptionValidText");
        properties.add("isFieldValidSeq");
        properties.add("isNamespaceURIValidURI");
        properties.add("isPrefixValidText");
        properties.add("isTypeValidText");
        properties.add("descriptionPrefix");
        properties.add("fieldPrefix");
        properties.add("namespaceURIPrefix");
        properties.add("prefixPrefix");
        properties.add("typePrefix");
        mapOfProperties.put("ExtensionSchemaValueType", properties);
        properties = new ArrayList<String>();
        properties.add("isDescriptionValidText");
        properties.add("isNameValidText");
        properties.add("isValueTypeValidText");
        properties.add("isValueTypeDefined");
        properties.add("descriptionPrefix");
        properties.add("namePrefix");
        properties.add("valueTypePrefix");
        mapOfProperties.put("ExtensionSchemaField", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("XMPObject", links);
        links = new ArrayList<String>();
        links.add("Properties");
        links.add("ExtensionSchemasContainers");
        mapOfLinks.put("XMPPackage", links);
        links = new ArrayList<String>();
        links.add("Identification");
        mapOfLinks.put("MainXMPPackage", links);
        links = new ArrayList<String>();
        mapOfLinks.put("XMPProperty", links);
        links = new ArrayList<String>();
        links.add("ResourceEvents");
        mapOfLinks.put("XMPMMHistoryProperty", links);
        links = new ArrayList<String>();
        mapOfLinks.put("XMPMMHistoryResourceEvent", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDFAIdentification", links);
        links = new ArrayList<String>();
        mapOfLinks.put("ExtensionSchemaObject", links);
        links = new ArrayList<String>();
        links.add("ExtensionSchemaDefinitions");
        mapOfLinks.put("ExtensionSchemasContainer", links);
        links = new ArrayList<String>();
        links.add("ExtensionSchemaProperties");
        links.add("ExtensionSchemaValueTypes");
        mapOfLinks.put("ExtensionSchemaDefinition", links);
        links = new ArrayList<String>();
        mapOfLinks.put("ExtensionSchemaProperty", links);
        links = new ArrayList<String>();
        links.add("ExtensionSchemaFields");
        mapOfLinks.put("ExtensionSchemaValueType", links);
        links = new ArrayList<String>();
        mapOfLinks.put("ExtensionSchemaField", links);
        mapOfSuperNames.put("Object", null);
        properties = new ArrayList<String>();
        mapOfProperties.put("Object", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("Object", links);
        mapOfSuperNames.put("CosObject", "Object");
        mapOfSuperNames.put("CosDocument", "CosObject");
        mapOfSuperNames.put("CosIndirect", "CosObject");
        mapOfSuperNames.put("CosNull", "CosObject");
        mapOfSuperNames.put("CosBool", "CosObject");
        mapOfSuperNames.put("CosNumber", "CosObject");
        mapOfSuperNames.put("CosReal", "CosNumber");
        mapOfSuperNames.put("CosInteger", "CosNumber");
        mapOfSuperNames.put("CosName", "CosObject");
        mapOfSuperNames.put("CosUnicodeName", "CosName");
        mapOfSuperNames.put("CosRenderingIntent", "CosName");
        mapOfSuperNames.put("CosFilter", "CosName");
        mapOfSuperNames.put("CosIIFilter", "CosName");
        mapOfSuperNames.put("CosString", "CosObject");
        mapOfSuperNames.put("CosLang", "CosString");
        mapOfSuperNames.put("CosDict", "CosObject");
        mapOfSuperNames.put("CosStream", "CosDict");
        mapOfSuperNames.put("CosFileSpecification", "CosDict");
        mapOfSuperNames.put("CosTrailer", "CosDict");
        mapOfSuperNames.put("CosArray", "CosObject");
        mapOfSuperNames.put("CosBBox", "CosArray");
        mapOfSuperNames.put("CosXRef", "CosObject");
        properties = new ArrayList<String>();
        mapOfProperties.put("CosObject", properties);
        properties = new ArrayList<String>();
        properties.add("nrIndirects");
        properties.add("version");
        properties.add("isOptionalContentPresent");
        properties.add("postEOFDataSize");
        properties.add("doesInfoMatchXMP");
        properties.add("firstPageID");
        properties.add("lastID");
        properties.add("isLinearized");
        properties.add("headerOffset");
        properties.add("header");
        properties.add("headerByte1");
        properties.add("headerByte2");
        properties.add("headerByte3");
        properties.add("headerByte4");
        properties.add("Marked");
        properties.add("Requirements");
        properties.add("NeedsRendering");
        properties.add("containsEmbeddedFiles");
        mapOfProperties.put("CosDocument", properties);
        properties = new ArrayList<String>();
        properties.add("spacingCompliesPDFA");
        mapOfProperties.put("CosIndirect", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosNull", properties);
        properties = new ArrayList<String>();
        properties.add("value");
        mapOfProperties.put("CosBool", properties);
        properties = new ArrayList<String>();
        properties.add("stringValue");
        properties.add("intValue");
        properties.add("realValue");
        mapOfProperties.put("CosNumber", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosReal", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosInteger", properties);
        properties = new ArrayList<String>();
        properties.add("internalRepresentation");
        mapOfProperties.put("CosName", properties);
        properties = new ArrayList<String>();
        properties.add("isValidUtf8");
        properties.add("unicodeValue");
        mapOfProperties.put("CosUnicodeName", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosRenderingIntent", properties);
        properties = new ArrayList<String>();
        properties.add("decodeParms");
        mapOfProperties.put("CosFilter", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosIIFilter", properties);
        properties = new ArrayList<String>();
        properties.add("value");
        properties.add("isHex");
        properties.add("containsOnlyHex");
        properties.add("hexCount");
        mapOfProperties.put("CosString", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosLang", properties);
        properties = new ArrayList<String>();
        properties.add("size");
        mapOfProperties.put("CosDict", properties);
        properties = new ArrayList<String>();
        properties.add("Length");
        properties.add("F");
        properties.add("FFilter");
        properties.add("FDecodeParms");
        properties.add("streamKeywordCRLFCompliant");
        properties.add("endstreamKeywordEOLCompliant");
        properties.add("isLengthCorrect");
        mapOfProperties.put("CosStream", properties);
        properties = new ArrayList<String>();
        properties.add("containsEF");
        properties.add("F");
        properties.add("UF");
        properties.add("AFRelationship");
        properties.add("isAssociatedFile");
        mapOfProperties.put("CosFileSpecification", properties);
        properties = new ArrayList<String>();
        properties.add("isEncrypted");
        mapOfProperties.put("CosTrailer", properties);
        properties = new ArrayList<String>();
        properties.add("size");
        mapOfProperties.put("CosArray", properties);
        properties = new ArrayList<String>();
        properties.add("top");
        properties.add("bottom");
        properties.add("left");
        properties.add("right");
        mapOfProperties.put("CosBBox", properties);
        properties = new ArrayList<String>();
        properties.add("subsectionHeaderSpaceSeparated");
        properties.add("xrefEOLMarkersComplyPDFA");
        mapOfProperties.put("CosXRef", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("CosObject", links);
        links = new ArrayList<String>();
        links.add("EmbeddedFiles");
        links.add("xref");
        links.add("trailer");
        links.add("indirectObjects");
        links.add("document");
        mapOfLinks.put("CosDocument", links);
        links = new ArrayList<String>();
        links.add("directObject");
        mapOfLinks.put("CosIndirect", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosNull", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosBool", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosNumber", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosReal", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosInteger", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosName", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosUnicodeName", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosRenderingIntent", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosFilter", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosIIFilter", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosString", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosLang", links);
        links = new ArrayList<String>();
        links.add("keys");
        links.add("values");
        links.add("metadata");
        mapOfLinks.put("CosDict", links);
        links = new ArrayList<String>();
        links.add("filters");
        mapOfLinks.put("CosStream", links);
        links = new ArrayList<String>();
        links.add("EF");
        mapOfLinks.put("CosFileSpecification", links);
        links = new ArrayList<String>();
        links.add("Catalog");
        mapOfLinks.put("CosTrailer", links);
        links = new ArrayList<String>();
        links.add("elements");
        mapOfLinks.put("CosArray", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosBBox", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosXRef", links);
        mapOfSuperNames.put("External", "Object");
        mapOfSuperNames.put("ICCProfile", "External");
        mapOfSuperNames.put("ICCInputProfile", "ICCProfile");
        mapOfSuperNames.put("ICCOutputProfile", "ICCProfile");
        mapOfSuperNames.put("FontProgram", "External");
        mapOfSuperNames.put("TrueTypeFontProgram", "FontProgram");
        mapOfSuperNames.put("CMapFile", "External");
        mapOfSuperNames.put("JPEG2000", "External");
        mapOfSuperNames.put("EmbeddedFile", "External");
        mapOfSuperNames.put("PKCSDataObject", "External");
        properties = new ArrayList<String>();
        mapOfProperties.put("External", properties);
        properties = new ArrayList<String>();
        properties.add("N");
        properties.add("deviceClass");
        properties.add("colorSpace");
        properties.add("version");
        properties.add("isValid");
        mapOfProperties.put("ICCProfile", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("ICCInputProfile", properties);
        properties = new ArrayList<String>();
        properties.add("S");
        mapOfProperties.put("ICCOutputProfile", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("FontProgram", properties);
        properties = new ArrayList<String>();
        properties.add("isSymbolic");
        properties.add("nrCmaps");
        properties.add("cmap30Present");
        properties.add("cmap31Present");
        properties.add("cmap10Present");
        mapOfProperties.put("TrueTypeFontProgram", properties);
        properties = new ArrayList<String>();
        properties.add("WMode");
        properties.add("dictWMode");
        properties.add("maximalCID");
        mapOfProperties.put("CMapFile", properties);
        properties = new ArrayList<String>();
        properties.add("nrColorChannels");
        properties.add("nrColorSpaceSpecs");
        properties.add("nrColorSpacesWithApproxField");
        properties.add("colrMethod");
        properties.add("colrEnumCS");
        properties.add("bitDepth");
        properties.add("bpccBoxPresent");
        mapOfProperties.put("JPEG2000", properties);
        properties = new ArrayList<String>();
        properties.add("Subtype");
        properties.add("isValidPDFA12");
        mapOfProperties.put("EmbeddedFile", properties);
        properties = new ArrayList<String>();
        properties.add("SignerInfoCount");
        properties.add("signingCertificatePresent");
        mapOfProperties.put("PKCSDataObject", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("External", links);
        links = new ArrayList<String>();
        mapOfLinks.put("ICCProfile", links);
        links = new ArrayList<String>();
        mapOfLinks.put("ICCInputProfile", links);
        links = new ArrayList<String>();
        mapOfLinks.put("ICCOutputProfile", links);
        links = new ArrayList<String>();
        mapOfLinks.put("FontProgram", links);
        links = new ArrayList<String>();
        mapOfLinks.put("TrueTypeFontProgram", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CMapFile", links);
        links = new ArrayList<String>();
        mapOfLinks.put("JPEG2000", links);
        links = new ArrayList<String>();
        mapOfLinks.put("EmbeddedFile", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PKCSDataObject", links);
        mapOfSuperNames.put("Operator", "Object");
        mapOfSuperNames.put("OpGeneralGS", "Operator");
        mapOfSuperNames.put("Op_w_line_width", "OpGeneralGS");
        mapOfSuperNames.put("Op_J_line_cap", "OpGeneralGS");
        mapOfSuperNames.put("Op_j_line_join", "OpGeneralGS");
        mapOfSuperNames.put("Op_M_miter_limit", "OpGeneralGS");
        mapOfSuperNames.put("Op_d", "OpGeneralGS");
        mapOfSuperNames.put("Op_ri", "OpGeneralGS");
        mapOfSuperNames.put("Op_i", "OpGeneralGS");
        mapOfSuperNames.put("Op_gs", "OpGeneralGS");
        mapOfSuperNames.put("OpSpecialGS", "Operator");
        mapOfSuperNames.put("Op_q_gsave", "OpSpecialGS");
        mapOfSuperNames.put("Op_Q_grestore", "OpSpecialGS");
        mapOfSuperNames.put("Op_cm", "OpSpecialGS");
        mapOfSuperNames.put("OpPathConstruction", "Operator");
        mapOfSuperNames.put("Op_m_moveto", "OpPathConstruction");
        mapOfSuperNames.put("Op_l", "OpPathConstruction");
        mapOfSuperNames.put("Op_c", "OpPathConstruction");
        mapOfSuperNames.put("Op_v", "OpPathConstruction");
        mapOfSuperNames.put("Op_y", "OpPathConstruction");
        mapOfSuperNames.put("Op_h", "OpPathConstruction");
        mapOfSuperNames.put("Op_re", "OpPathConstruction");
        mapOfSuperNames.put("OpPathPaint", "Operator");
        mapOfSuperNames.put("Op_s_close_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_S_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_f_fill", "OpPathPaint");
        mapOfSuperNames.put("Op_F_fill_obsolete", "OpPathPaint");
        mapOfSuperNames.put("Op_FStar", "OpPathPaint");
        mapOfSuperNames.put("Op_B_fill_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_BStar_eofill_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_b_closepath_fill_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_bstar_closepath_eofill_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_n", "OpPathPaint");
        mapOfSuperNames.put("OpClip", "Operator");
        mapOfSuperNames.put("Op_W_clip", "OpClip");
        mapOfSuperNames.put("Op_WStar", "OpClip");
        mapOfSuperNames.put("OpTextObject", "Operator");
        mapOfSuperNames.put("OpTextState", "Operator");
        mapOfSuperNames.put("Op_Tz", "OpTextState");
        mapOfSuperNames.put("Op_Tr", "OpTextState");
        mapOfSuperNames.put("Op_Tc", "OpTextState");
        mapOfSuperNames.put("Op_Tf", "OpTextState");
        mapOfSuperNames.put("Op_Tl", "OpTextState");
        mapOfSuperNames.put("Op_Ts", "OpTextState");
        mapOfSuperNames.put("Op_Tw", "OpTextState");
        mapOfSuperNames.put("OpTextPosition", "Operator");
        mapOfSuperNames.put("Op_Td", "OpTextPosition");
        mapOfSuperNames.put("Op_TD_Big", "OpTextPosition");
        mapOfSuperNames.put("Op_Tm", "OpTextPosition");
        mapOfSuperNames.put("OpTextShow", "Operator");
        mapOfSuperNames.put("Op_Tj", "OpTextShow");
        mapOfSuperNames.put("Op_TJ_Big", "OpTextShow");
        mapOfSuperNames.put("Op_Quote", "OpTextShow");
        mapOfSuperNames.put("Op_DoubleQuote", "OpTextShow");
        mapOfSuperNames.put("OpType3Font", "Operator");
        mapOfSuperNames.put("Op_d0", "OpType3Font");
        mapOfSuperNames.put("Op_d1", "OpType3Font");
        mapOfSuperNames.put("OpSetColor", "Operator");
        mapOfSuperNames.put("OpColor", "OpSetColor");
        mapOfSuperNames.put("OpShading", "Operator");
        mapOfSuperNames.put("Op_sh", "OpShading");
        mapOfSuperNames.put("OpInlineImage", "Operator");
        mapOfSuperNames.put("Op_BI", "OpInlineImage");
        mapOfSuperNames.put("Op_ID", "OpInlineImage");
        mapOfSuperNames.put("Op_EI", "OpInlineImage");
        mapOfSuperNames.put("OpXObject", "Operator");
        mapOfSuperNames.put("Op_Do", "OpXObject");
        mapOfSuperNames.put("OpMarkedContent", "Operator");
        mapOfSuperNames.put("Op_MP", "OpMarkedContent");
        mapOfSuperNames.put("Op_DP", "OpMarkedContent");
        mapOfSuperNames.put("Op_BMC", "OpMarkedContent");
        mapOfSuperNames.put("Op_BDC", "OpMarkedContent");
        mapOfSuperNames.put("Op_EMC", "OpMarkedContent");
        mapOfSuperNames.put("OpCompatibility", "Operator");
        mapOfSuperNames.put("Op_BX", "OpCompatibility");
        mapOfSuperNames.put("Op_EX", "OpCompatibility");
        mapOfSuperNames.put("Op_Undefined", "OpCompatibility");
        mapOfSuperNames.put("Glyph", "Object");
        mapOfSuperNames.put("CIDGlyph", "Glyph");
        properties = new ArrayList<String>();
        mapOfProperties.put("Operator", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpGeneralGS", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_w_line_width", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_J_line_cap", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_j_line_join", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_M_miter_limit", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_d", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_ri", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_i", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_gs", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpSpecialGS", properties);
        properties = new ArrayList<String>();
        properties.add("nestingLevel");
        mapOfProperties.put("Op_q_gsave", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Q_grestore", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_cm", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpPathConstruction", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_m_moveto", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_l", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_c", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_v", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_y", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_h", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_re", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpPathPaint", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_s_close_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_S_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_f_fill", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_F_fill_obsolete", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_FStar", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_B_fill_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BStar_eofill_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_b_closepath_fill_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_bstar_closepath_eofill_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_n", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpClip", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_W_clip", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_WStar", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpTextObject", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpTextState", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tz", properties);
        properties = new ArrayList<String>();
        properties.add("renderingMode");
        mapOfProperties.put("Op_Tr", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tc", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tf", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tl", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Ts", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tw", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpTextPosition", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Td", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_TD_Big", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tm", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpTextShow", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tj", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_TJ_Big", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Quote", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_DoubleQuote", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpType3Font", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_d0", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_d1", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpSetColor", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpColor", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpShading", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_sh", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpInlineImage", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BI", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_ID", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_EI", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpXObject", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Do", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpMarkedContent", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_MP", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_DP", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BMC", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BDC", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_EMC", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpCompatibility", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BX", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_EX", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Undefined", properties);
        properties = new ArrayList<String>();
        properties.add("name");
        properties.add("isWidthConsistent");
        properties.add("isGlyphPresent");
        properties.add("toUnicode");
        properties.add("renderingMode");
        properties.add("unicodePUA");
        properties.add("actualTextPresent");
        mapOfProperties.put("Glyph", properties);
        properties = new ArrayList<String>();
        properties.add("CID");
        mapOfProperties.put("CIDGlyph", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("Operator", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpGeneralGS", links);
        links = new ArrayList<String>();
        links.add("lineWidth");
        mapOfLinks.put("Op_w_line_width", links);
        links = new ArrayList<String>();
        links.add("lineCap");
        mapOfLinks.put("Op_J_line_cap", links);
        links = new ArrayList<String>();
        links.add("lineJoin");
        mapOfLinks.put("Op_j_line_join", links);
        links = new ArrayList<String>();
        links.add("miterLimit");
        mapOfLinks.put("Op_M_miter_limit", links);
        links = new ArrayList<String>();
        links.add("dashArray");
        links.add("dashPhase");
        mapOfLinks.put("Op_d", links);
        links = new ArrayList<String>();
        links.add("renderingIntent");
        mapOfLinks.put("Op_ri", links);
        links = new ArrayList<String>();
        links.add("flatness");
        mapOfLinks.put("Op_i", links);
        links = new ArrayList<String>();
        links.add("extGState");
        mapOfLinks.put("Op_gs", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpSpecialGS", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_q_gsave", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_Q_grestore", links);
        links = new ArrayList<String>();
        links.add("matrix");
        mapOfLinks.put("Op_cm", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpPathConstruction", links);
        links = new ArrayList<String>();
        links.add("point");
        mapOfLinks.put("Op_m_moveto", links);
        links = new ArrayList<String>();
        links.add("point");
        mapOfLinks.put("Op_l", links);
        links = new ArrayList<String>();
        links.add("controlPoints");
        mapOfLinks.put("Op_c", links);
        links = new ArrayList<String>();
        links.add("controlPoints");
        mapOfLinks.put("Op_v", links);
        links = new ArrayList<String>();
        links.add("controlPoints");
        mapOfLinks.put("Op_y", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_h", links);
        links = new ArrayList<String>();
        links.add("rectBox");
        mapOfLinks.put("Op_re", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpPathPaint", links);
        links = new ArrayList<String>();
        links.add("strokeCS");
        mapOfLinks.put("Op_s_close_stroke", links);
        links = new ArrayList<String>();
        links.add("strokeCS");
        mapOfLinks.put("Op_S_stroke", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        mapOfLinks.put("Op_f_fill", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        mapOfLinks.put("Op_F_fill_obsolete", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        mapOfLinks.put("Op_FStar", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("Op_B_fill_stroke", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("Op_BStar_eofill_stroke", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("Op_b_closepath_fill_stroke", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("Op_bstar_closepath_eofill_stroke", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_n", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpClip", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_W_clip", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_WStar", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpTextObject", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpTextState", links);
        links = new ArrayList<String>();
        links.add("scale");
        mapOfLinks.put("Op_Tz", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_Tr", links);
        links = new ArrayList<String>();
        links.add("charSpace");
        mapOfLinks.put("Op_Tc", links);
        links = new ArrayList<String>();
        links.add("size");
        links.add("fontName");
        mapOfLinks.put("Op_Tf", links);
        links = new ArrayList<String>();
        links.add("leading");
        mapOfLinks.put("Op_Tl", links);
        links = new ArrayList<String>();
        links.add("rise");
        mapOfLinks.put("Op_Ts", links);
        links = new ArrayList<String>();
        links.add("wordSpace");
        mapOfLinks.put("Op_Tw", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpTextPosition", links);
        links = new ArrayList<String>();
        links.add("horizontalOffset");
        links.add("verticalOffset");
        mapOfLinks.put("Op_Td", links);
        links = new ArrayList<String>();
        links.add("horizontalOffset");
        links.add("verticalOffset");
        mapOfLinks.put("Op_TD_Big", links);
        links = new ArrayList<String>();
        links.add("controlPoints");
        mapOfLinks.put("Op_Tm", links);
        links = new ArrayList<String>();
        links.add("font");
        links.add("usedGlyphs");
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("OpTextShow", links);
        links = new ArrayList<String>();
        links.add("showString");
        mapOfLinks.put("Op_Tj", links);
        links = new ArrayList<String>();
        links.add("specialStrings");
        mapOfLinks.put("Op_TJ_Big", links);
        links = new ArrayList<String>();
        links.add("showString");
        mapOfLinks.put("Op_Quote", links);
        links = new ArrayList<String>();
        links.add("showString");
        links.add("wordSpacing");
        links.add("characterSpacing");
        mapOfLinks.put("Op_DoubleQuote", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpType3Font", links);
        links = new ArrayList<String>();
        links.add("horizontalDisplacement");
        links.add("verticalDisplacement");
        mapOfLinks.put("Op_d0", links);
        links = new ArrayList<String>();
        links.add("controlPoints");
        mapOfLinks.put("Op_d1", links);
        links = new ArrayList<String>();
        links.add("colorValues");
        mapOfLinks.put("OpSetColor", links);
        links = new ArrayList<String>();
        links.add("colorSpace");
        links.add("patternName");
        mapOfLinks.put("OpColor", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpShading", links);
        links = new ArrayList<String>();
        links.add("shading");
        mapOfLinks.put("Op_sh", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpInlineImage", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_BI", links);
        links = new ArrayList<String>();
        links.add("inlineImageDictionary");
        mapOfLinks.put("Op_ID", links);
        links = new ArrayList<String>();
        links.add("inlineImage");
        mapOfLinks.put("Op_EI", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpXObject", links);
        links = new ArrayList<String>();
        links.add("xObject");
        mapOfLinks.put("Op_Do", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpMarkedContent", links);
        links = new ArrayList<String>();
        links.add("tag");
        mapOfLinks.put("Op_MP", links);
        links = new ArrayList<String>();
        links.add("tag");
        links.add("properties");
        mapOfLinks.put("Op_DP", links);
        links = new ArrayList<String>();
        links.add("tag");
        mapOfLinks.put("Op_BMC", links);
        links = new ArrayList<String>();
        links.add("tag");
        links.add("properties");
        links.add("Lang");
        mapOfLinks.put("Op_BDC", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_EMC", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpCompatibility", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_BX", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_EX", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_Undefined", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Glyph", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CIDGlyph", links);
        mapOfSuperNames.put("PDObject", "Object");
        mapOfSuperNames.put("PDDocument", "PDObject");
        mapOfSuperNames.put("PDPage", "PDObject");
        mapOfSuperNames.put("PDContentStream", "PDObject");
        mapOfSuperNames.put("PDResource", "PDObject");
        mapOfSuperNames.put("PDColorSpace", "PDResource");
        mapOfSuperNames.put("PDDeviceGray", "PDColorSpace");
        mapOfSuperNames.put("PDDeviceRGB", "PDColorSpace");
        mapOfSuperNames.put("PDDeviceCMYK", "PDColorSpace");
        mapOfSuperNames.put("PDICCBased", "PDColorSpace");
        mapOfSuperNames.put("PDICCBasedCMYK", "PDICCBased");
        mapOfSuperNames.put("PDLab", "PDColorSpace");
        mapOfSuperNames.put("PDCalGray", "PDColorSpace");
        mapOfSuperNames.put("PDCalRGB", "PDColorSpace");
        mapOfSuperNames.put("PDSeparation", "PDColorSpace");
        mapOfSuperNames.put("PDDeviceN", "PDColorSpace");
        mapOfSuperNames.put("PDIndexed", "PDColorSpace");
        mapOfSuperNames.put("PDPattern", "PDColorSpace");
        mapOfSuperNames.put("PDTilingPattern", "PDPattern");
        mapOfSuperNames.put("PDShadingPattern", "PDPattern");
        mapOfSuperNames.put("PDFont", "PDResource");
        mapOfSuperNames.put("PDSimpleFont", "PDFont");
        mapOfSuperNames.put("PDTrueTypeFont", "PDSimpleFont");
        mapOfSuperNames.put("PDType1Font", "PDSimpleFont");
        mapOfSuperNames.put("PDType3Font", "PDSimpleFont");
        mapOfSuperNames.put("PDCIDFont", "PDFont");
        mapOfSuperNames.put("PDType0Font", "PDFont");
        mapOfSuperNames.put("PDCMap", "PDObject");
        mapOfSuperNames.put("PDReferencedCMap", "PDCMap");
        mapOfSuperNames.put("PDXObject", "PDResource");
        mapOfSuperNames.put("PDXImage", "PDXObject");
        mapOfSuperNames.put("PDSMaskImage", "PDXImage");
        mapOfSuperNames.put("PDInlineImage", "PDXImage");
        mapOfSuperNames.put("PDXForm", "PDXObject");
        mapOfSuperNames.put("PDGroup", "PDObject");
        mapOfSuperNames.put("PDExtGState", "PDResource");
        mapOfSuperNames.put("PDHalftone", "PDObject");
        mapOfSuperNames.put("PDShading", "PDResource");
        mapOfSuperNames.put("PDAnnot", "PDObject");
        mapOfSuperNames.put("PDAcroForm", "PDObject");
        mapOfSuperNames.put("PDFormField", "PDObject");
        mapOfSuperNames.put("PDSignatureField", "PDFormField");
        mapOfSuperNames.put("PDSignature", "PDObject");
        mapOfSuperNames.put("PDAction", "PDObject");
        mapOfSuperNames.put("PDNamedAction", "PDAction");
        mapOfSuperNames.put("PDGoToAction", "PDAction");
        mapOfSuperNames.put("PDGoToRemoteAction", "PDGoToAction");
        mapOfSuperNames.put("PDMetadata", "PDObject");
        mapOfSuperNames.put("PDOutputIntent", "PDObject");
        mapOfSuperNames.put("PDOCProperties", "PDObject");
        mapOfSuperNames.put("PDOCConfig", "PDObject");
        mapOfSuperNames.put("PDOutline", "PDObject");
        mapOfSuperNames.put("PDStructTreeRoot", "PDObject");
        mapOfSuperNames.put("PDStructElem", "PDObject");
        mapOfSuperNames.put("PDPerms", "PDObject");
        mapOfSuperNames.put("PDSigRef", "PDObject");
        properties = new ArrayList<String>();
        mapOfProperties.put("PDObject", properties);
        properties = new ArrayList<String>();
        properties.add("containsAlternatePresentations");
        properties.add("validPDF");
        properties.add("containsAA");
        mapOfProperties.put("PDDocument", properties);
        properties = new ArrayList<String>();
        properties.add("containsPresSteps");
        properties.add("containsTransparency");
        properties.add("containsGroupCS");
        properties.add("containsAA");
        mapOfProperties.put("PDPage", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDContentStream", properties);
        properties = new ArrayList<String>();
        properties.add("isInherited");
        mapOfProperties.put("PDResource", properties);
        properties = new ArrayList<String>();
        properties.add("nrComponents");
        mapOfProperties.put("PDColorSpace", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDDeviceGray", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDDeviceRGB", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDDeviceCMYK", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDICCBased", properties);
        properties = new ArrayList<String>();
        properties.add("OPM");
        properties.add("overprintFlag");
        mapOfProperties.put("PDICCBasedCMYK", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDLab", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDCalGray", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDCalRGB", properties);
        properties = new ArrayList<String>();
        properties.add("areTintAndAlternateConsistent");
        mapOfProperties.put("PDSeparation", properties);
        properties = new ArrayList<String>();
        properties.add("areColorantsPresent");
        mapOfProperties.put("PDDeviceN", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDIndexed", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDPattern", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDTilingPattern", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDShadingPattern", properties);
        properties = new ArrayList<String>();
        properties.add("Type");
        properties.add("Subtype");
        properties.add("fontName");
        properties.add("isSymbolic");
        properties.add("renderingMode");
        properties.add("fontFileSubtype");
        mapOfProperties.put("PDFont", properties);
        properties = new ArrayList<String>();
        properties.add("isStandard");
        properties.add("FirstChar");
        properties.add("LastChar");
        properties.add("Widths_size");
        properties.add("Encoding");
        mapOfProperties.put("PDSimpleFont", properties);
        properties = new ArrayList<String>();
        properties.add("differencesAreUnicodeCompliant");
        mapOfProperties.put("PDTrueTypeFont", properties);
        properties = new ArrayList<String>();
        properties.add("CharSet");
        properties.add("charSetListsAllGlyphs");
        mapOfProperties.put("PDType1Font", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDType3Font", properties);
        properties = new ArrayList<String>();
        properties.add("CIDToGIDMap");
        properties.add("cidSetListsAllGlyphs");
        mapOfProperties.put("PDCIDFont", properties);
        properties = new ArrayList<String>();
        properties.add("areRegistryOrderingCompatible");
        properties.add("isSupplementCompatible");
        properties.add("cmapName");
        mapOfProperties.put("PDType0Font", properties);
        properties = new ArrayList<String>();
        properties.add("CMapName");
        mapOfProperties.put("PDCMap", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDReferencedCMap", properties);
        properties = new ArrayList<String>();
        properties.add("Subtype");
        properties.add("containsOPI");
        mapOfProperties.put("PDXObject", properties);
        properties = new ArrayList<String>();
        properties.add("Interpolate");
        properties.add("containsAlternates");
        mapOfProperties.put("PDXImage", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDSMaskImage", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDInlineImage", properties);
        properties = new ArrayList<String>();
        properties.add("Subtype2");
        properties.add("containsPS");
        properties.add("containsRef");
        mapOfProperties.put("PDXForm", properties);
        properties = new ArrayList<String>();
        properties.add("S");
        mapOfProperties.put("PDGroup", properties);
        properties = new ArrayList<String>();
        properties.add("TR");
        properties.add("TR2");
        properties.add("containsHTP");
        properties.add("SMask");
        properties.add("BM");
        properties.add("ca");
        properties.add("CA");
        mapOfProperties.put("PDExtGState", properties);
        properties = new ArrayList<String>();
        properties.add("HalftoneType");
        properties.add("HalftoneName");
        properties.add("colorantName");
        properties.add("TransferFunction");
        mapOfProperties.put("PDHalftone", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDShading", properties);
        properties = new ArrayList<String>();
        properties.add("Subtype");
        properties.add("CA");
        properties.add("F");
        properties.add("AP");
        properties.add("FT");
        properties.add("N_type");
        properties.add("width");
        properties.add("height");
        properties.add("containsA");
        properties.add("containsAA");
        mapOfProperties.put("PDAnnot", properties);
        properties = new ArrayList<String>();
        properties.add("NeedAppearances");
        properties.add("containsXFA");
        mapOfProperties.put("PDAcroForm", properties);
        properties = new ArrayList<String>();
        properties.add("FT");
        properties.add("containsAA");
        mapOfProperties.put("PDFormField", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDSignatureField", properties);
        properties = new ArrayList<String>();
        properties.add("doesByteRangeCoverEntireDocument");
        mapOfProperties.put("PDSignature", properties);
        properties = new ArrayList<String>();
        properties.add("S");
        mapOfProperties.put("PDAction", properties);
        properties = new ArrayList<String>();
        properties.add("N");
        mapOfProperties.put("PDNamedAction", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDGoToAction", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDGoToRemoteAction", properties);
        properties = new ArrayList<String>();
        properties.add("Filter");
        mapOfProperties.put("PDMetadata", properties);
        properties = new ArrayList<String>();
        properties.add("destOutputProfileIndirect");
        properties.add("containsDestOutputProfileRef");
        properties.add("OutputConditionIdentifier");
        properties.add("S");
        mapOfProperties.put("PDOutputIntent", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDOCProperties", properties);
        properties = new ArrayList<String>();
        properties.add("Name");
        properties.add("hasDuplicateName");
        properties.add("AS");
        properties.add("doesOrderContainAllOCGs");
        mapOfProperties.put("PDOCConfig", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDOutline", properties);
        properties = new ArrayList<String>();
        properties.add("topLevelFirstElementStandartType");
        mapOfProperties.put("PDStructTreeRoot", properties);
        properties = new ArrayList<String>();
        properties.add("Type");
        properties.add("standardType");
        mapOfProperties.put("PDStructElem", properties);
        properties = new ArrayList<String>();
        properties.add("containsOtherEntries");
        mapOfProperties.put("PDPerms", properties);
        properties = new ArrayList<String>();
        properties.add("containsDigestEntries");
        properties.add("permsContainDocMDP");
        mapOfProperties.put("PDSigRef", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("PDObject", links);
        links = new ArrayList<String>();
        links.add("outputIntents");
        links.add("pages");
        links.add("metadata");
        links.add("AcroForm");
        links.add("AA");
        links.add("OpenAction");
        links.add("Outlines");
        links.add("OCProperties");
        links.add("StructTreeRoot");
        links.add("Lang");
        links.add("Perms");
        mapOfLinks.put("PDDocument", links);
        links = new ArrayList<String>();
        links.add("annots");
        links.add("AA");
        links.add("contentStream");
        links.add("Group");
        links.add("MediaBox");
        links.add("CropBox");
        links.add("BleedBox");
        links.add("TrimBox");
        links.add("ArtBox");
        mapOfLinks.put("PDPage", links);
        links = new ArrayList<String>();
        links.add("operators");
        mapOfLinks.put("PDContentStream", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDResource", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDColorSpace", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDDeviceGray", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDDeviceRGB", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDDeviceCMYK", links);
        links = new ArrayList<String>();
        links.add("iccProfile");
        mapOfLinks.put("PDICCBased", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDICCBasedCMYK", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDLab", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDCalGray", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDCalRGB", links);
        links = new ArrayList<String>();
        links.add("alternate");
        links.add("colorantName");
        mapOfLinks.put("PDSeparation", links);
        links = new ArrayList<String>();
        links.add("alternate");
        links.add("colorantNames");
        links.add("Colorants");
        mapOfLinks.put("PDDeviceN", links);
        links = new ArrayList<String>();
        links.add("base");
        mapOfLinks.put("PDIndexed", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDPattern", links);
        links = new ArrayList<String>();
        links.add("contentStream");
        mapOfLinks.put("PDTilingPattern", links);
        links = new ArrayList<String>();
        links.add("shading");
        mapOfLinks.put("PDShadingPattern", links);
        links = new ArrayList<String>();
        links.add("BaseFont");
        links.add("fontFile");
        mapOfLinks.put("PDFont", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDSimpleFont", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDTrueTypeFont", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDType1Font", links);
        links = new ArrayList<String>();
        links.add("charStrings");
        mapOfLinks.put("PDType3Font", links);
        links = new ArrayList<String>();
        links.add("CIDSet");
        mapOfLinks.put("PDCIDFont", links);
        links = new ArrayList<String>();
        links.add("DescendantFonts");
        links.add("Encoding");
        mapOfLinks.put("PDType0Font", links);
        links = new ArrayList<String>();
        links.add("UseCMap");
        links.add("embeddedFile");
        mapOfLinks.put("PDCMap", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDReferencedCMap", links);
        links = new ArrayList<String>();
        links.add("SMask");
        mapOfLinks.put("PDXObject", links);
        links = new ArrayList<String>();
        links.add("imageCS");
        links.add("Alternates");
        links.add("Intent");
        links.add("jpxStream");
        mapOfLinks.put("PDXImage", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDSMaskImage", links);
        links = new ArrayList<String>();
        links.add("F");
        mapOfLinks.put("PDInlineImage", links);
        links = new ArrayList<String>();
        links.add("contentStream");
        links.add("Group");
        mapOfLinks.put("PDXForm", links);
        links = new ArrayList<String>();
        links.add("colorSpace");
        mapOfLinks.put("PDGroup", links);
        links = new ArrayList<String>();
        links.add("HT");
        links.add("RI");
        links.add("fontSize");
        mapOfLinks.put("PDExtGState", links);
        links = new ArrayList<String>();
        links.add("halftones");
        mapOfLinks.put("PDHalftone", links);
        links = new ArrayList<String>();
        links.add("colorSpace");
        mapOfLinks.put("PDShading", links);
        links = new ArrayList<String>();
        links.add("appearance");
        links.add("C");
        links.add("IC");
        links.add("A");
        links.add("AA");
        mapOfLinks.put("PDAnnot", links);
        links = new ArrayList<String>();
        links.add("formFields");
        mapOfLinks.put("PDAcroForm", links);
        links = new ArrayList<String>();
        links.add("AA");
        mapOfLinks.put("PDFormField", links);
        links = new ArrayList<String>();
        links.add("V");
        mapOfLinks.put("PDSignatureField", links);
        links = new ArrayList<String>();
        links.add("Contents");
        links.add("Reference");
        mapOfLinks.put("PDSignature", links);
        links = new ArrayList<String>();
        links.add("Next");
        mapOfLinks.put("PDAction", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDNamedAction", links);
        links = new ArrayList<String>();
        links.add("D");
        mapOfLinks.put("PDGoToAction", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDGoToRemoteAction", links);
        links = new ArrayList<String>();
        links.add("XMPPackage");
        links.add("stream");
        mapOfLinks.put("PDMetadata", links);
        links = new ArrayList<String>();
        links.add("destProfile");
        mapOfLinks.put("PDOutputIntent", links);
        links = new ArrayList<String>();
        links.add("D");
        links.add("Configs");
        mapOfLinks.put("PDOCProperties", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDOCConfig", links);
        links = new ArrayList<String>();
        links.add("A");
        mapOfLinks.put("PDOutline", links);
        links = new ArrayList<String>();
        links.add("K");
        links.add("roleMapNames");
        mapOfLinks.put("PDStructTreeRoot", links);
        links = new ArrayList<String>();
        links.add("K");
        links.add("S");
        links.add("Lang");
        mapOfLinks.put("PDStructElem", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDPerms", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDSigRef", links);
        mapOfSuperNames.put("XMPObject", "Object");
        mapOfSuperNames.put("XMPPackage", "XMPObject");
        mapOfSuperNames.put("MainXMPPackage", "XMPPackage");
        mapOfSuperNames.put("XMPProperty", "XMPObject");
        mapOfSuperNames.put("XMPMMHistoryProperty", "XMPProperty");
        mapOfSuperNames.put("XMPMMHistoryResourceEvent", "XMPObject");
        mapOfSuperNames.put("PDFAIdentification", "XMPObject");
        mapOfSuperNames.put("ExtensionSchemaObject", "XMPObject");
        mapOfSuperNames.put("ExtensionSchemasContainer", "XMPObject");
        mapOfSuperNames.put("ExtensionSchemaDefinition", "ExtensionSchemaObject");
        mapOfSuperNames.put("ExtensionSchemaProperty", "ExtensionSchemaObject");
        mapOfSuperNames.put("ExtensionSchemaValueType", "ExtensionSchemaObject");
        mapOfSuperNames.put("ExtensionSchemaField", "ExtensionSchemaObject");
        properties = new ArrayList<String>();
        mapOfProperties.put("XMPObject", properties);
        properties = new ArrayList<String>();
        properties.add("isSerializationValid");
        properties.add("bytes");
        properties.add("encoding");
        mapOfProperties.put("XMPPackage", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("MainXMPPackage", properties);
        properties = new ArrayList<String>();
        properties.add("isPredefinedInXMP2004");
        properties.add("isPredefinedInXMP2005");
        properties.add("isDefinedInCurrentPackage");
        properties.add("isDefinedInMainPackage");
        properties.add("isValueTypeCorrect");
        mapOfProperties.put("XMPProperty", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("XMPMMHistoryProperty", properties);
        properties = new ArrayList<String>();
        properties.add("action");
        properties.add("parameters");
        properties.add("when");
        mapOfProperties.put("XMPMMHistoryResourceEvent", properties);
        properties = new ArrayList<String>();
        properties.add("part");
        properties.add("conformance");
        properties.add("partPrefix");
        properties.add("conformancePrefix");
        properties.add("amdPrefix");
        properties.add("corrPrefix");
        mapOfProperties.put("PDFAIdentification", properties);
        properties = new ArrayList<String>();
        properties.add("containsUndefinedFields");
        mapOfProperties.put("ExtensionSchemaObject", properties);
        properties = new ArrayList<String>();
        properties.add("prefix");
        properties.add("isValidBag");
        mapOfProperties.put("ExtensionSchemasContainer", properties);
        properties = new ArrayList<String>();
        properties.add("isNamespaceURIValidURI");
        properties.add("isPrefixValidText");
        properties.add("isPropertyValidSeq");
        properties.add("isSchemaValidText");
        properties.add("isValueTypeValidSeq");
        properties.add("namespaceURIPrefix");
        properties.add("prefixPrefix");
        properties.add("propertyPrefix");
        properties.add("schemaPrefix");
        properties.add("valueTypePrefix");
        mapOfProperties.put("ExtensionSchemaDefinition", properties);
        properties = new ArrayList<String>();
        properties.add("category");
        properties.add("isCategoryValidText");
        properties.add("isDescriptionValidText");
        properties.add("isNameValidText");
        properties.add("isValueTypeValidText");
        properties.add("isValueTypeDefined");
        properties.add("categoryPrefix");
        properties.add("descriptionPrefix");
        properties.add("namePrefix");
        properties.add("valueTypePrefix");
        mapOfProperties.put("ExtensionSchemaProperty", properties);
        properties = new ArrayList<String>();
        properties.add("isDescriptionValidText");
        properties.add("isFieldValidSeq");
        properties.add("isNamespaceURIValidURI");
        properties.add("isPrefixValidText");
        properties.add("isTypeValidText");
        properties.add("descriptionPrefix");
        properties.add("fieldPrefix");
        properties.add("namespaceURIPrefix");
        properties.add("prefixPrefix");
        properties.add("typePrefix");
        mapOfProperties.put("ExtensionSchemaValueType", properties);
        properties = new ArrayList<String>();
        properties.add("isDescriptionValidText");
        properties.add("isNameValidText");
        properties.add("isValueTypeValidText");
        properties.add("isValueTypeDefined");
        properties.add("descriptionPrefix");
        properties.add("namePrefix");
        properties.add("valueTypePrefix");
        mapOfProperties.put("ExtensionSchemaField", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("XMPObject", links);
        links = new ArrayList<String>();
        links.add("Properties");
        links.add("ExtensionSchemasContainers");
        mapOfLinks.put("XMPPackage", links);
        links = new ArrayList<String>();
        links.add("Identification");
        mapOfLinks.put("MainXMPPackage", links);
        links = new ArrayList<String>();
        mapOfLinks.put("XMPProperty", links);
        links = new ArrayList<String>();
        links.add("ResourceEvents");
        mapOfLinks.put("XMPMMHistoryProperty", links);
        links = new ArrayList<String>();
        mapOfLinks.put("XMPMMHistoryResourceEvent", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDFAIdentification", links);
        links = new ArrayList<String>();
        mapOfLinks.put("ExtensionSchemaObject", links);
        links = new ArrayList<String>();
        links.add("ExtensionSchemaDefinitions");
        mapOfLinks.put("ExtensionSchemasContainer", links);
        links = new ArrayList<String>();
        links.add("ExtensionSchemaProperties");
        links.add("ExtensionSchemaValueTypes");
        mapOfLinks.put("ExtensionSchemaDefinition", links);
        links = new ArrayList<String>();
        mapOfLinks.put("ExtensionSchemaProperty", links);
        links = new ArrayList<String>();
        links.add("ExtensionSchemaFields");
        mapOfLinks.put("ExtensionSchemaValueType", links);
        links = new ArrayList<String>();
        mapOfLinks.put("ExtensionSchemaField", links);
    }
}

