/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObjectProxy;
import org.verapdf.features.objects.ImageXObjectFeaturesObjectAdapter;
import org.verapdf.features.pb.tools.PBAdapterHelper;

public class PBImageXObjectFeaturesObjectAdapter
implements ImageXObjectFeaturesObjectAdapter {
    private static final Logger LOGGER = Logger.getLogger(PBImageXObjectFeaturesObjectAdapter.class.getCanonicalName());
    private PDImageXObjectProxy imageXObject;
    private String id;
    private String colorSpaceChild;
    private String maskChild;
    private String sMaskChild;
    private Set<String> alternatesChild;
    private List<String> errors;
    private List<String> filterNames;

    public PBImageXObjectFeaturesObjectAdapter(PDImageXObjectProxy imageXObject, String id, String colorSpaceChild, String maskChild, String sMaskChild, Set<String> alternatesChild) {
        this.imageXObject = imageXObject;
        this.id = id;
        this.colorSpaceChild = colorSpaceChild;
        this.maskChild = maskChild;
        this.sMaskChild = sMaskChild;
        this.alternatesChild = alternatesChild;
        this.errors = new ArrayList<String>();
        this.filterNames = new ArrayList<String>();
        this.init();
    }

    private void init() {
        try {
            List filters = this.imageXObject.getStream().getFilters();
            if (filters != null) {
                for (COSName filter : filters) {
                    this.filterNames.add(filter.getName());
                }
            }
        }
        catch (IOException e) {
            this.errors.add("Can't get image stream filters");
            LOGGER.log(Level.INFO, e.getMessage());
        }
    }

    public String getID() {
        return this.id;
    }

    public Long getWidth() {
        return this.imageXObject == null ? null : Long.valueOf(this.imageXObject.getWidth());
    }

    public Long getHeight() {
        return this.imageXObject == null ? null : Long.valueOf(this.imageXObject.getHeight());
    }

    public String getColorSpaceChild() {
        return this.colorSpaceChild;
    }

    public Long getBitsPerComponent() {
        return this.imageXObject == null ? null : Long.valueOf(this.imageXObject.getBitsPerComponent());
    }

    public boolean getImageMask() {
        return this.imageXObject == null ? false : this.imageXObject.isStencil();
    }

    public String getMaskChild() {
        return this.maskChild;
    }

    public boolean isInterpolate() {
        return this.imageXObject == null ? false : this.imageXObject.getInterpolate();
    }

    public Set<String> getAlternatesChild() {
        return Collections.unmodifiableSet(this.alternatesChild);
    }

    public String getSMaskChild() {
        return this.sMaskChild;
    }

    public Long getStructParent() {
        return this.imageXObject == null ? null : Long.valueOf(this.imageXObject.getStructParent());
    }

    public List<String> getFilters() {
        return Collections.unmodifiableList(this.filterNames);
    }

    public InputStream getMetadata() {
        if (this.imageXObject != null) {
            return PBAdapterHelper.getMetadataStream(this.imageXObject.getMetadata());
        }
        return null;
    }

    public InputStream getRawStreamData() {
        if (this.imageXObject != null) {
            try {
                if (this.imageXObject.getStream() != null && this.imageXObject.getStream().getStream() != null) {
                    return this.imageXObject.getStream().getStream().getFilteredStream();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, e.getMessage());
            }
        }
        return null;
    }

    public boolean isPDFObjectPresent() {
        return this.imageXObject != null;
    }

    public List<String> getErrors() {
        return Collections.emptyList();
    }

    public List<ImageXObjectFeaturesObjectAdapter.StreamFilterAdapter> getFilterAdapters() {
        if (this.imageXObject != null && this.imageXObject.getCOSObject() != null) {
            COSBase base = this.imageXObject.getCOSStream().getDictionaryObject(COSName.DECODE_PARMS);
            ArrayList<PBStreamFilterAdapter> res = new ArrayList<PBStreamFilterAdapter>();
            if (base instanceof COSDictionary) {
                res.add(new PBStreamFilterAdapter(base));
            } else if (base instanceof COSArray) {
                for (COSBase baseElem : (COSArray)base) {
                    if (baseElem instanceof COSDictionary) {
                        res.add(new PBStreamFilterAdapter(baseElem));
                        continue;
                    }
                    res.add(null);
                }
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    class PBStreamFilterAdapter
    implements ImageXObjectFeaturesObjectAdapter.StreamFilterAdapter {
        private COSDictionary base;

        public PBStreamFilterAdapter(COSBase base) {
            this.base = base == null ? new COSDictionary() : (COSDictionary)base;
        }

        public Long getCCITTK() {
            COSBase k = this.base.getDictionaryObject(COSName.K);
            return k instanceof COSInteger ? Long.valueOf(((COSInteger)k).longValue()) : null;
        }

        public boolean getCCITTEndOfLine() {
            COSBase colors = this.base.getDictionaryObject(COSName.COLORS);
            return colors instanceof COSBoolean ? ((COSBoolean)colors).getValue() : false;
        }

        public boolean getCCITTEncodedByteAlign() {
            COSBase bitsPerComponent = this.base.getDictionaryObject(COSName.BITS_PER_COMPONENT);
            return bitsPerComponent instanceof COSBoolean ? ((COSBoolean)bitsPerComponent).getValue() : false;
        }

        public Long getCCITTColumns() {
            COSBase columns = this.base.getDictionaryObject(COSName.COLUMNS);
            return columns instanceof COSInteger ? Long.valueOf(((COSInteger)columns).longValue()) : null;
        }

        public Long getCCITTRows() {
            COSBase rows = this.base.getDictionaryObject(COSName.ROWS);
            return rows instanceof COSInteger ? Long.valueOf(((COSInteger)rows).longValue()) : null;
        }

        public boolean getCCITTEndOfBlock() {
            COSBase endOfBlock = this.base.getDictionaryObject(COSName.getPDFName((String)"EndOfBlock"));
            return endOfBlock instanceof COSBoolean ? ((COSBoolean)endOfBlock).getValue() : true;
        }

        public boolean getCCITTBlackIs1() {
            COSBase blackIs1 = this.base.getDictionaryObject(COSName.BLACK_IS_1);
            return blackIs1 instanceof COSBoolean ? ((COSBoolean)blackIs1).getValue() : false;
        }

        public Long getCCITTDamagedRowsBeforeError() {
            COSBase damgedRowsBeforeError = this.base.getDictionaryObject(COSName.getPDFName((String)"DamagedRowsBeforeError"));
            return damgedRowsBeforeError instanceof COSInteger ? Long.valueOf(((COSInteger)damgedRowsBeforeError).longValue()) : null;
        }

        public Long getDCTColorTransform() {
            COSBase colorTransform = this.base.getDictionaryObject(COSName.getPDFName((String)"ColorTransform"));
            return colorTransform instanceof COSInteger ? Long.valueOf(((COSInteger)colorTransform).longValue()) : null;
        }

        public Long getLZWEarlyChange() {
            COSBase earlyChange = this.base.getDictionaryObject(COSName.EARLY_CHANGE);
            return earlyChange instanceof COSInteger ? Long.valueOf(((COSInteger)earlyChange).longValue()) : null;
        }

        public Long getFlatePredictor() {
            COSBase predictor = this.base.getDictionaryObject(COSName.PREDICTOR);
            return predictor instanceof COSInteger ? Long.valueOf(((COSInteger)predictor).longValue()) : null;
        }

        public Long getFlateColors() {
            COSBase colors = this.base.getDictionaryObject(COSName.COLORS);
            return colors instanceof COSInteger ? Long.valueOf(((COSInteger)colors).longValue()) : null;
        }

        public Long getFlateBitsPerComponent() {
            COSBase bitsPerComponent = this.base.getDictionaryObject(COSName.BITS_PER_COMPONENT);
            return bitsPerComponent instanceof COSInteger ? Long.valueOf(((COSInteger)bitsPerComponent).longValue()) : null;
        }

        public Long getFlateColumns() {
            return ((COSInteger)this.base.getDictionaryObject(COSName.COLUMNS)).longValue();
        }

        public InputStream getJBIG2Global() {
            try {
                if (this.base.getDictionaryObject(COSName.JBIG2_GLOBALS) instanceof COSStream) {
                    return ((COSStream)this.base.getDictionaryObject(COSName.JBIG2_GLOBALS)).getUnfilteredStream();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, e.getMessage());
            }
            return null;
        }

        public boolean hasCryptFilter() {
            return !COSName.IDENTITY.equals((Object)this.base.getCOSName(COSName.NAME));
        }
    }
}

