/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.verapdf.features.objects.LowLvlInfoFeaturesObjectAdapter;
import org.verapdf.features.pb.tools.PBAdapterHelper;

public class PBLowLvlInfoFeaturesObjectAdapter
implements LowLvlInfoFeaturesObjectAdapter {
    private static final Logger LOGGER = Logger.getLogger(PBLowLvlInfoFeaturesObjectAdapter.class);
    private boolean isPresent;
    private double headerVersion;
    private String catalogVersion;
    private int objectsNumber;
    private String creationId;
    private String modId;
    private Set<String> filters;
    private boolean isTagged = false;
    private List<String> errors;
    private static final Map<String, String> filtersAbbreviations;

    public PBLowLvlInfoFeaturesObjectAdapter(COSDocument document) {
        boolean bl = this.isPresent = document != null;
        if (document != null) {
            this.headerVersion = document.getVersion();
            List objects = document.getObjects();
            this.errors = new ArrayList<String>();
            if (objects != null) {
                this.objectsNumber = objects.size();
            }
            this.addDocumentId(document.getDocumentID());
            try {
                COSBase catalog = document.getCatalog().getObject();
                if (catalog instanceof COSDictionary) {
                    COSName name = ((COSDictionary)catalog).getCOSName(COSName.VERSION);
                    this.catalogVersion = name == null ? null : name.getName();
                    COSBase dict = ((COSDictionary)catalog).getDictionaryObject(COSName.STRUCT_TREE_ROOT);
                    this.isTagged = dict instanceof COSDictionary;
                }
            }
            catch (IOException e) {
                LOGGER.debug((Object)"Can not obtain document catalog", (Throwable)e);
                this.errors.add("Can not obtain document catalog");
            }
            this.filters = this.getAllFilters(document);
        }
    }

    private Set<String> getAllFilters(COSDocument document) {
        HashSet<String> res = new HashSet<String>();
        for (COSBase base : document.getObjects()) {
            while (base instanceof COSObject) {
                base = ((COSObject)base).getObject();
            }
            if (!(base instanceof COSStream)) continue;
            try {
                COSStream stream = (COSStream)base;
                try {
                    COSBase baseFilter = stream.getFilters();
                    if (baseFilter == null) continue;
                    PBLowLvlInfoFeaturesObjectAdapter.addFiltersFromBase(res, baseFilter);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException excep) {
                LOGGER.debug((Object)excep);
                this.errors.add(excep.getMessage());
            }
        }
        return res;
    }

    private void addDocumentId(COSArray ids) {
        if (ids != null) {
            this.creationId = PBAdapterHelper.getStringFromBase(ids.get(0));
            this.modId = PBAdapterHelper.getStringFromBase(ids.get(1));
            if (ids.size() != 2 || this.creationId == null || this.modId == null) {
                this.errors.add("Document's ID must be an array of two not null elements");
            }
        }
    }

    private static void addFiltersFromBase(Set<String> res, COSBase base) {
        if (base instanceof COSName) {
            String name = ((COSName)base).getName();
            if (filtersAbbreviations.keySet().contains(name)) {
                name = filtersAbbreviations.get(name);
            }
            res.add(name);
        } else if (base instanceof COSArray) {
            for (COSBase baseElement : (COSArray)base) {
                if (!(baseElement instanceof COSName)) continue;
                String name = ((COSName)baseElement).getName();
                if (filtersAbbreviations.keySet().contains(name)) {
                    name = filtersAbbreviations.get(name);
                }
                res.add(name);
            }
        }
    }

    public double getHeaderVersion() {
        return this.headerVersion;
    }

    public String getCatalogVersion() {
        return this.catalogVersion;
    }

    public int getIndirectObjectsNumber() {
        return this.objectsNumber;
    }

    public String getCreationId() {
        return this.creationId;
    }

    public String getModificationId() {
        return this.modId;
    }

    public boolean isTagged() {
        return this.isTagged;
    }

    public Set<String> getFilters() {
        return this.filters == null ? Collections.emptySet() : Collections.unmodifiableSet(this.filters);
    }

    public boolean isPDFObjectPresent() {
        return this.isPresent;
    }

    public List<String> getErrors() {
        return this.errors == null ? Collections.emptyList() : Collections.unmodifiableList(this.errors);
    }

    static {
        HashMap<String, String> filtersAbbreviationsTemp = new HashMap<String, String>();
        filtersAbbreviationsTemp.put("AHx", "ASCIIHexDecode");
        filtersAbbreviationsTemp.put("A85", "ASCII85Decode");
        filtersAbbreviationsTemp.put("LZW", "LZWDecode");
        filtersAbbreviationsTemp.put("Fl", "FlateDecode");
        filtersAbbreviationsTemp.put("RL", "RunLengthDecode");
        filtersAbbreviationsTemp.put("CCF", "CCITTFaxDecode");
        filtersAbbreviationsTemp.put("DCT", "DCTDecode");
        filtersAbbreviations = Collections.unmodifiableMap(filtersAbbreviationsTemp);
    }
}

