/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.PDJavascriptNameTreeNode;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDDestinationOrAction;
import org.apache.pdfbox.pdmodel.common.PDNameTreeNode;
import org.apache.pdfbox.pdmodel.common.PDPageLabels;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.documentinterchange.markedcontent.PDPropertyList;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontLike;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.apache.pdfbox.pdmodel.graphics.PDPostScriptXObject;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDIndexed;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDGroup;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObjectProxy;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDShadingPattern;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionJavaScript;
import org.apache.pdfbox.pdmodel.interactive.action.PDAnnotationAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.action.PDDocumentCatalogAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.action.PDFormFieldAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.action.PDNavigationNode;
import org.apache.pdfbox.pdmodel.interactive.action.PDPageAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceEntry;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDNonTerminalField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.verapdf.features.AbstractFeaturesExtractor;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureExtractorConfig;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesReporter;
import org.verapdf.features.objects.ActionFeaturesObjectAdapter;
import org.verapdf.features.objects.FeaturesObject;
import org.verapdf.features.pb.PBFeaturesObjectCreator;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public final class PBFeatureParser {
    private static final EnumSet<FeatureObjectType> XOBJECTS = EnumSet.of(FeatureObjectType.FORM_XOBJECT, FeatureObjectType.IMAGE_XOBJECT, FeatureObjectType.POSTSCRIPT_XOBJECT);
    private static final Logger LOGGER = Logger.getLogger(PBFeatureParser.class.getCanonicalName());
    private static final String ID = "id";
    private static final String DEVICEGRAY_ID = "devgray";
    private static final String DEVICERGB_ID = "devrgb";
    private static final String DEVICECMYK_ID = "devcmyk";
    private FeaturesReporter reporter;
    private FeatureExtractorConfig config;
    private Set<String> processedIDs;

    private PBFeatureParser(FeaturesReporter reporter, FeatureExtractorConfig config) {
        this.reporter = reporter;
        this.config = config;
        this.processedIDs = new HashSet<String>();
    }

    public static FeatureExtractionResult getFeaturesCollection(PDDocument document, FeatureExtractorConfig config) {
        FeaturesReporter reporter = new FeaturesReporter(config);
        return PBFeatureParser.getFeatures(document, reporter, config);
    }

    public static FeatureExtractionResult getFeaturesCollection(PDDocument document, List<AbstractFeaturesExtractor> extractors, FeatureExtractorConfig config) {
        FeaturesReporter reporter = new FeaturesReporter(config, extractors);
        return PBFeatureParser.getFeatures(document, reporter, config);
    }

    private static FeatureExtractionResult getFeatures(PDDocument document, FeaturesReporter reporter, FeatureExtractorConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Features config can not be null");
        }
        if (document != null) {
            PBFeatureParser parser = new PBFeatureParser(reporter, config);
            parser.parseDocumentFeatures(document);
        }
        return reporter.getCollection();
    }

    private void parseDocumentFeatures(PDDocument document) {
        this.reporter.report((FeaturesObject)PBFeaturesObjectCreator.createInfoDictFeaturesObject(document.getDocumentInformation()));
        this.reporter.report((FeaturesObject)PBFeaturesObjectCreator.createDocSecurityFeaturesObject(document.getEncryption()));
        PDDocumentCatalog catalog = document.getDocumentCatalog();
        if (catalog != null) {
            this.getCatalogFeatures(catalog);
        }
        this.reporter.report((FeaturesObject)PBFeaturesObjectCreator.createLowLvlInfoFeaturesObject(document.getDocument()));
    }

    private void getCatalogFeatures(PDDocumentCatalog catalog) {
        PDAcroForm acroForm;
        PDEmbeddedFilesNameTreeNode embeddedFiles;
        this.reporter.report((FeaturesObject)PBFeaturesObjectCreator.createMetadataFeaturesObject(catalog.getMetadata()));
        PDDocumentOutline documentOutline = catalog.getDocumentOutline();
        this.reporter.report((FeaturesObject)PBFeaturesObjectCreator.createOutlinesFeaturesObject(documentOutline));
        PDDocumentNameDictionary names = catalog.getNames();
        if (this.config.isFeatureEnabled(FeatureObjectType.ACTION)) {
            PDJavascriptNameTreeNode javaScript;
            if (documentOutline != null) {
                for (PDOutlineItem item : documentOutline.children()) {
                    this.reportOutlinesActions(item);
                }
            }
            try {
                PDDestinationOrAction openAction = catalog.getOpenAction();
                if (openAction instanceof PDAction) {
                    this.reportAction((PDAction)openAction, ActionFeaturesObjectAdapter.Location.DOCUMENT);
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "Can't get open action. " + e.getMessage());
            }
            PDDocumentCatalogAdditionalActions additionalActions = catalog.getActions();
            if (additionalActions != null) {
                this.reportAction(additionalActions.getDP(), ActionFeaturesObjectAdapter.Location.DOCUMENT);
                this.reportAction(additionalActions.getDS(), ActionFeaturesObjectAdapter.Location.DOCUMENT);
                this.reportAction(additionalActions.getWS(), ActionFeaturesObjectAdapter.Location.DOCUMENT);
                this.reportAction(additionalActions.getWC(), ActionFeaturesObjectAdapter.Location.DOCUMENT);
                this.reportAction(additionalActions.getWP(), ActionFeaturesObjectAdapter.Location.DOCUMENT);
            }
            if (names != null && (javaScript = names.getJavaScript()) != null) {
                this.reportJavaScripts((PDNameTreeNode<PDActionJavaScript>)javaScript);
            }
        }
        if (this.config.isFeatureEnabled(FeatureObjectType.EMBEDDED_FILE) && names != null && (embeddedFiles = names.getEmbeddedFiles()) != null) {
            this.reportEmbeddedFiles(embeddedFiles);
        }
        if ((acroForm = catalog.getAcroForm()) != null) {
            this.getAcroFormFeatures(acroForm);
        }
        if (catalog.getOutputIntents() != null) {
            for (PDOutputIntent outInt : catalog.getOutputIntents()) {
                String iccProfileID = this.addICCProfileFromOutputIntent(outInt);
                if (!this.config.isFeatureEnabled(FeatureObjectType.ICCPROFILE)) {
                    iccProfileID = null;
                }
                this.reporter.report((FeaturesObject)PBFeaturesObjectCreator.createOutputIntentFeaturesObject(outInt, iccProfileID));
            }
        }
        PDPageLabels labels = null;
        try {
            labels = catalog.getPageLabels();
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Can't get page labels. " + e.getMessage());
            this.reporter.getCollection().addNewError(FeatureObjectType.PAGE, "Can't get page labels");
        }
        PDPageTree pageTree = catalog.getPages();
        if (pageTree != null) {
            this.getPageTreeFeatures(pageTree, labels);
        }
    }

    private void reportOutlinesActions(PDOutlineItem outline) {
        if (outline != null) {
            this.reportAction(outline.getAction(), ActionFeaturesObjectAdapter.Location.OUTLINES);
            for (PDOutlineItem item : outline.children()) {
                this.reportOutlinesActions(item);
            }
        }
    }

    private void reportAction(PDAction action, ActionFeaturesObjectAdapter.Location location) {
        if (action != null) {
            this.reporter.report((FeaturesObject)PBFeaturesObjectCreator.createActionFeaturesObject(action, location));
            List actionNext = action.getNext();
            if (actionNext != null) {
                for (PDAction next : actionNext) {
                    this.reportAction(next, location);
                }
            }
        }
    }

    private void getAcroFormFeatures(PDAcroForm acroForm) {
        List fields = acroForm.getFields();
        if (fields != null) {
            for (PDField field : fields) {
                this.getSignatureFeatures(field);
                this.getRootFormFieldFeatures(field);
            }
        }
    }

    private void getRootFormFieldFeatures(PDField field) {
        if (field == null) {
            return;
        }
        if (this.config.isFeatureEnabled(FeatureObjectType.INTERACTIVE_FORM_FIELDS)) {
            this.reporter.report((FeaturesObject)PBFeaturesObjectCreator.createInteractiveFormFieldFeaturesObject(field));
        }
        if (this.config.isFeatureEnabled(FeatureObjectType.ACTION)) {
            this.getFormFieldActions(field);
        }
    }

    private void getFormFieldActions(PDField field) {
        List children;
        PDFormFieldAdditionalActions actions = field.getActions();
        if (actions != null) {
            this.reportAction(actions.getK(), ActionFeaturesObjectAdapter.Location.INTERACTIVE_FORM_FIELD);
            this.reportAction(actions.getC(), ActionFeaturesObjectAdapter.Location.INTERACTIVE_FORM_FIELD);
            this.reportAction(actions.getF(), ActionFeaturesObjectAdapter.Location.INTERACTIVE_FORM_FIELD);
            this.reportAction(actions.getV(), ActionFeaturesObjectAdapter.Location.INTERACTIVE_FORM_FIELD);
        }
        if (field instanceof PDNonTerminalField && (children = ((PDNonTerminalField)field).getChildren()) != null) {
            for (PDField child : children) {
                if (child == null) continue;
                this.getFormFieldActions(child);
            }
        }
    }

    private void getSignatureFeatures(PDField field) {
        PDSignature signature;
        if (this.config.isFeatureEnabled(FeatureObjectType.SIGNATURE) && field instanceof PDSignatureField && (signature = ((PDSignatureField)field).getSignature()) != null) {
            this.reporter.report((FeaturesObject)PBFeaturesObjectCreator.createSignatureFeaturesObject(signature));
        }
    }

    private void getPageTreeFeatures(PDPageTree pageTree, PDPageLabels pageLabels) {
        String[] labels = pageLabels == null ? null : pageLabels.getLabelsByPageIndices();
        for (PDPage page : pageTree) {
            COSBase baseThumb;
            this.reportPageActions(page);
            Set<String> annotsId = this.addAnnotsDependencies(page);
            annotsId = this.config.isFeatureEnabled(FeatureObjectType.ANNOTATION) ? annotsId : null;
            String thumbID = null;
            if (page.getCOSObject().getDictionaryObject(COSName.getPDFName((String)"Thumb")) != null && this.checkIDBeforeProcess(thumbID = this.getId(baseThumb = page.getCOSObject().getItem(COSName.getPDFName((String)"Thumb")), FeatureObjectType.IMAGE_XOBJECT))) {
                COSBase base = PBFeatureParser.getBase(baseThumb);
                if (base instanceof COSStream) {
                    PDImageXObjectProxy img = new PDImageXObjectProxy(new PDStream((COSStream)base), null);
                    this.parseImageXObject(img, thumbID);
                } else {
                    this.xobjectCreationProblem(thumbID, "Thumb is not a stream");
                }
            }
            thumbID = this.config.isAnyFeatureEnabled(XOBJECTS) ? thumbID : null;
            PDResources resources = page.getResources();
            Set<String> extGStateChild = this.config.isFeatureEnabled(FeatureObjectType.EXT_G_STATE) ? this.parseExGStateFromResource(resources) : null;
            Set<String> colorSpaceChild = this.config.isFeatureEnabled(FeatureObjectType.COLORSPACE) ? this.parseColorSpaceFromResources(resources) : null;
            Set<String> patternChild = this.config.isFeatureEnabled(FeatureObjectType.PATTERN) ? this.parsePatternFromResource(resources) : null;
            Set<String> shadingChild = this.config.isFeatureEnabled(FeatureObjectType.SHADING) ? this.parseShadingFromResource(resources) : null;
            Set<String> xobjectChild = this.config.isAnyFeatureEnabled(XOBJECTS) ? this.parseXObjectFromResources(resources) : null;
            Set<String> fontChild = this.config.isFeatureEnabled(FeatureObjectType.FONT) ? this.parseFontFromResources(resources) : null;
            Set<String> propertiesChild = this.config.isFeatureEnabled(FeatureObjectType.PROPERTIES) ? this.parsePropertiesFromResources(resources) : null;
            int pageIndex = pageTree.indexOf(page);
            String label = labels != null && pageIndex < labels.length ? labels[pageIndex] : null;
            this.reporter.report((FeaturesObject)PBFeaturesObjectCreator.createPageFeaturesObject(page, label, thumbID, annotsId, extGStateChild, colorSpaceChild, patternChild, shadingChild, xobjectChild, fontChild, propertiesChild, pageIndex));
        }
    }

    private void reportPageActions(PDPage page) {
        if (this.config.isFeatureEnabled(FeatureObjectType.ACTION)) {
            PDPageAdditionalActions additionalActions = page.getActions();
            if (additionalActions != null) {
                this.reportAction(additionalActions.getC(), ActionFeaturesObjectAdapter.Location.PAGE);
                this.reportAction(additionalActions.getO(), ActionFeaturesObjectAdapter.Location.PAGE);
            }
            HashSet<COSObjectKey> visitedKeys = new HashSet<COSObjectKey>();
            this.processNavigationNodeActions(page.getPresSteps(), visitedKeys);
        }
    }

    private void processNavigationNodeActions(PDNavigationNode navNode, Set<COSObjectKey> visitedKeys) {
        if (navNode != null) {
            COSObjectKey objectKey = navNode.getCOSObject().getKey();
            if (visitedKeys.contains(objectKey)) {
                return;
            }
            visitedKeys.add(objectKey);
            this.reportAction(navNode.getNA(), ActionFeaturesObjectAdapter.Location.PAGE);
            this.reportAction(navNode.getPA(), ActionFeaturesObjectAdapter.Location.PAGE);
            this.processNavigationNodeActions(navNode.getNext(), visitedKeys);
            this.processNavigationNodeActions(navNode.getPrev(), visitedKeys);
        }
    }

    private Set<String> addAnnotsDependencies(PDPage page) {
        COSArray annotsArray = (COSArray)page.getCOSObject().getDictionaryObject(COSName.ANNOTS);
        if (annotsArray == null) {
            return Collections.emptySet();
        }
        HashSet<String> annotsId = new HashSet<String>();
        for (int i = 0; i < annotsArray.size(); ++i) {
            COSBase item = annotsArray.get(i);
            if (item == null) continue;
            String id = this.getId(item, FeatureObjectType.ANNOTATION);
            annotsId.add(id);
            if (!this.checkIDBeforeProcess(id)) continue;
            COSBase base = PBFeatureParser.getBase(item);
            try {
                PDAnnotation annotation = PDAnnotation.createAnnotation((COSBase)base);
                this.reportAnnotationActions(annotation);
                COSBase pop = annotation.getCOSObject().getItem(COSName.getPDFName((String)"Popup"));
                String popupID = null;
                if (pop != null) {
                    popupID = this.addPopup(pop);
                }
                Set<String> formsIDs = this.getAnnotationResourcesDependencies(annotation);
                popupID = this.config.isFeatureEnabled(FeatureObjectType.ANNOTATION) ? popupID : null;
                formsIDs = this.config.isAnyFeatureEnabled(XOBJECTS) ? formsIDs : null;
                this.reporter.report((FeaturesObject)PBFeaturesObjectCreator.createAnnotFeaturesObject(annotation, id, popupID, formsIDs));
                continue;
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "Unknown annotation type detected. " + e.getMessage());
                this.generateUnknownAnnotation(id);
            }
        }
        return annotsId;
    }

    private void reportAnnotationActions(PDAnnotation annot) {
        if (this.config.isFeatureEnabled(FeatureObjectType.ACTION) && annot != null) {
            this.reportAction(annot.getA(), ActionFeaturesObjectAdapter.Location.ANNOTATION);
            PDAnnotationAdditionalActions additionalActions = annot.getAdditionalActions();
            if (additionalActions != null) {
                this.reportAction(additionalActions.getBl(), ActionFeaturesObjectAdapter.Location.ANNOTATION);
                this.reportAction(additionalActions.getD(), ActionFeaturesObjectAdapter.Location.ANNOTATION);
                this.reportAction(additionalActions.getE(), ActionFeaturesObjectAdapter.Location.ANNOTATION);
                this.reportAction(additionalActions.getFo(), ActionFeaturesObjectAdapter.Location.ANNOTATION);
                this.reportAction(additionalActions.getPC(), ActionFeaturesObjectAdapter.Location.ANNOTATION);
                this.reportAction(additionalActions.getPI(), ActionFeaturesObjectAdapter.Location.ANNOTATION);
                this.reportAction(additionalActions.getPO(), ActionFeaturesObjectAdapter.Location.ANNOTATION);
                this.reportAction(additionalActions.getPV(), ActionFeaturesObjectAdapter.Location.ANNOTATION);
                this.reportAction(additionalActions.getU(), ActionFeaturesObjectAdapter.Location.ANNOTATION);
                this.reportAction(additionalActions.getX(), ActionFeaturesObjectAdapter.Location.ANNOTATION);
            }
        }
    }

    private String addPopup(COSBase item) {
        String id = this.getId(item, FeatureObjectType.ANNOTATION);
        if (this.checkIDBeforeProcess(id)) {
            COSBase base = PBFeatureParser.getBase(item);
            try {
                PDAnnotation annotation = PDAnnotation.createAnnotation((COSBase)base);
                this.reportAnnotationActions(annotation);
                this.reporter.report((FeaturesObject)PBFeaturesObjectCreator.createAnnotFeaturesObject(annotation, id, null, null));
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "Unknown annotation type detected. " + e.getMessage());
                this.generateUnknownAnnotation(id);
            }
        }
        return id;
    }

    private Set<String> getAnnotationResourcesDependencies(PDAnnotation annot) {
        PDAppearanceDictionary dic = annot.getAppearance();
        HashSet<String> appearances = new HashSet<String>();
        if (dic != null) {
            COSBase baseDown;
            COSBase baseRollover;
            COSBase baseNormal = dic.getCOSObject().getItem(COSName.N);
            if (baseNormal != null) {
                appearances.addAll(this.getAppearanceEntryDependencies(dic.getNormalAppearance(), baseNormal));
            }
            if ((baseRollover = dic.getCOSObject().getItem(COSName.R)) != null) {
                appearances.addAll(this.getAppearanceEntryDependencies(dic.getRolloverAppearance(), baseRollover));
            }
            if ((baseDown = dic.getCOSObject().getItem(COSName.D)) != null) {
                appearances.addAll(this.getAppearanceEntryDependencies(dic.getDownAppearance(), baseDown));
            }
        }
        return appearances;
    }

    private Set<String> getAppearanceEntryDependencies(PDAppearanceEntry entry, COSBase entryLink) {
        HashSet<String> res = new HashSet<String>();
        if (entry.isStream()) {
            res.add(this.getAppearanceStreamDependencies(entry.getAppearanceStream(), entryLink));
        } else {
            for (Map.Entry mapEntry : entry.getSubDictionary().entrySet()) {
                res.add(this.getAppearanceStreamDependencies((PDAppearanceStream)mapEntry.getValue(), ((COSDictionary)entry.getCOSObject()).getItem((COSName)mapEntry.getKey())));
            }
        }
        return res;
    }

    private String getAppearanceStreamDependencies(PDAppearanceStream stream, COSBase entryLink) {
        String id = this.getId(entryLink, FeatureObjectType.FORM_XOBJECT);
        if (this.checkIDBeforeProcess(id)) {
            this.parseFormXObject((PDFormXObject)stream, id);
        }
        return id;
    }

    private void generateUnknownAnnotation(String id) {
        if (this.config.isFeatureEnabled(FeatureObjectType.ANNOTATION)) {
            FeatureTreeNode annot = FeatureTreeNode.createRootNode((String)FeatureObjectType.ANNOTATION.getNodeName());
            annot.setAttribute(ID, id);
            ErrorsHelper.addErrorIntoCollection((FeatureExtractionResult)this.reporter.getCollection(), (FeatureTreeNode)annot, (String)"Unknown annotation type");
            this.reporter.getCollection().addNewFeatureTree(FeatureObjectType.ANNOTATION, annot);
        }
    }

    private void reportEmbeddedFiles(PDEmbeddedFilesNameTreeNode efTree) {
        int index = 0;
        try {
            if (efTree.getNames() != null) {
                for (PDComplexFileSpecification file : efTree.getNames().values()) {
                    this.reporter.report((FeaturesObject)PBFeaturesObjectCreator.createEmbeddedFileFeaturesObject(file, ++index));
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Error creating PDFBox SubType. " + e.getMessage());
            this.handleSubtypeCreationProblem(e.getMessage());
        }
        if (efTree.getKids() != null) {
            for (PDNameTreeNode tree : efTree.getKids()) {
                if (tree == null) continue;
                index = this.reportEmbeddedFileNode((PDNameTreeNode<PDComplexFileSpecification>)tree, index);
            }
        }
    }

    private void reportJavaScripts(PDNameTreeNode<PDActionJavaScript> node) {
        try {
            Map names = node.getNames();
            if (names != null) {
                for (PDActionJavaScript value : names.values()) {
                    if (value == null) continue;
                    this.reportAction((PDAction)value, ActionFeaturesObjectAdapter.Location.DOCUMENT);
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Can't get values. " + e.getMessage());
        }
        List kids = node.getKids();
        if (kids != null) {
            for (PDNameTreeNode kid : kids) {
                this.reportJavaScripts((PDNameTreeNode<PDActionJavaScript>)kid);
            }
        }
    }

    private int reportEmbeddedFileNode(PDNameTreeNode<PDComplexFileSpecification> node, int index) {
        int res = index;
        try {
            if (this.config.isFeatureEnabled(FeatureObjectType.EMBEDDED_FILE) && node.getNames() != null) {
                for (PDComplexFileSpecification file : node.getNames().values()) {
                    if (file == null) continue;
                    this.reporter.report((FeaturesObject)PBFeaturesObjectCreator.createEmbeddedFileFeaturesObject(file, ++res));
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Subtype creation exception caught. " + e.getMessage());
            this.handleSubtypeCreationProblem(e.getMessage());
        }
        if (node.getKids() != null) {
            for (PDNameTreeNode tree : node.getKids()) {
                res = this.reportEmbeddedFileNode((PDNameTreeNode<PDComplexFileSpecification>)tree, res);
            }
        }
        return res;
    }

    private String addICCProfileFromOutputIntent(PDOutputIntent outInt) {
        COSBase outIntBase = outInt.getCOSObject();
        if (outIntBase instanceof COSDictionary) {
            COSDictionary outIntDict = (COSDictionary)outIntBase;
            String iccProfileID = this.getId(outIntDict.getItem(COSName.DEST_OUTPUT_PROFILE), FeatureObjectType.ICCPROFILE);
            if (this.checkIDBeforeProcess(iccProfileID)) {
                this.reporter.report((FeaturesObject)PBFeaturesObjectCreator.createICCProfileFeaturesObject(outInt.getDestOutputIntent(), iccProfileID));
            }
            return iccProfileID;
        }
        return null;
    }

    private void handleSubtypeCreationProblem(String errorMessage) {
        this.creationProblem(null, errorMessage, FeatureObjectType.EMBEDDED_FILE, true);
    }

    private void fontCreationProblem(String nodeID, String errorMessage) {
        this.creationProblem(nodeID, errorMessage, FeatureObjectType.FONT, false);
    }

    private void patternCreationProblem(String nodeID, String errorMessage) {
        this.creationProblem(nodeID, errorMessage, FeatureObjectType.PATTERN, false);
    }

    private void colorSpaceCreationProblem(String nodeID, String errorMessage) {
        this.creationProblem(nodeID, errorMessage, FeatureObjectType.COLORSPACE, false);
    }

    private void shadingCreationProblem(String nodeID, String errorMessage) {
        this.creationProblem(nodeID, errorMessage, FeatureObjectType.SHADING, false);
    }

    private void xobjectCreationProblem(String nodeID, String errorMessage) {
        this.creationProblem(nodeID, errorMessage, FeatureObjectType.FORM_XOBJECT, false);
    }

    private void creationProblem(String nodeID, String errorMessage, FeatureObjectType type, boolean isTypeError) {
        if (this.config.isFeatureEnabled(type)) {
            if (!isTypeError) {
                FeatureTreeNode node = this.createNodeWithType(type);
                if (nodeID != null) {
                    node.setAttribute(ID, nodeID);
                }
                this.reporter.getCollection().addNewFeatureTree(type, node);
                ErrorsHelper.addErrorIntoCollection((FeatureExtractionResult)this.reporter.getCollection(), (FeatureTreeNode)node, (String)errorMessage);
            } else {
                String id = ErrorsHelper.addErrorIntoCollection((FeatureExtractionResult)this.reporter.getCollection(), null, (String)errorMessage);
                this.reporter.getCollection().addNewError(type, id);
            }
        }
    }

    private FeatureTreeNode createNodeWithType(FeatureObjectType type) {
        if (type == FeatureObjectType.FORM_XOBJECT) {
            FeatureTreeNode res = FeatureTreeNode.createRootNode((String)"xobject");
            res.setAttribute("type", "form");
            return res;
        }
        return FeatureTreeNode.createRootNode((String)type.getNodeName());
    }

    private Set<String> parseColorSpaceFromResources(PDResources resources) {
        if (resources == null || resources.getXObjectNames() == null) {
            return null;
        }
        HashSet<String> colorSpaceIDs = new HashSet<String>();
        for (COSName name : resources.getColorSpaceNames()) {
            COSDictionary dict = (COSDictionary)resources.getCOSObject().getDictionaryObject(COSName.COLORSPACE);
            COSBase base = dict.getItem(name);
            String id = this.getId(base, FeatureObjectType.COLORSPACE);
            try {
                PDColorSpace colorSpace = resources.getColorSpace(name);
                id = PBFeatureParser.checkColorSpaceID(id, colorSpace);
                colorSpaceIDs.add(id);
                if (!this.checkIDBeforeProcess(id)) continue;
                this.parseColorSpace(colorSpace, id);
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, e.getMessage());
                this.colorSpaceCreationProblem(id, e.getMessage());
            }
        }
        return colorSpaceIDs;
    }

    private Set<String> parseXObjectFromResources(PDResources resources) {
        if (resources == null || resources.getXObjectNames() == null) {
            return null;
        }
        HashSet<String> xobjectsIDs = new HashSet<String>();
        for (COSName name : resources.getXObjectNames()) {
            COSDictionary dict = (COSDictionary)resources.getCOSObject().getDictionaryObject(COSName.XOBJECT);
            COSBase base = dict.getItem(name);
            String id = this.getId(base, FeatureObjectType.IMAGE_XOBJECT);
            xobjectsIDs.add(id);
            if (!this.checkIDBeforeProcess(id)) continue;
            try {
                PDXObject xobj = resources.getXObject(name);
                if (xobj instanceof PDImageXObjectProxy) {
                    this.parseImageXObject((PDImageXObjectProxy)xobj, id);
                    continue;
                }
                if (xobj instanceof PDFormXObject) {
                    this.parseFormXObject((PDFormXObject)xobj, id);
                    continue;
                }
                if (!(xobj instanceof PDPostScriptXObject)) continue;
                this.reporter.report((FeaturesObject)PBFeaturesObjectCreator.createPostScriptXObjectFeaturesObject(id));
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, e.getMessage());
                this.xobjectCreationProblem(id, e.getMessage());
            }
        }
        return xobjectsIDs;
    }

    private Set<String> parsePropertiesFromResources(PDResources resources) {
        if (resources == null || resources.getPropertiesNames() == null) {
            return null;
        }
        HashSet<String> propertiesIDs = new HashSet<String>();
        for (COSName name : resources.getPropertiesNames()) {
            COSDictionary dict = (COSDictionary)resources.getCOSObject().getDictionaryObject(COSName.PROPERTIES);
            COSBase base = dict.getItem(name);
            String id = this.getId(base, FeatureObjectType.PROPERTIES);
            propertiesIDs.add(id);
            if (!this.checkIDBeforeProcess(id)) continue;
            PDPropertyList property = resources.getProperties(name);
            this.reporter.report((FeaturesObject)PBFeaturesObjectCreator.createPropertiesDictFeaturesObject(property.getCOSObject(), id));
        }
        return propertiesIDs;
    }

    private Set<String> parseFontFromResources(PDResources resources) {
        if (resources == null || resources.getFontNames() == null) {
            return null;
        }
        HashSet<String> fontIDs = new HashSet<String>();
        for (COSName name : resources.getFontNames()) {
            COSDictionary dict = (COSDictionary)resources.getCOSObject().getDictionaryObject(COSName.FONT);
            COSBase base = dict.getItem(name);
            String id = this.getId(base, FeatureObjectType.FONT);
            fontIDs.add(id);
            if (!this.checkIDBeforeProcess(id)) continue;
            try {
                PDFont font = resources.getFont(name);
                this.parseFont((PDFontLike)font, id);
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, e.getMessage());
                this.fontCreationProblem(id, e.getMessage());
            }
        }
        return fontIDs;
    }

    private Set<String> parseExGStateFromResource(PDResources resources) {
        if (resources == null || resources.getExtGStateNames() == null) {
            return null;
        }
        HashSet<String> gStatesIDs = new HashSet<String>();
        for (COSName name : resources.getExtGStateNames()) {
            COSDictionary dict = (COSDictionary)resources.getCOSObject().getDictionaryObject(COSName.EXT_G_STATE);
            COSBase base = dict.getItem(name);
            String id = this.getId(base, FeatureObjectType.EXT_G_STATE);
            gStatesIDs.add(id);
            if (!this.checkIDBeforeProcess(id)) continue;
            PDExtendedGraphicsState exGState = resources.getExtGState(name);
            this.parseExGState(exGState, id);
        }
        return gStatesIDs;
    }

    private Set<String> parsePatternFromResource(PDResources resources) {
        if (resources == null || resources.getPatternNames() == null) {
            return null;
        }
        HashSet<String> patternIDs = new HashSet<String>();
        for (COSName name : resources.getPatternNames()) {
            COSDictionary dict = (COSDictionary)resources.getCOSObject().getDictionaryObject(COSName.PATTERN);
            COSBase base = dict.getItem(name);
            String id = this.getId(base, FeatureObjectType.PATTERN);
            patternIDs.add(id);
            if (!this.checkIDBeforeProcess(id)) continue;
            try {
                PDAbstractPattern pattern = resources.getPattern(name);
                this.parsePattern(pattern, id);
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, e.getMessage());
                this.patternCreationProblem(id, e.getMessage());
            }
        }
        return patternIDs;
    }

    private Set<String> parseShadingFromResource(PDResources resources) {
        if (resources == null || resources.getShadingNames() == null) {
            return null;
        }
        HashSet<String> shadingIDs = new HashSet<String>();
        for (COSName name : resources.getShadingNames()) {
            COSDictionary dict = (COSDictionary)resources.getCOSObject().getDictionaryObject(COSName.SHADING);
            COSBase base = dict.getItem(name);
            String id = this.getId(base, FeatureObjectType.SHADING);
            shadingIDs.add(id);
            if (!this.checkIDBeforeProcess(id)) continue;
            try {
                PDShading shading = resources.getShading(name);
                this.parseShading(shading, id);
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, e.getMessage());
                this.shadingCreationProblem(id, e.getMessage());
            }
        }
        return shadingIDs;
    }

    private void parseImageXObject(PDImageXObjectProxy xobj, String id) {
        COSBase sMaskBase;
        COSBase maskBase;
        COSBase baseColorSpace = ((COSStream)xobj.getCOSObject()).getItem(COSName.CS);
        if (baseColorSpace == null) {
            baseColorSpace = ((COSStream)xobj.getCOSObject()).getItem(COSName.COLORSPACE);
        }
        String idColorSpace = this.getId(baseColorSpace, FeatureObjectType.COLORSPACE);
        try {
            PDColorSpace colorSpace = xobj.getColorSpace();
            idColorSpace = PBFeatureParser.checkColorSpaceID(idColorSpace, colorSpace);
            if (this.checkIDBeforeProcess(idColorSpace)) {
                this.parseColorSpace(colorSpace, idColorSpace);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, e.getMessage());
            this.colorSpaceCreationProblem(idColorSpace, e.getMessage());
        }
        String idMask = null;
        COSBase mask = xobj.getCOSStream().getDictionaryObject(COSName.MASK);
        if (mask instanceof COSStream && this.checkIDBeforeProcess(idMask = this.getId(maskBase = ((COSStream)xobj.getCOSObject()).getItem(COSName.MASK), FeatureObjectType.IMAGE_XOBJECT))) {
            try {
                PDImageXObjectProxy imxobj = xobj.getMask();
                this.parseImageXObject(imxobj, idMask);
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, e.getMessage());
                this.xobjectCreationProblem(idMask, e.getMessage());
            }
        }
        String idSMask = null;
        COSBase sMask = xobj.getCOSStream().getDictionaryObject(COSName.SMASK);
        if (sMask instanceof COSStream && this.checkIDBeforeProcess(idSMask = this.getId(sMaskBase = ((COSStream)xobj.getCOSObject()).getItem(COSName.SMASK), FeatureObjectType.IMAGE_XOBJECT))) {
            try {
                PDImageXObjectProxy imxobj = xobj.getSoftMask();
                this.parseImageXObject(imxobj, idSMask);
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, e.getMessage());
                this.xobjectCreationProblem(idSMask, e.getMessage());
            }
        }
        COSBase alternates = xobj.getCOSStream().getDictionaryObject(COSName.getPDFName((String)"Alternates"));
        alternates = PBFeatureParser.getBase(alternates);
        HashSet<String> alternatesIDs = new HashSet<String>();
        if (alternates instanceof COSArray) {
            COSArray alternatesArray = (COSArray)alternates;
            for (COSBase entry : alternatesArray) {
                COSBase base = PBFeatureParser.getBase(entry);
                if (!(base instanceof COSDictionary)) continue;
                COSDictionary altDict = (COSDictionary)base;
                COSBase baseImage = altDict.getItem(COSName.IMAGE);
                String idImage = this.getId(baseImage, FeatureObjectType.IMAGE_XOBJECT);
                if (!((baseImage = PBFeatureParser.getBase(baseImage)) instanceof COSStream)) continue;
                alternatesIDs.add(idImage);
                if (!this.checkIDBeforeProcess(idImage)) continue;
                PDImageXObjectProxy im = new PDImageXObjectProxy(new PDStream((COSStream)baseImage), null);
                this.parseImageXObject(im, idImage);
            }
        }
        String string = idColorSpace = this.config.isFeatureEnabled(FeatureObjectType.COLORSPACE) ? idColorSpace : null;
        if (!this.config.isAnyFeatureEnabled(XOBJECTS)) {
            idMask = null;
            idSMask = null;
            alternatesIDs = null;
        }
        this.reporter.report((FeaturesObject)PBFeaturesObjectCreator.createImageXObjectFeaturesObject(xobj, id, idColorSpace, idMask, idSMask, alternatesIDs));
    }

    private void parseFormXObject(PDFormXObject xobj, String id) {
        PDGroup group = xobj.getGroup();
        String idColorSpace = null;
        if (group != null && COSName.TRANSPARENCY.equals((Object)group.getSubType())) {
            COSBase baseColorSpace = group.getCOSObject().getItem(COSName.CS);
            idColorSpace = this.getId(baseColorSpace, FeatureObjectType.COLORSPACE);
            try {
                PDColorSpace colorSpace = group.getColorSpace();
                idColorSpace = PBFeatureParser.checkColorSpaceID(idColorSpace, colorSpace);
                if (this.checkIDBeforeProcess(idColorSpace)) {
                    this.parseColorSpace(colorSpace, idColorSpace);
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, e.getMessage());
                this.colorSpaceCreationProblem(idColorSpace, e.getMessage());
            }
        }
        PDResources resources = xobj.getResources();
        Set<String> extGStateChild = this.parseExGStateFromResource(resources);
        extGStateChild = this.config.isFeatureEnabled(FeatureObjectType.EXT_G_STATE) ? extGStateChild : null;
        Set<String> colorSpaceChild = this.parseColorSpaceFromResources(resources);
        if (!this.config.isFeatureEnabled(FeatureObjectType.COLORSPACE)) {
            idColorSpace = null;
            colorSpaceChild = null;
        }
        Set<String> patternChild = this.config.isFeatureEnabled(FeatureObjectType.PATTERN) ? this.parsePatternFromResource(resources) : null;
        Set<String> shadingChild = this.config.isFeatureEnabled(FeatureObjectType.SHADING) ? this.parseShadingFromResource(resources) : null;
        Set<String> xobjectChild = this.config.isAnyFeatureEnabled(XOBJECTS) ? this.parseXObjectFromResources(resources) : null;
        Set<String> fontChild = this.config.isFeatureEnabled(FeatureObjectType.FONT) ? this.parseFontFromResources(resources) : null;
        Set<String> propertiesChild = this.config.isFeatureEnabled(FeatureObjectType.PROPERTIES) ? this.parsePropertiesFromResources(resources) : null;
        this.reporter.report((FeaturesObject)PBFeaturesObjectCreator.createFormXObjectFeaturesObject(xobj, id, idColorSpace, extGStateChild, colorSpaceChild, patternChild, shadingChild, xobjectChild, fontChild, propertiesChild));
    }

    private void parseExGState(PDExtendedGraphicsState exGState, String id) {
        String childFontID = null;
        if (exGState.getFontSetting() != null && exGState.getFontSetting().getCOSObject() instanceof COSArray && this.checkIDBeforeProcess(childFontID = this.getId(((COSArray)exGState.getFontSetting().getCOSObject()).get(0), FeatureObjectType.FONT))) {
            try {
                PDFont font = exGState.getFontSetting().getFont();
                this.parseFont((PDFontLike)font, childFontID);
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, e.getMessage());
                this.fontCreationProblem(childFontID, e.getMessage());
            }
        }
        childFontID = this.config.isFeatureEnabled(FeatureObjectType.FONT) ? childFontID : null;
        this.reporter.report((FeaturesObject)PBFeaturesObjectCreator.createExtGStateFeaturesObject(exGState, id, childFontID));
    }

    private void parsePattern(PDAbstractPattern pattern, String id) throws IOException {
        if (pattern instanceof PDTilingPattern) {
            PDTilingPattern tilingPattern = (PDTilingPattern)pattern;
            PDResources resources = tilingPattern.getResources();
            Set<String> extGStateChild = this.config.isFeatureEnabled(FeatureObjectType.EXT_G_STATE) ? this.parseExGStateFromResource(resources) : null;
            Set<String> colorSpaceChild = this.config.isFeatureEnabled(FeatureObjectType.COLORSPACE) ? this.parseColorSpaceFromResources(resources) : null;
            Set<String> patternChild = this.config.isFeatureEnabled(FeatureObjectType.PATTERN) ? this.parsePatternFromResource(resources) : null;
            Set<String> shadingChild = this.config.isFeatureEnabled(FeatureObjectType.SHADING) ? this.parseShadingFromResource(resources) : null;
            Set<String> xobjectChild = this.config.isAnyFeatureEnabled(XOBJECTS) ? this.parseXObjectFromResources(resources) : null;
            Set<String> fontChild = this.config.isFeatureEnabled(FeatureObjectType.FONT) ? this.parseFontFromResources(resources) : null;
            Set<String> propertiesChild = this.config.isFeatureEnabled(FeatureObjectType.PROPERTIES) ? this.parsePropertiesFromResources(resources) : null;
            this.reporter.report((FeaturesObject)PBFeaturesObjectCreator.createTilingPatternFeaturesObject(tilingPattern, id, extGStateChild, colorSpaceChild, patternChild, shadingChild, xobjectChild, fontChild, propertiesChild));
        } else {
            COSBase baseExGState;
            String exGStateID;
            PDShadingPattern shadingPattern = (PDShadingPattern)pattern;
            COSBase baseShading = shadingPattern.getCOSObject().getItem(COSName.SHADING);
            String shadingID = this.getId(baseShading, FeatureObjectType.SHADING);
            if (this.checkIDBeforeProcess(shadingID) && shadingPattern.getShading() != null) {
                this.parseShading(shadingPattern.getShading(), shadingID);
            }
            if (this.checkIDBeforeProcess(exGStateID = this.getId(baseExGState = shadingPattern.getCOSObject().getItem(COSName.EXT_G_STATE), FeatureObjectType.EXT_G_STATE)) && shadingPattern.getExtendedGraphicsState() != null) {
                this.parseExGState(shadingPattern.getExtendedGraphicsState(), exGStateID);
            }
            shadingID = this.config.isFeatureEnabled(FeatureObjectType.SHADING) ? shadingID : null;
            exGStateID = this.config.isFeatureEnabled(FeatureObjectType.EXT_G_STATE) ? exGStateID : null;
            this.reporter.report((FeaturesObject)PBFeaturesObjectCreator.createShadingPatternFeaturesObject(shadingPattern, id, shadingID, exGStateID));
        }
    }

    private void parseShading(PDShading shading, String id) {
        COSBase base = shading.getCOSObject().getItem(COSName.CS);
        if (base == null) {
            base = shading.getCOSObject().getItem(COSName.COLORSPACE);
        }
        String colorspaceID = this.getId(base, FeatureObjectType.COLORSPACE);
        try {
            PDColorSpace colorSpace = shading.getColorSpace();
            colorspaceID = PBFeatureParser.checkColorSpaceID(colorspaceID, colorSpace);
            if (this.checkIDBeforeProcess(colorspaceID)) {
                this.parseColorSpace(colorSpace, colorspaceID);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, e.getMessage());
            this.colorSpaceCreationProblem(colorspaceID, e.getMessage());
        }
        colorspaceID = this.config.isFeatureEnabled(FeatureObjectType.COLORSPACE) ? colorspaceID : null;
        this.reporter.report((FeaturesObject)PBFeaturesObjectCreator.createShadingFeaturesObject(shading, id, colorspaceID));
    }

    private void parseFont(PDFontLike font, String id) {
        if (font instanceof PDType3Font) {
            PDResources resources = ((PDType3Font)font).getResources();
            Set<String> extGStateChild = this.config.isFeatureEnabled(FeatureObjectType.EXT_G_STATE) ? this.parseExGStateFromResource(resources) : null;
            Set<String> colorSpaceChild = this.config.isFeatureEnabled(FeatureObjectType.COLORSPACE) ? this.parseColorSpaceFromResources(resources) : null;
            Set<String> patternChild = this.config.isFeatureEnabled(FeatureObjectType.PATTERN) ? this.parsePatternFromResource(resources) : null;
            Set<String> shadingChild = this.config.isFeatureEnabled(FeatureObjectType.SHADING) ? this.parseShadingFromResource(resources) : null;
            Set<String> xobjectChild = this.config.isAnyFeatureEnabled(XOBJECTS) ? this.parseXObjectFromResources(resources) : null;
            Set<String> fontChild = this.config.isFeatureEnabled(FeatureObjectType.FONT) ? this.parseFontFromResources(resources) : null;
            Set<String> propertiesChild = this.config.isFeatureEnabled(FeatureObjectType.PROPERTIES) ? this.parsePropertiesFromResources(resources) : null;
            this.reporter.report((FeaturesObject)PBFeaturesObjectCreator.createFontFeaturesObject(font, id, extGStateChild, colorSpaceChild, patternChild, shadingChild, xobjectChild, fontChild, propertiesChild));
        } else if (font instanceof PDType0Font) {
            PDType0Font type0 = (PDType0Font)font;
            COSBase descendantFontsBase = type0.getCOSObject().getDictionaryObject(COSName.DESCENDANT_FONTS);
            if (descendantFontsBase instanceof COSArray) {
                COSBase descendantFontDictionaryBase = ((COSArray)descendantFontsBase).getObject(0);
                String descendantID = this.getId(descendantFontDictionaryBase, FeatureObjectType.FONT);
                if (this.checkIDBeforeProcess(descendantID)) {
                    this.parseFont((PDFontLike)type0.getDescendantFont(), descendantID);
                }
                HashSet<String> descendant = null;
                if (this.config.isFeatureEnabled(FeatureObjectType.FONT)) {
                    descendant = new HashSet<String>();
                    descendant.add(descendantID);
                }
                this.reporter.report((FeaturesObject)PBFeaturesObjectCreator.createFontFeaturesObject(font, id, null, null, null, null, null, descendant, null));
            }
        } else {
            this.reporter.report((FeaturesObject)PBFeaturesObjectCreator.createFontFeaturesObject(font, id, null, null, null, null, null, null, null));
        }
    }

    private void parseColorSpace(PDColorSpace colorSpace, String id) {
        String iccProfileID = null;
        String idAlt = null;
        if (colorSpace instanceof PDICCBased) {
            PDICCBased iccBased = (PDICCBased)colorSpace;
            COSArray array = (COSArray)iccBased.getCOSObject();
            COSBase base = array.get(1);
            iccProfileID = this.getId(base, FeatureObjectType.ICCPROFILE);
            if (this.checkIDBeforeProcess(iccProfileID)) {
                this.reporter.report((FeaturesObject)PBFeaturesObjectCreator.createICCProfileFeaturesObject(iccBased.getPDStream().getStream(), iccProfileID));
            }
            COSBase baseAlt = iccBased.getPDStream().getStream().getItem(COSName.ALTERNATE);
            idAlt = this.getId(baseAlt, FeatureObjectType.COLORSPACE);
            try {
                PDColorSpace altclr = iccBased.getAlternateColorSpace();
                idAlt = PBFeatureParser.checkColorSpaceID(idAlt, altclr);
                if (this.checkIDBeforeProcess(idAlt)) {
                    this.parseColorSpace(iccBased.getAlternateColorSpace(), idAlt);
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, e.getMessage());
                this.colorSpaceCreationProblem(idAlt, e.getMessage());
            }
        } else if (colorSpace instanceof PDIndexed || colorSpace instanceof PDSeparation || colorSpace instanceof PDDeviceN) {
            int number = colorSpace instanceof PDIndexed ? 1 : 2;
            COSArray array = (COSArray)colorSpace.getCOSObject();
            COSBase base = array.get(number);
            idAlt = this.getId(base, FeatureObjectType.COLORSPACE);
            try {
                PDColorSpace alt = colorSpace instanceof PDIndexed ? ((PDIndexed)colorSpace).getBaseColorSpace() : (colorSpace instanceof PDSeparation ? ((PDSeparation)colorSpace).getAlternateColorSpace() : ((PDDeviceN)colorSpace).getAlternateColorSpace());
                idAlt = PBFeatureParser.checkColorSpaceID(idAlt, alt);
                if (this.checkIDBeforeProcess(idAlt)) {
                    this.parseColorSpace(alt, idAlt);
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, e.getMessage());
                this.colorSpaceCreationProblem(idAlt, e.getMessage());
            }
        }
        iccProfileID = this.config.isFeatureEnabled(FeatureObjectType.ICCPROFILE) ? iccProfileID : null;
        idAlt = this.config.isFeatureEnabled(FeatureObjectType.COLORSPACE) ? idAlt : null;
        this.reporter.report((FeaturesObject)PBFeaturesObjectCreator.createColorSpaceFeaturesObject(colorSpace, id, iccProfileID, idAlt));
    }

    private static String checkColorSpaceID(String prevID, PDColorSpace colorSpace) {
        String id = prevID;
        if (colorSpace instanceof PDDeviceGray) {
            id = DEVICEGRAY_ID;
        } else if (colorSpace instanceof PDDeviceRGB) {
            id = DEVICERGB_ID;
        } else if (colorSpace instanceof PDDeviceCMYK) {
            id = DEVICECMYK_ID;
        }
        return id;
    }

    private static COSBase getBase(COSBase base) {
        COSBase item = base;
        while (item instanceof COSObject) {
            item = ((COSObject)item).getObject();
        }
        return item;
    }

    private String getId(COSBase base, FeatureObjectType objType) {
        if (base == null) {
            return null;
        }
        long numb = this.processedIDs.size();
        COSBase item = base;
        String type = "Dir";
        while (item instanceof COSObject) {
            numb = ((COSObject)item).getObjectNumber();
            type = "Indir";
            item = ((COSObject)item).getObject();
        }
        return objType.getIdPrefix() + type + numb;
    }

    private boolean checkIDBeforeProcess(String id) {
        if (id == null || this.processedIDs.contains(id)) {
            return false;
        }
        this.processedIDs.add(id);
        return true;
    }
}

