/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.pattern;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.impl.pb.pd.pattern.PBoxPDPattern;
import org.verapdf.model.impl.pb.pd.pattern.PBoxPDShading;
import org.verapdf.model.pdlayer.PDShadingPattern;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDShadingPattern
extends PBoxPDPattern
implements PDShadingPattern {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDShadingPattern.class.getCanonicalName());
    public static final String SHADING_PATTERN_TYPE = "PDShadingPattern";
    public static final String SHADING = "shading";
    private final PDDocument document;
    private final PDFAFlavour flavour;

    public PBoxPDShadingPattern(org.apache.pdfbox.pdmodel.graphics.pattern.PDShadingPattern simplePDObject, PDDocument document, PDFAFlavour flavour) {
        super((PDAbstractPattern)simplePDObject, SHADING_PATTERN_TYPE);
        this.document = document;
        this.flavour = flavour;
    }

    public List<? extends Object> getLinkedObjects(String link) {
        if (SHADING.equals(link)) {
            return this.getShading();
        }
        return super.getLinkedObjects(link);
    }

    private List<org.verapdf.model.pdlayer.PDShading> getShading() {
        try {
            PDShading shading = ((org.apache.pdfbox.pdmodel.graphics.pattern.PDShadingPattern)this.simplePDObject).getShading();
            if (shading != null) {
                ArrayList<PBoxPDShading> shadings = new ArrayList<PBoxPDShading>(1);
                shadings.add(new PBoxPDShading(shading, this.document, this.flavour));
                return Collections.unmodifiableList(shadings);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Can`t get shading pattern. " + e.getMessage());
        }
        return Collections.emptyList();
    }
}

