/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingIntent;
import org.verapdf.model.coslayer.CosBM;
import org.verapdf.model.coslayer.CosRenderingIntent;
import org.verapdf.model.impl.pb.cos.PBCosBM;
import org.verapdf.model.impl.pb.cos.PBCosRenderingIntent;
import org.verapdf.model.impl.pb.pd.PBoxPDHalftone;
import org.verapdf.model.impl.pb.pd.PBoxPDResource;
import org.verapdf.model.impl.pb.pd.functions.PBoxPDFunction;
import org.verapdf.model.pdlayer.PDExtGState;
import org.verapdf.model.pdlayer.PDHalftone;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDExtGState
extends PBoxPDResource
implements PDExtGState {
    public static final String EXT_G_STATE_TYPE = "PDExtGState";
    public static final String CUSTOM_FUNCTIONS = "customFunctions";
    public static final String RI = "RI";
    public static final String FONT_SIZE = "fontSize";
    public static final String HALFTONE = "HT";
    public static final String LINK_BM = "bm";
    private final Double ca;
    private final Double CA;
    private final PDFAFlavour flavour;

    public PBoxPDExtGState(PDExtendedGraphicsState state, PDFAFlavour flavour) {
        super((COSObjectable)state, EXT_G_STATE_TYPE);
        this.ca = PBoxPDExtGState.getDoubleProperty(state, COSName.CA_NS);
        this.CA = PBoxPDExtGState.getDoubleProperty(state, COSName.CA);
        this.flavour = flavour;
    }

    public Double getca() {
        return this.ca;
    }

    public Double getCA() {
        return this.CA;
    }

    public String getTR2NameValue() {
        return PBoxPDExtGState.getNameKeyStringValue((COSDictionary)this.simplePDObject.getCOSObject(), COSName.getPDFName((String)"TR2"));
    }

    public Boolean getcontainsTR() {
        return ((COSDictionary)this.simplePDObject.getCOSObject()).containsKey(COSName.TR);
    }

    public Boolean getcontainsTR2() {
        return ((COSDictionary)this.simplePDObject.getCOSObject()).containsKey(COSName.getPDFName((String)"TR2"));
    }

    public Boolean getcontainsHTP() {
        return ((COSDictionary)this.simplePDObject.getCOSObject()).containsKey(COSName.getPDFName((String)"HTP"));
    }

    public Boolean getcontainsHTO() {
        return ((COSDictionary)this.simplePDObject.getCOSObject()).containsKey(COSName.getPDFName((String)"HTO"));
    }

    public String getSMaskNameValue() {
        return PBoxPDExtGState.getNameKeyStringValue((COSDictionary)this.simplePDObject.getCOSObject(), COSName.SMASK);
    }

    public Boolean getcontainsSMask() {
        return ((COSDictionary)this.simplePDObject.getCOSObject()).containsKey(COSName.SMASK);
    }

    public Boolean getcontainsBM() {
        return ((COSDictionary)this.simplePDObject.getCOSObject()).containsKey(COSName.BM);
    }

    public String getBMNameValue() {
        return PBoxPDExtGState.getNameKeyStringValue((COSDictionary)this.simplePDObject.getCOSObject(), COSName.BM);
    }

    private static String getNameKeyStringValue(COSDictionary dictionary, COSName key) {
        COSBase base = dictionary.getDictionaryObject(key);
        return base instanceof COSName ? ((COSName)base).getName() : null;
    }

    private static Double getDoubleProperty(PDExtendedGraphicsState state, COSName key) {
        COSBase base = state.getCOSObject().getDictionaryObject(key);
        return !(base instanceof COSNumber) ? null : Double.valueOf(((COSNumber)base).doubleValue());
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "RI": {
                return this.getRI();
            }
            case "HT": {
                return this.getHalftone();
            }
            case "customFunctions": {
                return this.getCustomFunctions();
            }
            case "bm": {
                return this.getLinkBM();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<CosBM> getLinkBM() {
        COSBase BM = ((COSDictionary)this.simplePDObject.getCOSObject()).getDictionaryObject(COSName.BM);
        if (BM == null) {
            return Collections.emptyList();
        }
        if ((this.flavour == null || this.flavour.getPart() != PDFAFlavour.Specification.ISO_19005_4) && BM instanceof COSArray) {
            COSArray array = (COSArray)BM;
            for (COSBase obj : array) {
                if (!(obj instanceof COSName)) continue;
                BM = obj;
                break;
            }
        }
        if (BM instanceof COSName) {
            ArrayList<PBCosBM> list = new ArrayList<PBCosBM>(1);
            list.add(new PBCosBM((COSName)BM));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<CosRenderingIntent> getRI() {
        RenderingIntent renderingIntent = ((PDExtendedGraphicsState)this.simplePDObject).getRenderingIntent();
        if (renderingIntent != null) {
            ArrayList<PBCosRenderingIntent> renderingIntents = new ArrayList<PBCosRenderingIntent>(1);
            COSName pdfName = COSName.getPDFName((String)renderingIntent.stringValue());
            renderingIntents.add(new PBCosRenderingIntent(pdfName));
            return Collections.unmodifiableList(renderingIntents);
        }
        return Collections.emptyList();
    }

    private List<PDHalftone> getHalftone() {
        COSDictionary dict = ((PDExtendedGraphicsState)this.simplePDObject).getCOSObject();
        COSBase halftone = dict.getDictionaryObject(COSName.getPDFName((String)HALFTONE));
        boolean isDictionary = halftone instanceof COSDictionary;
        if (isDictionary || halftone instanceof COSName) {
            ArrayList<PBoxPDHalftone> list = new ArrayList<PBoxPDHalftone>(1);
            if (isDictionary) {
                list.add(new PBoxPDHalftone((COSDictionary)halftone));
            } else {
                list.add(new PBoxPDHalftone((COSName)halftone));
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<PBoxPDFunction> getCustomFunctions() {
        return Collections.emptyList();
    }
}

