/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.colors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceNAttributes;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.model.factory.colors.ColorSpaceFactory;
import org.verapdf.model.impl.pb.cos.PBCosUnicodeName;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDColorSpace;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDSeparation;
import org.verapdf.model.pdlayer.PDDeviceN;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDDeviceN
extends PBoxPDColorSpace
implements PDDeviceN {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDDeviceN.class);
    public static final String DEVICE_N_TYPE = "PDDeviceN";
    public static final String ALTERNATE = "alternate";
    public static final String COLORANT_NAMES = "colorantNames";
    public static final String COLORANTS = "Colorants";
    public static final int COLORANT_NAMES_POSITION = 1;
    public static final Set<COSName> IGNORED_COLORANTS;
    private final boolean areColorantsPresent;
    private final PDDocument document;
    private final PDFAFlavour flavour;

    public PBoxPDDeviceN(org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN simplePDObject, PDDocument document, PDFAFlavour flavour) {
        super((PDColorSpace)simplePDObject, DEVICE_N_TYPE);
        this.areColorantsPresent = PBoxPDDeviceN.areColorantsPresent(simplePDObject);
        this.document = document;
        this.flavour = flavour;
    }

    private static boolean areColorantsPresent(org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN simplePDObject) {
        COSArray array;
        COSBase colorantsArray;
        COSDictionary attrDict;
        COSBase colorantsDict;
        PDDeviceNAttributes attributes = simplePDObject.getAttributes();
        if (attributes != null && (colorantsDict = (attrDict = attributes.getCOSDictionary()).getDictionaryObject(COSName.COLORANTS)) instanceof COSDictionary && (colorantsArray = (array = (COSArray)simplePDObject.getCOSObject()).get(1)) instanceof COSArray) {
            return PBoxPDDeviceN.areColorantsPresent((COSDictionary)colorantsDict, colorantsArray);
        }
        return false;
    }

    private static boolean areColorantsPresent(COSDictionary colorantsDict, COSBase colorantsArray) {
        Set colorantDictionaryEntries = colorantsDict.keySet();
        for (int i = 0; i < ((COSArray)colorantsArray).size(); ++i) {
            COSBase object = ((COSArray)colorantsArray).getObject(i);
            if (!(object instanceof COSName) || object == COSName.NONE || IGNORED_COLORANTS.contains(object) || colorantDictionaryEntries.contains(object)) continue;
            return false;
        }
        return true;
    }

    public Boolean getareColorantsPresent() {
        return this.areColorantsPresent;
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "alternate": {
                return this.getAlternate();
            }
            case "colorantNames": {
                return this.getColorantNames();
            }
            case "Colorants": {
                return this.getColorants();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<org.verapdf.model.pdlayer.PDColorSpace> getAlternate() {
        try {
            PDColorSpace alternateColorSpace = ((org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN)this.simplePDObject).getAlternateColorSpace();
            org.verapdf.model.pdlayer.PDColorSpace space = ColorSpaceFactory.getColorSpace(alternateColorSpace, this.document, this.flavour);
            if (space != null) {
                ArrayList<org.verapdf.model.pdlayer.PDColorSpace> colorSpace = new ArrayList<org.verapdf.model.pdlayer.PDColorSpace>(1);
                colorSpace.add(space);
                return Collections.unmodifiableList(colorSpace);
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)"Can not get alternate color space from DeviceN. ", (Throwable)e);
        }
        return Collections.emptyList();
    }

    private List<CosUnicodeName> getColorantNames() {
        COSArray array = (COSArray)this.simplePDObject.getCOSObject();
        COSBase colorants = array.getObject(1);
        if (colorants instanceof COSArray) {
            ArrayList<PBCosUnicodeName> list = new ArrayList<PBCosUnicodeName>(((COSArray)colorants).size());
            for (COSBase colorant : (COSArray)colorants) {
                if (!(colorant instanceof COSName)) continue;
                list.add(new PBCosUnicodeName((COSName)colorant));
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.pdlayer.PDSeparation> getColorants() {
        COSDictionary dictionary;
        COSBase colorantsDict;
        PDDeviceNAttributes attributes = ((org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN)this.simplePDObject).getAttributes();
        if (attributes != null && (colorantsDict = (dictionary = attributes.getCOSDictionary()).getDictionaryObject(COSName.COLORANTS)) instanceof COSDictionary) {
            return this.getColorants((COSDictionary)colorantsDict);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.pdlayer.PDSeparation> getColorants(COSDictionary colorantsDict) {
        ArrayList<PBoxPDSeparation> list = new ArrayList<PBoxPDSeparation>(colorantsDict.size());
        for (COSBase value : colorantsDict.getValues()) {
            try {
                PDColorSpace colorSpace = PDColorSpace.create((COSBase)value);
                if (!(colorSpace instanceof PDSeparation)) continue;
                list.add((PBoxPDSeparation)ColorSpaceFactory.getColorSpace(colorSpace, this.document, this.flavour));
            }
            catch (IOException e) {
                LOGGER.debug((Object)"Problems with color space obtain.", (Throwable)e);
            }
        }
        return Collections.unmodifiableList(list);
    }

    static {
        HashSet<COSName> tempIgnore = new HashSet<COSName>();
        tempIgnore.add(COSName.getPDFName((String)"Cyan"));
        tempIgnore.add(COSName.getPDFName((String)"Magenta"));
        tempIgnore.add(COSName.getPDFName((String)"Yellow"));
        tempIgnore.add(COSName.getPDFName((String)"Black"));
        IGNORED_COLORANTS = Collections.unmodifiableSet(tempIgnore);
    }
}

