/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.tools;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;

public class TableHelper {
    public static Integer getColSpan(COSDictionary simplePDObject) {
        return TableHelper.getSpanValue(simplePDObject, COSName.getPDFName((String)"COL_SPAN"));
    }

    public static Integer getRowSpan(COSDictionary simplePDObject) {
        return TableHelper.getSpanValue(simplePDObject, COSName.getPDFName((String)"ROW_SPAN"));
    }

    private static Integer getSpanValue(COSDictionary simplePDObject, COSName spanName) {
        Integer spanValue;
        Integer defaultValue = 1;
        COSBase aValue = simplePDObject.getDictionaryObject(COSName.A);
        if (aValue == null) {
            return defaultValue;
        }
        if (aValue instanceof COSArray) {
            for (COSBase object : (COSArray)aValue) {
                Integer spanValue2 = TableHelper.getSpanValue(object, spanName);
                if (spanValue2 == null) continue;
                return spanValue2;
            }
        }
        return (spanValue = TableHelper.getSpanValue(aValue, spanName)) != null ? spanValue : defaultValue;
    }

    private static Integer getSpanValue(COSBase object, COSName spanName) {
        if (object instanceof COSDictionary && "Table".equals(((COSDictionary)object).getString(COSName.O))) {
            return ((COSDictionary)object).getInt(spanName);
        }
        return null;
    }
}

