/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.pdlayer.PDOCConfig;

public class PBoxPDOCConfig
extends PBoxPDObject
implements PDOCConfig {
    public static final Logger LOGGER = Logger.getLogger(PBoxPDOCConfig.class);
    public static final String OC_CONFIG_TYPE = "PDOCConfig";
    public static final String EVENT_KEY = "Event";
    private final List<String> groupNames;
    private final boolean duplicateName;

    public PBoxPDOCConfig(COSObjectable simplePDObject) {
        super(simplePDObject, OC_CONFIG_TYPE);
        this.groupNames = Collections.emptyList();
        this.duplicateName = false;
    }

    public PBoxPDOCConfig(COSObjectable simplePDObject, List<String> groupNames, boolean duplicateName) {
        super(simplePDObject, OC_CONFIG_TYPE);
        this.groupNames = groupNames == null ? Collections.emptyList() : groupNames;
        this.duplicateName = duplicateName;
    }

    public Boolean getdoesOrderContainAllOCGs() {
        TreeSet<String> groupNamesSet = new TreeSet<String>(this.groupNames);
        COSBase order = ((COSDictionary)this.simplePDObject).getDictionaryObject(COSName.ORDER);
        if (order != null) {
            if (order instanceof COSArray) {
                for (int i = 0; i < ((COSArray)order).size(); ++i) {
                    COSBase element = ((COSArray)order).getObject(i);
                    if (element instanceof COSArray) {
                        this.processCOSArrayInOrder((COSArray)element, groupNamesSet);
                        continue;
                    }
                    if (element instanceof COSDictionary) {
                        this.processCOSDictionaryInOrder((COSDictionary)element, groupNamesSet);
                        continue;
                    }
                    LOGGER.debug((Object)"Invalid object type in order array. Ignoring the object.");
                }
                if (!groupNamesSet.isEmpty()) {
                    return Boolean.FALSE;
                }
            } else {
                LOGGER.debug((Object)"Invalid object type of Order entry. Ignoring the Order entry.");
            }
        }
        return Boolean.TRUE;
    }

    public String getAS() {
        COSBase asArray = ((COSDictionary)this.simplePDObject).getDictionaryObject(COSName.AS);
        if (asArray != null) {
            String result = "";
            if (asArray instanceof COSArray) {
                for (int i = 0; i < ((COSArray)asArray).size(); ++i) {
                    COSBase element = ((COSArray)asArray).getObject(i);
                    if (element instanceof COSDictionary) {
                        String event = ((COSDictionary)element).getString(EVENT_KEY);
                        if (event == null || event.isEmpty()) continue;
                        result = result.concat(event);
                        continue;
                    }
                    LOGGER.debug((Object)"Invalid object type in the AS array. Ignoring the object.");
                }
                return result;
            }
            LOGGER.debug((Object)"Invalid object type of AS entry. Ignoring the entry.");
            return result;
        }
        return null;
    }

    public Boolean gethasDuplicateName() {
        return this.duplicateName;
    }

    public String getName() {
        return ((COSDictionary)this.simplePDObject).getString(COSName.NAME);
    }

    private void processCOSArrayInOrder(COSArray array, Set<String> groupNames) {
        for (int i = 0; i < array.size(); ++i) {
            COSBase element = array.getObject(i);
            if (element instanceof COSArray) {
                this.processCOSArrayInOrder((COSArray)element, groupNames);
                continue;
            }
            if (!(element instanceof COSDictionary)) continue;
            this.processCOSDictionaryInOrder((COSDictionary)element, groupNames);
        }
    }

    private void processCOSDictionaryInOrder(COSDictionary element, Set<String> groupNames) {
        groupNames.remove(element.getString(COSName.NAME));
    }

    private static int getLenghtOfFlattenArray(COSArray array) {
        int res = 0;
        for (int i = 0; i < array.size(); ++i) {
            COSBase element = array.getObject(i);
            if (element instanceof COSArray) {
                res += PBoxPDOCConfig.getLenghtOfFlattenArray((COSArray)element);
                continue;
            }
            ++res;
        }
        return res;
    }
}

