/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.apache.pdfbox.pdmodel.interactive.action.PDPageAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.verapdf.model.coslayer.CosBBox;
import org.verapdf.model.impl.pb.cos.PBCosBBox;
import org.verapdf.model.impl.pb.pd.PBoxOutputIntents;
import org.verapdf.model.impl.pb.pd.PBoxPDAnnot;
import org.verapdf.model.impl.pb.pd.PBoxPDContentStream;
import org.verapdf.model.impl.pb.pd.PBoxPDGroup;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.impl.pb.pd.PBoxPDResources;
import org.verapdf.model.impl.pb.pd.actions.PBoxPDPageAdditionalActions;
import org.verapdf.model.pdlayer.OutputIntents;
import org.verapdf.model.pdlayer.PDAdditionalActions;
import org.verapdf.model.pdlayer.PDAnnot;
import org.verapdf.model.pdlayer.PDContentStream;
import org.verapdf.model.pdlayer.PDGroup;
import org.verapdf.model.pdlayer.PDPage;
import org.verapdf.model.tools.resources.PDInheritableResources;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDPage
extends PBoxPDObject
implements PDPage {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDPage.class);
    public static final String PAGE_TYPE = "PDPage";
    public static final String ANNOTS = "annots";
    public static final String ACTION = "AA";
    public static final String CONTENT_STREAM = "contentStream";
    public static final String GROUP = "Group";
    public static final String MEDIA_BOX = "MediaBox";
    public static final String CROP_BOX = "CropBox";
    public static final String BLEED_BOX = "BleedBox";
    public static final String TRIM_BOX = "TrimBox";
    public static final String ART_BOX = "ArtBox";
    public static final String OUTPUT_INTENTS = "outputIntents";
    private static final String RESOURCES = "resources";
    public static final String PRESENTATION_STEPS = "PresSteps";
    public static final String PORTRAIT_ORIENTATION = "Portrait";
    public static final String LANDSCAPE_ORIENTATION = "Landscape";
    public static final String SQUARE_ORIENTATION = "Square";
    public static final String TRANSPARENCY_COLOR_SPACE = "transparencyColorSpace";
    public static final String PARENT_TRANSPARENCY_COLOR_SPACE = "parentTransparencyColorSpace";
    private boolean containsTransparency = false;
    private List<PDContentStream> contentStreams = null;
    private OutputIntents outputIntents = null;
    private List<PDAnnot> annotations = null;
    private final PDDocument document;
    private final PDFAFlavour flavour;

    public PBoxPDPage(org.apache.pdfbox.pdmodel.PDPage simplePDObject, PDDocument document, PDFAFlavour flavour) {
        super((COSObjectable)simplePDObject, PAGE_TYPE);
        this.document = document;
        this.flavour = flavour;
    }

    public Boolean getcontainsPresSteps() {
        COSBase presSteps = ((org.apache.pdfbox.pdmodel.PDPage)this.simplePDObject).getCOSObject().getDictionaryObject(COSName.getPDFName((String)PRESENTATION_STEPS));
        if (presSteps != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean getcontainsTransparency() {
        if (this.contentStreams == null) {
            this.parseContentStream();
        }
        if (this.annotations == null) {
            this.annotations = this.parseAnnotataions();
        }
        return this.containsTransparency;
    }

    public Boolean getcontainsGroupCS() {
        COSDictionary dictionary = ((org.apache.pdfbox.pdmodel.PDPage)this.simplePDObject).getCOSObject();
        COSBase groupDictionary = dictionary.getDictionaryObject(COSName.GROUP);
        if (groupDictionary instanceof COSDictionary) {
            org.apache.pdfbox.pdmodel.graphics.form.PDGroup group = new org.apache.pdfbox.pdmodel.graphics.form.PDGroup((COSDictionary)groupDictionary);
            try {
                return group != null && group.getColorSpace() != null;
            }
            catch (IOException e) {
                LOGGER.debug((Object)"Problem with obtaining group colorspace", (Throwable)e);
            }
        }
        return Boolean.FALSE;
    }

    public Boolean getcontainsAA() {
        COSBase pageObject = this.simplePDObject.getCOSObject();
        return pageObject != null && pageObject instanceof COSDictionary && ((COSDictionary)pageObject).containsKey(COSName.AA);
    }

    public String getTabs() {
        COSBase pageObject = this.simplePDObject.getCOSObject();
        if (pageObject != null && pageObject instanceof COSDictionary) {
            return ((COSDictionary)pageObject).getNameAsString(COSName.getPDFName((String)"Tabs"));
        }
        return null;
    }

    public String getorientation() {
        CosBBox mediaBox = this.getMediaBox().get(0);
        double height = mediaBox.gettop() - mediaBox.getbottom();
        double width = mediaBox.getright() - mediaBox.getleft();
        long rotation = ((org.apache.pdfbox.pdmodel.PDPage)this.simplePDObject).getRotation();
        if (height > width && rotation % 180L == 0L || height < width && rotation % 180L == 90L) {
            return PORTRAIT_ORIENTATION;
        }
        if (height < width && rotation % 180L == 0L || height > width && rotation % 180L == 90L) {
            return LANDSCAPE_ORIENTATION;
        }
        return SQUARE_ORIENTATION;
    }

    public String getoutputColorSpace() {
        if (this.outputIntents == null) {
            this.outputIntents = this.parseOutputIntents();
        }
        return this.outputIntents != null ? ((PBoxOutputIntents)this.outputIntents).getColorSpace() : null;
    }

    private List<OutputIntents> getOutputIntents() {
        if (this.outputIntents == null) {
            this.outputIntents = this.parseOutputIntents();
        }
        if (this.outputIntents != null) {
            ArrayList<OutputIntents> array = new ArrayList<OutputIntents>(1);
            array.add(this.outputIntents);
            return array;
        }
        return Collections.emptyList();
    }

    private OutputIntents parseOutputIntents() {
        if (this.flavour != null && this.flavour.getPart() != PDFAFlavour.Specification.ISO_19005_4) {
            return null;
        }
        ArrayList<PDOutputIntent> outInts = new ArrayList<PDOutputIntent>();
        COSArray array = (COSArray)((COSDictionary)this.simplePDObject.getCOSObject()).getDictionaryObject(COSName.OUTPUT_INTENTS);
        if (array != null) {
            for (COSBase cosBase : array) {
                if (cosBase instanceof COSObject) {
                    cosBase = ((COSObject)cosBase).getObject();
                }
                outInts.add(new PDOutputIntent((COSDictionary)cosBase));
            }
        }
        if (outInts.size() > 0) {
            return new PBoxOutputIntents(outInts, this.document, this.flavour);
        }
        return null;
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Group": {
                return this.getGroup();
            }
            case "annots": {
                return this.getAnnotations();
            }
            case "AA": {
                return this.getActions();
            }
            case "contentStream": {
                return this.getContentStream();
            }
            case "MediaBox": {
                return this.getMediaBox();
            }
            case "resources": {
                return this.getResources();
            }
            case "CropBox": {
                return this.getCropBox();
            }
            case "BleedBox": {
                return this.getBleedBox();
            }
            case "TrimBox": {
                return this.getTrimBox();
            }
            case "ArtBox": {
                return this.getArtBox();
            }
            case "outputIntents": {
                return this.getOutputIntents();
            }
            case "transparencyColorSpace": {
                return Collections.emptyList();
            }
            case "parentTransparencyColorSpace": {
                return Collections.emptyList();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<PDGroup> getGroup() {
        COSDictionary dictionary = ((org.apache.pdfbox.pdmodel.PDPage)this.simplePDObject).getCOSObject();
        COSBase groupDictionary = dictionary.getDictionaryObject(COSName.GROUP);
        if (groupDictionary instanceof COSDictionary) {
            ArrayList<PBoxPDGroup> groups = new ArrayList<PBoxPDGroup>(1);
            org.apache.pdfbox.pdmodel.graphics.form.PDGroup group = new org.apache.pdfbox.pdmodel.graphics.form.PDGroup((COSDictionary)groupDictionary);
            groups.add(new PBoxPDGroup(group, this.document, this.flavour));
            return Collections.unmodifiableList(groups);
        }
        return Collections.emptyList();
    }

    private List<PDContentStream> getContentStream() {
        if (this.contentStreams == null) {
            this.parseContentStream();
        }
        return this.contentStreams;
    }

    private void parseContentStream() {
        this.contentStreams = new ArrayList<PDContentStream>(1);
        org.apache.pdfbox.pdmodel.PDPage page = (org.apache.pdfbox.pdmodel.PDPage)this.simplePDObject;
        PDInheritableResources resources = PDInheritableResources.getInstance(page.getInheritedResources(), page.getPageResources());
        PBoxPDContentStream contentStream = new PBoxPDContentStream((org.apache.pdfbox.contentstream.PDContentStream)page, resources, this.document, this.flavour);
        this.contentStreams.add(contentStream);
        this.containsTransparency = contentStream.isContainsTransparency();
    }

    private List<PDAdditionalActions> getActions() {
        PDPageAdditionalActions pbActions = ((org.apache.pdfbox.pdmodel.PDPage)this.simplePDObject).getActions();
        if (pbActions != null && pbActions.getCOSObject().size() != 0) {
            ArrayList<PBoxPDPageAdditionalActions> actions = new ArrayList<PBoxPDPageAdditionalActions>(1);
            actions.add(new PBoxPDPageAdditionalActions((COSObjectable)pbActions));
            return Collections.unmodifiableList(actions);
        }
        return Collections.emptyList();
    }

    private List<PDAnnot> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = this.parseAnnotataions();
        }
        return this.annotations;
    }

    private List<PDAnnot> parseAnnotataions() {
        try {
            List pdfboxAnnotations = ((org.apache.pdfbox.pdmodel.PDPage)this.simplePDObject).getAnnotations();
            if (pdfboxAnnotations != null) {
                ArrayList<PDAnnot> annotations = new ArrayList<PDAnnot>(pdfboxAnnotations.size());
                this.addAllAnnotations(annotations, pdfboxAnnotations);
                return Collections.unmodifiableList(annotations);
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)("Problems in obtaining pdfbox PDAnnotations. " + e.getMessage()), (Throwable)e);
        }
        return Collections.emptyList();
    }

    private void addAllAnnotations(List<PDAnnot> annotations, List<PDAnnotation> pdfboxAnnotations) {
        PDResources pageResources = ((org.apache.pdfbox.pdmodel.PDPage)this.simplePDObject).getResources();
        for (PDAnnotation annotation : pdfboxAnnotations) {
            if (annotation == null) continue;
            PBoxPDAnnot annot = PBoxPDAnnot.createAnnot(annotation, pageResources, this.document, this.flavour, (org.apache.pdfbox.pdmodel.PDPage)this.simplePDObject);
            this.containsTransparency |= annot.isContainsTransparency();
            annotations.add(annot);
        }
    }

    private List<CosBBox> getMediaBox() {
        return this.getCosBBox(COSName.MEDIA_BOX);
    }

    private List<CosBBox> getCropBox() {
        return this.getCosBBox(COSName.CROP_BOX);
    }

    private List<CosBBox> getBleedBox() {
        return this.getCosBBox(COSName.BLEED_BOX);
    }

    private List<CosBBox> getTrimBox() {
        return this.getCosBBox(COSName.TRIM_BOX);
    }

    private List<CosBBox> getArtBox() {
        return this.getCosBBox(COSName.ART_BOX);
    }

    private List<CosBBox> getCosBBox(COSName key) {
        COSBase array = PDPageTree.getInheritableAttribute((COSDictionary)((COSDictionary)this.simplePDObject.getCOSObject()), (COSName)key);
        if (array instanceof COSArray) {
            ArrayList<PBCosBBox> list = new ArrayList<PBCosBBox>(1);
            list.add(new PBCosBBox((COSArray)array, this.document, this.flavour));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.pdlayer.PDResources> getResources() {
        ArrayList<org.verapdf.model.pdlayer.PDResources> result = new ArrayList<org.verapdf.model.pdlayer.PDResources>(1);
        PDResources resources = ((org.apache.pdfbox.pdmodel.PDPage)this.simplePDObject).getResources();
        if (resources != null) {
            result.add(new PBoxPDResources(resources));
        }
        return result;
    }
}

