/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.tools;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.verapdf.model.impl.pb.pd.PBoxPDOutline;
import org.verapdf.model.pdlayer.PDOutline;
import org.verapdf.model.tools.IDGenerator;

public class OutlinesHelper {
    private OutlinesHelper() {
    }

    public static List<PDOutline> getOutlines(PDDocumentCatalog catalog) {
        Map<PDOutlineItem, String> outlines = OutlinesHelper.getOutlinesMap(catalog);
        if (outlines.size() > 0) {
            ArrayList<PBoxPDOutline> result = new ArrayList<PBoxPDOutline>(outlines.size());
            for (Map.Entry<PDOutlineItem, String> entry : outlines.entrySet()) {
                result.add(new PBoxPDOutline(entry.getKey(), entry.getValue()));
            }
            outlines.clear();
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    private static Map<PDOutlineItem, String> getOutlinesMap(PDDocumentCatalog catalog) {
        PDOutlineItem firstChild;
        PDDocumentOutline documentOutline;
        if (catalog != null && (documentOutline = catalog.getDocumentOutline()) != null && (firstChild = documentOutline.getFirstChild()) != null) {
            ArrayDeque<PDOutlineItem> stack = new ArrayDeque<PDOutlineItem>();
            stack.push(firstChild);
            return OutlinesHelper.getOutlinesMap(stack);
        }
        return Collections.emptyMap();
    }

    private static Map<PDOutlineItem, String> getOutlinesMap(Deque<PDOutlineItem> stack) {
        HashMap<PDOutlineItem, String> result = new HashMap<PDOutlineItem, String>();
        do {
            PDOutlineItem item = stack.pop();
            PDOutlineItem nextSibling = item.getNextSibling();
            PDOutlineItem firstChild = item.getFirstChild();
            if (nextSibling != null && !result.containsKey(nextSibling)) {
                stack.add(nextSibling);
            }
            if (firstChild != null && !result.containsKey(firstChild)) {
                stack.add(firstChild);
            }
            result.put(item, IDGenerator.generateID(item));
        } while (!stack.isEmpty());
        return result;
    }
}

