/**
 * This file is part of veraPDF PDF Box Validation Model Implementation, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF PDF Box Validation Model Implementation is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF PDF Box Validation Model Implementation as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF PDF Box Validation Model Implementation as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.impl.pb.pd.colors;

import org.verapdf.model.pdlayer.PDDeviceRGB;

/**
 * DeviceRGB color space
 *
 * @author Evgeniy Muravitskiy
 */
public class PBoxPDDeviceRGB extends PBoxPDColorSpace implements PDDeviceRGB {

    private static final PDDeviceRGB INSTANCE = new PBoxPDDeviceRGB(
            org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB.INSTANCE);
    private static final PDDeviceRGB INHERITED_INSTANCE = new PBoxPDDeviceRGB(
            org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB.INHERITED_INSTANCE);

    public static final String DEVICE_RGB_TYPE = "PDDeviceRGB";

    private PBoxPDDeviceRGB(
            org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB simplePDObject) {
        super(simplePDObject, DEVICE_RGB_TYPE);
    }

    public static PDDeviceRGB getInstance() {
        return INSTANCE;
    }

    public static PDDeviceRGB getInheritedInstance() {
        return INHERITED_INSTANCE;
    }
}
