/*
 * This file is part of veraPDF PDF Box Validation Model Implementation, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF PDF Box Validation Model Implementation is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF PDF Box Validation Model Implementation as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF PDF Box Validation Model Implementation as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.impl.pb.cos;

import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.verapdf.model.coslayer.CosFilter;

/**
 * @author Timur Kamalov
 */
public class PBCosFilter extends PBCosName implements CosFilter {

	public static final String COS_FILTER_TYPE = "CosFilter";

	private static final String IDENTITY = "Identity";
	private static final String CUSTOM = "Custom";
	private static final String DEFAULT = "Default";

	private final String decodeParms;

	public PBCosFilter(final COSName filterName, final COSDictionary decodeParms) {
		super(filterName, COS_FILTER_TYPE);
		if (filterName.equals(COSName.CRYPT)) {
			if (decodeParms == null) {
				this.decodeParms = IDENTITY;
			} else {
				this.decodeParms = decodeParms.getString(COSName.NAME, IDENTITY);
			}
		} else if (decodeParms == null) {
			this.decodeParms = DEFAULT;
		} else {
			this.decodeParms = CUSTOM;
		}
	}

	@Override
	public String getdecodeParms() {
		return this.decodeParms;
	}

}
