/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.tools;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.font.PDFontLike;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;

public final class IDGenerator {
    private IDGenerator() {
    }

    public static String generateID(COSBase pdfBoxObject) {
        if (pdfBoxObject instanceof COSObject) {
            return String.valueOf(((COSObject)pdfBoxObject).getObjectNumber() + " " + ((COSObject)pdfBoxObject).getGenerationNumber());
        }
        return null;
    }

    public static String generateID(int hashcode, String fontName, int glyphCode, int renderingMode) {
        return String.valueOf(hashcode) + ' ' + fontName + ' ' + glyphCode + ' ' + renderingMode;
    }

    public static String generateID(PDFontLike font) {
        int hashcode = font instanceof COSObjectable ? ((COSObjectable)font).getCOSObject().hashCode() : -1;
        return String.valueOf(hashcode) + ' ' + font.getName();
    }

    public static String generateID(PDOutlineItem item) {
        COSDictionary dictionary = item.getCOSObject();
        String value = IDGenerator.getOutlineID(dictionary, COSName.PREV, COSName.NEXT);
        return value != null ? value : IDGenerator.getOutlineID(dictionary, COSName.PARENT, COSName.FIRST);
    }

    private static String getOutlineID(COSDictionary dictionary, COSName kind, COSName key) {
        COSBase current;
        String value;
        COSBase base = dictionary.getDictionaryObject(kind);
        if (base instanceof COSDictionary && (value = IDGenerator.generateID(current = ((COSDictionary)base).getItem(key))) != null) {
            return "outline " + value;
        }
        return null;
    }
}

