/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.tools;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class TaggedPDFRoleMapHelper {
    private static Set<String> PDF_1_4_STANDART_ROLE_TYPES;
    private static Set<String> PDF_1_7_STANDART_ROLE_TYPES;
    private Map<String, String> roleMap;
    private Set<String> currentStandartTypes;

    public TaggedPDFRoleMapHelper(Map<String, String> roleMap, PDFAFlavour flavour) {
        this.roleMap = roleMap == null ? Collections.emptyMap() : new HashMap<String, String>(roleMap);
        this.currentStandartTypes = flavour.getPart() == PDFAFlavour.Specification.ISO_19005_1 ? Collections.unmodifiableSet(PDF_1_4_STANDART_ROLE_TYPES) : Collections.unmodifiableSet(PDF_1_7_STANDART_ROLE_TYPES);
    }

    public String getStandartType(String type) {
        HashSet<String> visitedTypes = new HashSet<String>();
        String res = type;
        while (res != null && !visitedTypes.contains(res)) {
            if (this.currentStandartTypes.contains(res)) {
                return res;
            }
            visitedTypes.add(res);
            res = this.roleMap.get(res);
        }
        return null;
    }

    static {
        HashSet<String> tempSet = new HashSet<String>();
        tempSet.add("Document");
        tempSet.add("Part");
        tempSet.add("Art");
        tempSet.add("Sect");
        tempSet.add("Div");
        tempSet.add("BlockQuote");
        tempSet.add("Caption");
        tempSet.add("TOC");
        tempSet.add("TOCI");
        tempSet.add("Index");
        tempSet.add("NonStruct");
        tempSet.add("Private");
        tempSet.add("H");
        tempSet.add("H1");
        tempSet.add("H2");
        tempSet.add("H3");
        tempSet.add("H4");
        tempSet.add("H5");
        tempSet.add("H6");
        tempSet.add("P");
        tempSet.add("L");
        tempSet.add("LI");
        tempSet.add("LbI");
        tempSet.add("LBody");
        tempSet.add("Table");
        tempSet.add("TR");
        tempSet.add("TH");
        tempSet.add("TD");
        tempSet.add("Span");
        tempSet.add("Quote");
        tempSet.add("Note");
        tempSet.add("Reference");
        tempSet.add("BibEntry");
        tempSet.add("Code");
        tempSet.add("Link");
        tempSet.add("Figure");
        tempSet.add("Formula");
        tempSet.add("Form");
        PDF_1_4_STANDART_ROLE_TYPES = new HashSet<String>(tempSet);
        tempSet.add("THead");
        tempSet.add("TBody");
        tempSet.add("TFoot");
        tempSet.add("Annot");
        tempSet.add("Ruby");
        tempSet.add("Warichu");
        tempSet.add("RB");
        tempSet.add("RT");
        tempSet.add("RP");
        tempSet.add("WT");
        tempSet.add("WP");
        PDF_1_7_STANDART_ROLE_TYPES = new HashSet<String>(tempSet);
    }
}

