/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.operator.textshow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.cos.COSBase;
import org.verapdf.gf.model.factory.operators.GraphicState;
import org.verapdf.gf.model.impl.cos.GFCosNumber;
import org.verapdf.gf.model.impl.operator.markedcontent.GFOpMarkedContent;
import org.verapdf.gf.model.impl.operator.textshow.GFOpStringTextShow;
import org.verapdf.gf.model.impl.pd.util.PDResourcesHandler;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosNumber;
import org.verapdf.model.operator.Op_DoubleQuote;
import org.verapdf.pd.structure.StructureElementAccessObject;

public class GFOp_DoubleQuote
extends GFOpStringTextShow
implements Op_DoubleQuote {
    public static final String OP_DOUBLIE_QUOTE_TYPE = "Op_DoubleQuote";
    public static final String WORD_SPACING = "wordSpacing";
    public static final String CHARACTER_SPACING = "characterSpacing";
    public static final int WORD_SPACING_POSITION = 0;
    public static final int CHARACTER_SPACING_POSITION = 1;
    public static final int COUNT_OF_OPERATOR_OPERANDS = 3;

    public GFOp_DoubleQuote(List<COSBase> arguments, GraphicState state, PDResourcesHandler resourcesHandler, GFOpMarkedContent markedContent, StructureElementAccessObject structureElementAccessObject) {
        super(arguments, state, resourcesHandler, markedContent, structureElementAccessObject, OP_DOUBLIE_QUOTE_TYPE);
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "wordSpacing": {
                return this.getWordSpacing();
            }
            case "characterSpacing": {
                return this.getCharacterSpacing();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<CosNumber> getWordSpacing() {
        return this.getSpecialNumber(0);
    }

    private List<CosNumber> getCharacterSpacing() {
        return this.getSpecialNumber(1);
    }

    private List<CosNumber> getSpecialNumber(int operandNumber) {
        int index;
        COSBase base;
        int size = this.arguments.size();
        if (size >= 3 && (base = (COSBase)this.arguments.get(index = size - 3 + operandNumber)).getType().isNumber()) {
            ArrayList<GFCosNumber> number = new ArrayList<GFCosNumber>(1);
            number.add(GFCosNumber.fromPDFParserNumber(base));
            return Collections.unmodifiableList(number);
        }
        return Collections.emptyList();
    }
}

