/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.font;

import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.factory.operators.RenderingMode;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.pd.font.GFPDFont;
import org.verapdf.model.operator.CIDGlyph;
import org.verapdf.model.operator.Glyph;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.PDCIDFont;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.flavours.PDFFlavours;
import org.verapdf.tools.StaticResources;

public class GFPDCIDFont
extends GFPDFont
implements org.verapdf.model.pdlayer.PDCIDFont {
    private static final Logger LOGGER = Logger.getLogger(GFPDCIDFont.class.getCanonicalName());
    public static final String CID_FONT_TYPE = "PDCIDFont";
    public static final String IDENTITY = "Identity";
    public static final String CUSTOM = "Custom";
    public static final int maxSize = 16384;
    public static final int bufferSize = 2048;
    private final String externalFontID;

    public GFPDCIDFont(PDFont font, RenderingMode renderingMode, String externalFontID) {
        super(font, renderingMode, CID_FONT_TYPE);
        this.externalFontID = externalFontID;
        if (font != null) {
            FontProgram program = font.getFontProgram();
            if (program != null) {
                StaticResources.getDocument().getDocument().getResourceHandler().addResource(program.getFontProgramResource());
            }
            if (program != null) {
                try {
                    if (!program.isAttemptedParsing()) {
                        program.parseFont();
                    }
                    this.fontProgramParsed = program.isSuccessfulParsing();
                    this.pdFont.setSuccessfullyParsed(program.isSuccessfulParsing());
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Can't parse font program of font " + font.getName(), e);
                    this.fontProgramParsed = false;
                    this.pdFont.setSuccessfullyParsed(false);
                }
            }
        }
    }

    public String getCIDToGIDMap() {
        COSObject cidToGidObject = ((PDCIDFont)this.pdFont).getCIDToGIDMap();
        if (cidToGidObject.getType() == COSObjType.COS_STREAM) {
            return CUSTOM;
        }
        if (cidToGidObject.getType() == COSObjType.COS_NAME && IDENTITY.equals(cidToGidObject.getString())) {
            return IDENTITY;
        }
        return null;
    }

    public Boolean getcontainsCIDSet() {
        return ((PDCIDFont)this.pdFont).getCIDSet() != null;
    }

    public Boolean getcidSetListsAllGlyphs() {
        block15: {
            if (!this.fontProgramParsed) {
                return Boolean.FALSE;
            }
            try {
                byte[] cidSetBytes;
                COSStream cidSet = this.getCIDSetStream();
                if (cidSet == null) break block15;
                try (ASInputStream stream = cidSet.getData(COSStream.FilterFlags.DECODE);){
                    cidSetBytes = GFPDCIDFont.getCIDsFromCIDSet(stream);
                }
                BitSet bitSet = GFPDCIDFont.toBitSetBigEndian(cidSetBytes);
                FontProgram cidFont = this.pdFont.getFontProgram();
                if (!PDFFlavours.isFlavourPart(StaticContainers.getFlavour(), (PDFAFlavour.Specification)PDFAFlavour.Specification.ISO_19005_1)) {
                    List fontCIDs = cidFont != null ? cidFont.getCIDList() : Collections.emptyList();
                    Iterator iterator = fontCIDs.iterator();
                    while (iterator.hasNext()) {
                        int cid = (Integer)iterator.next();
                        if (cid == 0 || bitSet.get(cid)) continue;
                        return Boolean.FALSE;
                    }
                    for (int i = 1; i < bitSet.length(); ++i) {
                        if (!bitSet.get(i) || cidFont.containsCID(i)) continue;
                        return Boolean.FALSE;
                    }
                } else {
                    Map<String, Glyph> map = StaticContainers.getCachedGlyphs().get(this.externalFontID);
                    if (map != null) {
                        for (Glyph glyph : map.values()) {
                            int cid;
                            if (!(glyph instanceof CIDGlyph) || (cid = ((CIDGlyph)glyph).getCID().intValue()) == 0 || !cidFont.containsCID(cid) || bitSet.get(cid)) continue;
                            return false;
                        }
                    }
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Error while parsing embedded font program. " + e.getMessage(), e);
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    private COSStream getCIDSetStream() {
        return ((PDCIDFont)this.pdFont).getCIDSet();
    }

    private static byte[] getCIDsFromCIDSet(ASInputStream cidSet) throws IOException {
        byte[] cidSetBytes = new byte[16384];
        byte[] temp = new byte[2048];
        int size = 0;
        int read = cidSet.read(temp, 2048);
        while (read != -1) {
            if (size + read >= 16384) {
                System.arraycopy(temp, 0, cidSetBytes, size, 16384 - size);
                return cidSetBytes;
            }
            System.arraycopy(temp, 0, cidSetBytes, size, read);
            size += read;
            if (read < 2048) {
                return Arrays.copyOf(cidSetBytes, size);
            }
            read = cidSet.read(temp, 2048);
        }
        return Arrays.copyOf(cidSetBytes, size);
    }

    private static BitSet toBitSetBigEndian(byte[] source) {
        BitSet bitSet = new BitSet(source.length * 8);
        int i = 0;
        for (int n : source) {
            int b = n >= 0 ? n : 256 + n;
            for (int k = 0; k < 8; ++k) {
                bitSet.set(i++, (b & 0x80) != 0);
                b <<= 1;
            }
        }
        return bitSet;
    }
}

