/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.external;

import java.util.logging.Logger;
import org.verapdf.gf.model.impl.external.GFExternal;
import org.verapdf.model.external.ICCProfile;
import org.verapdf.pd.colors.PDColorSpace;

public class GFICCProfile
extends GFExternal
implements ICCProfile {
    private static final Logger LOGGER = Logger.getLogger(GFICCProfile.class.getCanonicalName());
    private final org.verapdf.external.ICCProfile iccProfile;

    protected GFICCProfile(org.verapdf.external.ICCProfile iccProfile, String type) {
        super(type);
        this.iccProfile = iccProfile;
        this.checkAlternateComponentsNumber();
    }

    public Long getN() {
        return this.iccProfile.getNumberOfColorants();
    }

    public String getdeviceClass() {
        return this.iccProfile.getDeviceClass();
    }

    public String getcolorSpace() {
        return this.iccProfile.getColorSpace();
    }

    public Double getversion() {
        return this.iccProfile.getVersion();
    }

    public Boolean getisValid() {
        return this.iccProfile.isLooksValid();
    }

    private void checkAlternateComponentsNumber() {
        PDColorSpace alternate = this.iccProfile.getAlternate();
        Long n = this.getN();
        if (alternate != null && n != null && (long)alternate.getNumberOfComponents() != n) {
            LOGGER.warning("Alternate color space does not match the number of components in the ICC profile");
        }
    }
}

