/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.pdlayer.PDHalftone;
import org.verapdf.pd.PDObject;

public class GFPDHalftone
extends GFPDObject
implements PDHalftone {
    public static final String HALFTONE_TYPE = "PDHalftone";
    private static final String HALFTONES = "halftones";
    private final ASAtom colorantName;

    public GFPDHalftone(org.verapdf.pd.PDHalftone dict) {
        this(dict, null);
    }

    public GFPDHalftone(org.verapdf.pd.PDHalftone dict, ASAtom colorantName) {
        super((PDObject)dict, HALFTONE_TYPE);
        this.colorantName = colorantName;
    }

    public Long getHalftoneType() {
        org.verapdf.pd.PDHalftone halftone = (org.verapdf.pd.PDHalftone)this.simplePDObject;
        COSObject object = halftone.getObject();
        if (object.getType() == COSObjType.COS_NAME && object.getName() == ASAtom.DEFAULT) {
            return 1L;
        }
        return halftone.getHalftoneType();
    }

    public String getHalftoneName() {
        org.verapdf.pd.PDHalftone halftone = (org.verapdf.pd.PDHalftone)this.simplePDObject;
        COSObject object = halftone.getObject();
        if (object.getType() == COSObjType.COS_NAME && object.getName() == ASAtom.DEFAULT) {
            return null;
        }
        return halftone.getHalftoneName();
    }

    public String getcolorantName() {
        return this.colorantName == null ? null : this.colorantName.getValue();
    }

    public String getTransferFunction() {
        COSObject tf = this.simplePDObject.getKey(ASAtom.getASAtom((String)"TransferFunction"));
        if (tf == null || tf.empty() || tf.getType() == COSObjType.COS_NULL) {
            return null;
        }
        if (tf.getType() == COSObjType.COS_NAME) {
            return tf.getName().getValue();
        }
        return tf.toString();
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "halftones": {
                return this.getHalftones();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<PDHalftone> getHalftones() {
        Long halftoneType = this.getHalftoneType();
        if (halftoneType == null || halftoneType != 5L) {
            return Collections.emptyList();
        }
        ArrayList<GFPDHalftone> halftones = new ArrayList<GFPDHalftone>();
        COSObject object = this.simplePDObject.getObject();
        if (object != null && object.getType().isDictionaryBased()) {
            for (ASAtom key : object.getKeySet()) {
                COSObject value = object.getKey(key);
                if (!value.getType().isDictionaryBased()) continue;
                org.verapdf.pd.PDHalftone halftone = new org.verapdf.pd.PDHalftone(value);
                GFPDHalftone gfPDHalftone = new GFPDHalftone(halftone, key);
                halftones.add(gfPDHalftone);
            }
        }
        return Collections.unmodifiableList(halftones);
    }
}

