/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.gf.model.impl.pd.actions.GFPDGoToAction;
import org.verapdf.gf.model.impl.pd.actions.GFPDGoToRemoteAction;
import org.verapdf.gf.model.impl.pd.actions.GFPDNamedAction;
import org.verapdf.gf.model.impl.pd.actions.GFPDRenditionAction;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.pdlayer.PDAction;
import org.verapdf.pd.PDObject;

public class GFPDAction
extends GFPDObject
implements PDAction {
    public static final String ACTION_TYPE = "PDAction";
    public static final String NEXT = "Next";
    public static final String NAMED_SUBTYPE = "Named";
    public static final String GO_TO_SUBTYPE = "GoTo";
    public static final String GO_TO_R_SUBTYPE = "GoToR";
    public static final String RENDITION_SUBTYPE = "Rendition";

    public GFPDAction(org.verapdf.pd.actions.PDAction simplePDObject) {
        this(simplePDObject, ACTION_TYPE);
    }

    public GFPDAction(org.verapdf.pd.actions.PDAction simplePDObject, String type) {
        super((PDObject)simplePDObject, type);
    }

    public String getS() {
        ASAtom subtype = ((org.verapdf.pd.actions.PDAction)this.simplePDObject).getSubtype();
        return subtype == null ? null : subtype.getValue();
    }

    public List<? extends Object> getLinkedObjects(String link) {
        if (NEXT.equals(link)) {
            return this.getNext();
        }
        return super.getLinkedObjects(link);
    }

    private List<PDAction> getNext() {
        List nextActionList = ((org.verapdf.pd.actions.PDAction)this.simplePDObject).getNext();
        if (!nextActionList.isEmpty()) {
            ArrayList<PDAction> actions = new ArrayList<PDAction>(nextActionList.size());
            for (org.verapdf.pd.actions.PDAction action : nextActionList) {
                PDAction result = GFPDAction.getAction(action);
                if (result == null) continue;
                actions.add(result);
            }
            return Collections.unmodifiableList(actions);
        }
        return Collections.emptyList();
    }

    public static PDAction getAction(org.verapdf.pd.actions.PDAction action) {
        if (action == null) {
            return null;
        }
        ASAtom subtype = action.getSubtype();
        if (subtype == null) {
            return new GFPDAction(action);
        }
        switch (subtype.getValue()) {
            case "Named": {
                return new GFPDNamedAction(action);
            }
            case "GoTo": {
                return new GFPDGoToAction(action);
            }
            case "GoToR": {
                return new GFPDGoToRemoteAction(action);
            }
            case "Rendition": {
                return new GFPDRenditionAction(action);
            }
        }
        return new GFPDAction(action);
    }
}

