/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.colors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.verapdf.external.ICCProfile;
import org.verapdf.gf.model.impl.external.GFICCInputProfile;
import org.verapdf.gf.model.impl.pd.colors.GFPDColorSpace;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.external.ICCInputProfile;
import org.verapdf.model.pdlayer.PDICCBased;
import org.verapdf.pd.colors.PDColorSpace;

public class GFPDICCBased
extends GFPDColorSpace
implements PDICCBased {
    private static final Logger LOGGER = Logger.getLogger(GFPDICCBased.class.getCanonicalName());
    public static final String ICC_BASED_TYPE = "PDICCBased";
    public static final String ICC_PROFILE = "iccProfile";

    public GFPDICCBased(org.verapdf.pd.colors.PDICCBased simplePDObject) {
        super((PDColorSpace)simplePDObject, ICC_BASED_TYPE);
        this.checkAlternateComponentsNumber();
    }

    protected GFPDICCBased(org.verapdf.pd.colors.PDICCBased simplePDObject, String type) {
        super((PDColorSpace)simplePDObject, type);
        this.checkAlternateComponentsNumber();
    }

    public List<? extends Object> getLinkedObjects(String link) {
        if (ICC_PROFILE.equals(link)) {
            return this.getICCProfile();
        }
        return super.getLinkedObjects(link);
    }

    private List<ICCInputProfile> getICCProfile() {
        ICCProfile iccProfile = ((org.verapdf.pd.colors.PDICCBased)this.simplePDObject).getICCProfile();
        if (iccProfile != null) {
            ArrayList<GFICCInputProfile> profiles = new ArrayList<GFICCInputProfile>(1);
            profiles.add(new GFICCInputProfile(iccProfile));
            return Collections.unmodifiableList(profiles);
        }
        return Collections.emptyList();
    }

    private void checkAlternateComponentsNumber() {
        org.verapdf.pd.colors.PDICCBased colorSpace = (org.verapdf.pd.colors.PDICCBased)this.simplePDObject;
        PDColorSpace alternate = colorSpace.getAlternate();
        if (alternate != null && colorSpace.getNumberOfComponents() != alternate.getNumberOfComponents()) {
            LOGGER.warning("Alternate color space does not match the number of components in the ICC profile");
        }
    }
}

