/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.exceptions.LoopedException;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.cos.GFCosActualText;
import org.verapdf.gf.model.impl.cos.GFCosLang;
import org.verapdf.gf.model.impl.cos.GFCosUnicodeName;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.gf.model.impl.pd.gfse.GFSEGeneral;
import org.verapdf.model.coslayer.CosActualText;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.pd.PDObject;
import org.verapdf.pd.structure.PDStructElem;
import org.verapdf.pd.structure.StructureType;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.tools.TaggedPDFHelper;

public class GFPDStructElem
extends GFPDObject
implements org.verapdf.model.pdlayer.PDStructElem {
    public static final String STRUCTURE_ELEMENT_TYPE = "PDStructElem";
    public static final String CHILDREN = "K";
    public static final String STRUCTURE_TYPE = "S";
    public static final String LANG = "Lang";
    public static final String ACTUAL_TEXT = "actualText";

    protected GFPDStructElem(PDStructElem structElemDictionary, String type) {
        super((PDObject)structElemDictionary, type);
        ASAtom subtype = this.simplePDObject.getNameKey(ASAtom.S);
        if (subtype != null) {
            this.id = (super.getID() != null ? super.getID() : "0 0 obj") + " " + ((COSName)COSName.fromValue((ASAtom)subtype)).getUnicodeValue();
        }
    }

    public GFPDStructElem(PDStructElem structElemDictionary) {
        this(structElemDictionary, STRUCTURE_ELEMENT_TYPE);
    }

    public String getType() {
        ASAtom type = ((PDStructElem)this.simplePDObject).getType();
        return type == null ? null : type.getValue();
    }

    public String getkidsStandardTypes() {
        if (StaticContainers.getFlavour() != null && StaticContainers.getFlavour().getPart() == PDFAFlavour.Specification.WCAG_2_1) {
            return this.getChildrenStandardTypes().stream().filter(type -> type != null && !"Artifact".equals(type)).collect(Collectors.joining("&"));
        }
        return this.getChildrenStandardTypes().stream().filter(Objects::nonNull).collect(Collectors.joining("&"));
    }

    public String getparentStandardType() {
        PDStructElem parent = ((PDStructElem)this.simplePDObject).getParent();
        if (parent != null) {
            String parentStandardType = GFPDStructElem.getStructureElementStandardType(parent);
            while ("NonStruct".equals(parentStandardType)) {
                if ((parent = parent.getParent()) == null) {
                    return null;
                }
                parentStandardType = GFPDStructElem.getStructureElementStandardType(parent);
            }
            return parentStandardType;
        }
        return null;
    }

    public Boolean gethasContentItems() {
        COSObject children = this.simplePDObject.getKey(ASAtom.K);
        if (children == null) {
            return false;
        }
        if (TaggedPDFHelper.isContentItem((COSObject)children)) {
            return true;
        }
        if (children.getType() == COSObjType.COS_ARRAY && children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                COSObject elem = children.at(i);
                if (!TaggedPDFHelper.isContentItem((COSObject)elem)) continue;
                return true;
            }
        }
        return false;
    }

    public String getstandardType() {
        return GFPDStructElem.getStructureElementStandardType((PDStructElem)this.simplePDObject);
    }

    public Boolean getisRemappedStandardType() {
        StructureType type = ((PDStructElem)this.simplePDObject).getStructureType();
        if (type == null) {
            return false;
        }
        boolean isStandardType = StaticContainers.getFlavour() != null && StaticContainers.getFlavour().getPart() == PDFAFlavour.Specification.WCAG_2_1 ? TaggedPDFHelper.isWCAGStandardType((StructureType)type) : TaggedPDFHelper.isStandardType((StructureType)type);
        if (isStandardType) {
            String actualType = type.getType().getValue();
            return !actualType.equals(GFPDStructElem.getStructureElementStandardType((PDStructElem)this.simplePDObject));
        }
        return false;
    }

    public String getAlt() {
        return ((PDStructElem)this.simplePDObject).getAlternateDescription();
    }

    public String getActualText() {
        return ((PDStructElem)this.simplePDObject).getActualText().getString();
    }

    public String getE() {
        return ((PDStructElem)this.simplePDObject).getExpandedAbbreviation();
    }

    public Boolean getcircularMappingExist() {
        StructureType type = ((PDStructElem)this.simplePDObject).getStructureType();
        return type != null ? StaticContainers.getRoleMapHelper().circularMappingExist(type.getType()) : null;
    }

    public static String getStructureElementStandardType(PDStructElem pdStructElem) {
        if (StaticContainers.getFlavour().getPart() == PDFAFlavour.Specification.ISO_19005_4) {
            StructureType defaultStructureType = pdStructElem.getDefaultStructureType();
            if (defaultStructureType != null) {
                return defaultStructureType.getType().getValue();
            }
        } else {
            StructureType type = pdStructElem.getStructureType();
            if (type != null) {
                return StaticContainers.getRoleMapHelper().getStandardType(type.getType(), StaticContainers.getFlavour() != null && StaticContainers.getFlavour().getPart() == PDFAFlavour.Specification.ISO_19005_1, StaticContainers.getFlavour() != null && StaticContainers.getFlavour().getPart() == PDFAFlavour.Specification.WCAG_2_1);
            }
        }
        return null;
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "K": {
                return this.getChildren();
            }
            case "S": {
                return this.getStructureType();
            }
            case "Lang": {
                return this.getLang();
            }
            case "actualText": {
                return this.getactualText();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<String> getChildrenStandardTypes() {
        return GFPDStructElem.getChildrenStandardTypes((PDStructElem)this.simplePDObject);
    }

    private static List<String> getChildrenStandardTypes(PDStructElem element) {
        List elementsChildren = element.getStructChildren();
        if (elementsChildren.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> res = new ArrayList<String>();
        for (PDStructElem child : elementsChildren) {
            String elementStandardType = GFPDStructElem.getStructureElementStandardType(child);
            if ("NonStruct".equals(elementStandardType)) {
                res.addAll(GFPDStructElem.getChildrenStandardTypes(child));
                continue;
            }
            res.add(elementStandardType);
        }
        return Collections.unmodifiableList(res);
    }

    public List<org.verapdf.model.pdlayer.PDStructElem> getChildren() {
        List elements = ((PDStructElem)this.simplePDObject).getStructChildren();
        if (!elements.isEmpty()) {
            ArrayList<GFSEGeneral> res = new ArrayList<GFSEGeneral>(elements.size());
            for (PDStructElem element : elements) {
                res.add(GFSEGeneral.createTypedStructElem(element));
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    private List<CosUnicodeName> getStructureType() {
        COSName type = ((PDStructElem)this.simplePDObject).getCOSStructureType();
        if (type != null) {
            ArrayList<GFCosUnicodeName> list = new ArrayList<GFCosUnicodeName>(1);
            list.add(new GFCosUnicodeName(type));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<CosLang> getLang() {
        COSString baseLang = ((PDStructElem)this.simplePDObject).getLang();
        if (baseLang != null) {
            ArrayList<GFCosLang> list = new ArrayList<GFCosLang>(1);
            list.add(new GFCosLang(baseLang));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public String getparentLang() {
        COSString baseLang = null;
        HashSet<COSKey> keys = new HashSet<COSKey>();
        COSKey key = this.simplePDObject.getObject().getObjectKey();
        if (key != null) {
            keys.add(key);
        }
        for (PDStructElem parent = ((PDStructElem)this.simplePDObject).getParent(); baseLang == null && parent != null; parent = parent.getParent()) {
            key = parent.getObject().getObjectKey();
            if (keys.contains(key)) {
                throw new LoopedException("Struct tree loop found");
            }
            if (key != null) {
                keys.add(key);
            }
            baseLang = parent.getLang();
        }
        if (baseLang != null) {
            return baseLang.getString();
        }
        return null;
    }

    private List<CosActualText> getactualText() {
        COSObject actualText = ((PDStructElem)this.simplePDObject).getActualText();
        if (actualText != null && COSObjType.COS_STRING == actualText.getType()) {
            ArrayList<CosActualText> list = new ArrayList<CosActualText>(1);
            list.add(new GFCosActualText((COSString)actualText.getDirectBase()));
            return list;
        }
        return Collections.emptyList();
    }
}

