/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.verapdf.gf.model.factory.operators.GraphicState;
import org.verapdf.gf.model.impl.pd.GFPDContentStream;
import org.verapdf.gf.model.impl.pd.gfse.GFSEContentItem;
import org.verapdf.gf.model.impl.pd.gfse.GFSEMarkedContent;
import org.verapdf.gf.model.impl.pd.gfse.GFSEUnmarkedContent;
import org.verapdf.gf.model.impl.pd.util.PDResourcesHandler;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.operator.Operator;
import org.verapdf.model.pdlayer.PDSemanticContentStream;
import org.verapdf.model.selayer.SEContentItem;
import org.verapdf.pd.PDContentStream;
import org.verapdf.pd.structure.StructureElementAccessObject;

public class GFPDSemanticContentStream
extends GFPDContentStream
implements PDSemanticContentStream {
    public static final String CONTENT = "content";
    public static final String SEMANTIC_CONTENT_STREAM_TYPE = "PDSemanticContentStream";
    private String defaultLang;

    public GFPDSemanticContentStream(PDContentStream contentStream, PDResourcesHandler resourcesHandler, GraphicState inheritedGraphicState, StructureElementAccessObject structureElementAccessObject) {
        super(contentStream, resourcesHandler, inheritedGraphicState, structureElementAccessObject, SEMANTIC_CONTENT_STREAM_TYPE);
    }

    public GFPDSemanticContentStream(PDContentStream contentStream, PDResourcesHandler resourcesHandler, GraphicState inheritedGraphicState, StructureElementAccessObject structureElementAccessObject, String parentStructureTag, String parentsTags) {
        super(contentStream, resourcesHandler, inheritedGraphicState, structureElementAccessObject, parentStructureTag, parentsTags, SEMANTIC_CONTENT_STREAM_TYPE);
    }

    public GFPDSemanticContentStream(PDContentStream contentStream, PDResourcesHandler resourcesHandler, GraphicState inheritedGraphicState, StructureElementAccessObject structureElementAccessObject, String parentStructureTag, String parentsTags, String defaultLang) {
        this(contentStream, resourcesHandler, inheritedGraphicState, structureElementAccessObject, parentStructureTag, parentsTags);
        this.defaultLang = defaultLang;
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "content": {
                return this.getContentItem();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<SEContentItem> getContentItem() {
        if (this.operators == null) {
            this.parseOperators();
        }
        int unmarkedContentIndex = 0;
        int markedContentIndex = -1;
        Stack<Integer> markedContentStack = new Stack<Integer>();
        ArrayList<GFSEContentItem> list = new ArrayList<GFSEContentItem>();
        for (int i = 0; i < this.operators.size(); ++i) {
            String type = ((Operator)this.operators.get(i)).getObjectType();
            if ("Op_BDC".equals(type) || "Op_BMC".equals(type)) {
                if (markedContentStack.empty() && i != markedContentIndex + 1) {
                    list.add(new GFSEUnmarkedContent(this.operators.subList(unmarkedContentIndex, i), this.parentStructureTag, this.parentsTags, this.defaultLang));
                }
                markedContentStack.push(i);
                continue;
            }
            if (!"Op_EMC".equals(type) || markedContentStack.empty()) continue;
            markedContentIndex = (Integer)markedContentStack.pop();
            if (!markedContentStack.empty()) continue;
            list.add(new GFSEMarkedContent(this.operators.subList(markedContentIndex, i + 1), this.parentStructureTag, this.parentsTags, this.defaultLang));
            markedContentIndex = i;
            unmarkedContentIndex = i + 1;
        }
        if (unmarkedContentIndex != this.operators.size()) {
            list.add(new GFSEUnmarkedContent(this.operators.subList(unmarkedContentIndex, this.operators.size()), this.parentStructureTag, this.parentsTags, this.defaultLang));
        }
        return Collections.unmodifiableList(list);
    }
}

