/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSDocument;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.PDMetadata;
import org.verapdf.tools.TypeConverter;
import org.verapdf.xmp.XMPException;
import org.verapdf.xmp.impl.VeraPDFMeta;

public final class XMPChecker {
    private static final Logger LOGGER = Logger.getLogger(XMPChecker.class.getCanonicalName());
    private static final int MAX_REQUIRED_RECORDS = 8;

    private XMPChecker() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Boolean doesInfoMatchXMP(COSDocument document) {
        COSObject info = XMPChecker.getInformationDictionary(document);
        if (info == null) {
            return Boolean.TRUE;
        }
        try (InputStream metadataStream = XMPChecker.getMetadataStream(document);){
            if (metadataStream == null) return Boolean.FALSE;
            VeraPDFMeta metadata = VeraPDFMeta.parse((InputStream)metadataStream);
            HashMap<ASAtom, Object> properties = new HashMap<ASAtom, Object>(8);
            XMPChecker.getTitleAuthorSubject(metadata, properties);
            XMPChecker.getProducerKeywords(metadata, properties);
            XMPChecker.getCreatorAndDates(metadata, properties);
            Boolean bl = XMPChecker.checkMatch(info, properties);
            return bl;
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Problems with document parsing or structure. " + e.getMessage(), e);
            return Boolean.FALSE;
        }
        catch (XMPException e) {
            LOGGER.log(Level.FINE, "Problems with XMP parsing. " + e.getMessage(), e);
        }
        return Boolean.FALSE;
    }

    private static InputStream getMetadataStream(COSDocument document) throws IOException {
        PDMetadata meta = document.getPDDocument().getMetadata();
        if (meta != null) {
            return meta.getStream();
        }
        return null;
    }

    private static COSObject getInformationDictionary(COSDocument document) {
        COSObject info = document.getTrailer().getInfo();
        if (info != null && info.getType() == COSObjType.COS_DICT) {
            return info;
        }
        return null;
    }

    private static void getTitleAuthorSubject(VeraPDFMeta metadata, Map<ASAtom, Object> properties) throws XMPException {
        XMPChecker.putProperty(properties, ASAtom.TITLE, metadata.getTitle());
        XMPChecker.putProperty(properties, ASAtom.SUBJECT, metadata.getDescription());
        List buffer = metadata.getCreator();
        if (buffer != null) {
            XMPChecker.putProperty(properties, ASAtom.AUTHOR, buffer);
        }
    }

    private static void getProducerKeywords(VeraPDFMeta metadata, Map<ASAtom, Object> properties) throws XMPException {
        XMPChecker.putProperty(properties, ASAtom.KEYWORDS, metadata.getKeywords());
        XMPChecker.putProperty(properties, ASAtom.PRODUCER, metadata.getProducer());
    }

    private static void getCreatorAndDates(VeraPDFMeta metadata, Map<ASAtom, Object> properties) throws XMPException {
        XMPChecker.putProperty(properties, ASAtom.CREATOR, metadata.getCreatorTool());
        XMPChecker.putProperty(properties, ASAtom.CREATION_DATE, metadata.getCreateDate());
        XMPChecker.putProperty(properties, ASAtom.MOD_DATE, metadata.getModifyDate());
    }

    private static void putProperty(Map<ASAtom, Object> properties, ASAtom key, Object value) {
        if (value != null) {
            properties.put(key, value);
        }
    }

    private static Boolean checkMatch(COSObject info, Map<ASAtom, Object> properties) {
        boolean isAdobePDFMatch;
        boolean isDublinCoreMatch;
        boolean bl = isDublinCoreMatch = XMPChecker.checkProperty(info, properties, ASAtom.TITLE) && XMPChecker.checkProperty(info, properties, ASAtom.SUBJECT) && XMPChecker.checkProperty(info, properties, ASAtom.AUTHOR);
        if (!isDublinCoreMatch) {
            return Boolean.FALSE;
        }
        boolean bl2 = isAdobePDFMatch = XMPChecker.checkProperty(info, properties, ASAtom.KEYWORDS) && XMPChecker.checkProperty(info, properties, ASAtom.PRODUCER);
        if (!isAdobePDFMatch) {
            return Boolean.FALSE;
        }
        boolean isXMPBasicMatch = XMPChecker.checkProperty(info, properties, ASAtom.CREATOR) && XMPChecker.checkProperty(info, properties, ASAtom.CREATION_DATE) && XMPChecker.checkProperty(info, properties, ASAtom.MOD_DATE);
        return isXMPBasicMatch;
    }

    private static boolean checkProperty(COSObject info, Map<ASAtom, Object> properties, ASAtom checksRule) {
        COSObject item = info.getKey(checksRule);
        if (item == null || item.empty() || item.getType() == COSObjType.COS_NULL) {
            return true;
        }
        if (item.getType() == COSObjType.COS_STRING) {
            return XMPChecker.checkCOSStringProperty(item, properties, checksRule);
        }
        return false;
    }

    private static Boolean checkCOSStringProperty(COSObject string, Map<ASAtom, Object> properties, ASAtom checksRule) {
        Object value = properties.get(checksRule);
        if (value != null) {
            if (value instanceof String) {
                return XMPChecker.checkStringsIgnoreInfoTrailingZero(value, string.getString());
            }
            if (value instanceof List) {
                List list = (List)value;
                return list.size() == 1 && XMPChecker.checkStringsIgnoreInfoTrailingZero(list.get(0), string.getString());
            }
            if (value instanceof Calendar) {
                Calendar valueDate = TypeConverter.parseDate((String)string.getString());
                return valueDate != null && valueDate.compareTo((Calendar)value) == 0;
            }
        }
        return Boolean.FALSE;
    }

    private static boolean checkStringsIgnoreInfoTrailingZero(Object fromXMP, String fromInfo) {
        if (fromInfo != null && fromInfo.endsWith("\u0000")) {
            fromInfo = fromInfo.substring(0, fromInfo.length() - 1);
        }
        return fromXMP.equals(fromInfo);
    }
}

