/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.cos.GFCosLang;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.gf.model.impl.pd.actions.GFPDAdditionalActions;
import org.verapdf.gf.model.impl.pd.signature.GFPDSignatureField;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.pdlayer.PDAdditionalActions;
import org.verapdf.model.pdlayer.PDFormField;
import org.verapdf.pd.PDObject;
import org.verapdf.pd.actions.PDAbstractAdditionalActions;
import org.verapdf.pd.actions.PDFormFieldActions;
import org.verapdf.pd.form.PDSignatureField;
import org.verapdf.pd.structure.PDNumberTreeNode;
import org.verapdf.pd.structure.PDStructTreeRoot;

public class GFPDFormField
extends GFPDObject
implements PDFormField {
    public static final String FORM_FIELD_TYPE = "PDFormField";
    public static final String ADDITIONAL_ACTION = "AA";
    public static final String LANG = "Lang";

    public GFPDFormField(org.verapdf.pd.form.PDFormField simplePDObject) {
        super((PDObject)simplePDObject, FORM_FIELD_TYPE);
    }

    protected GFPDFormField(org.verapdf.pd.form.PDFormField field, String type) {
        super((PDObject)field, type);
    }

    public static GFPDFormField createTypedFormField(org.verapdf.pd.form.PDFormField field) {
        if (field.getFT() == ASAtom.SIG) {
            return new GFPDSignatureField((PDSignatureField)field);
        }
        return new GFPDFormField(field);
    }

    public String getFT() {
        ASAtom ft = ((org.verapdf.pd.form.PDFormField)this.simplePDObject).getFT();
        return ft == null ? null : ft.getValue();
    }

    public Boolean getcontainsAA() {
        return this.simplePDObject.knownKey(ASAtom.AA);
    }

    private List<CosLang> getLang() {
        PDStructTreeRoot structTreeRoot = StaticContainers.getDocument().getStructTreeRoot();
        Long structParent = ((org.verapdf.pd.form.PDFormField)this.simplePDObject).getStructParent();
        if (structTreeRoot != null && structParent != null) {
            COSObject baseLang;
            COSObject structureElement;
            PDNumberTreeNode parentTreeRoot = structTreeRoot.getParentTree();
            COSObject cOSObject = structureElement = parentTreeRoot == null ? null : parentTreeRoot.getObject(structParent);
            if (structureElement != null && (baseLang = structureElement.getKey(ASAtom.LANG)) != null && baseLang.getType() == COSObjType.COS_STRING) {
                ArrayList<GFCosLang> list = new ArrayList<GFCosLang>(1);
                list.add(new GFCosLang((COSString)baseLang.getDirectBase()));
                return Collections.unmodifiableList(list);
            }
        }
        return Collections.emptyList();
    }

    public String getTU() {
        return ((org.verapdf.pd.form.PDFormField)this.simplePDObject).getTU();
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "AA": {
                return this.getAdditionalAction();
            }
            case "Lang": {
                return this.getLang();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<PDAdditionalActions> getAdditionalAction() {
        PDFormFieldActions pdActions = ((org.verapdf.pd.form.PDFormField)this.simplePDObject).getActions();
        if (pdActions != null) {
            ArrayList<GFPDAdditionalActions> actions = new ArrayList<GFPDAdditionalActions>(1);
            actions.add(new GFPDAdditionalActions((PDAbstractAdditionalActions)pdActions));
            return Collections.unmodifiableList(actions);
        }
        return Collections.emptyList();
    }
}

