/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.verapdf.gf.model.impl.pd.GFPDOutputIntent;
import org.verapdf.model.GenericModelObject;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.pdlayer.OutputIntents;
import org.verapdf.model.pdlayer.PDOutputIntent;

public class GFOutputIntents
extends GenericModelObject
implements OutputIntents {
    public static final String OUTPUT_INTENTS_TYPE = "OutputIntents";
    public static final String OUTPUT_INTENTS = "outputIntents";
    List<org.verapdf.pd.PDOutputIntent> outInts = null;

    public GFOutputIntents(List<org.verapdf.pd.PDOutputIntent> outInts) {
        super(OUTPUT_INTENTS_TYPE);
        this.outInts = outInts;
    }

    public Boolean getsameOutputProfileIndirect() {
        String destOutputProfileIndirect = null;
        for (org.verapdf.pd.PDOutputIntent outputIntent : this.outInts) {
            String currentOutputProfile = outputIntent.getDestOutputProfileIndirect();
            if (destOutputProfileIndirect != null && currentOutputProfile != null && !destOutputProfileIndirect.equals(currentOutputProfile)) {
                return false;
            }
            destOutputProfileIndirect = destOutputProfileIndirect == null ? currentOutputProfile : destOutputProfileIndirect;
        }
        return true;
    }

    public String getoutputProfileIndirects() {
        return this.outInts.stream().map(org.verapdf.pd.PDOutputIntent::getDestOutputProfileIndirect).filter(Objects::nonNull).distinct().collect(Collectors.joining(","));
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "outputIntents": {
                return this.getOutputIntents();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<PDOutputIntent> getOutputIntents() {
        ArrayList<PDOutputIntent> res = new ArrayList<PDOutputIntent>(this.outInts.size());
        for (org.verapdf.pd.PDOutputIntent outInt : this.outInts) {
            res.add(new GFPDOutputIntent(outInt));
        }
        return res;
    }

    public String getColorSpace() {
        for (org.verapdf.pd.PDOutputIntent outputIntent : this.outInts) {
            String colorSpace = outputIntent.getColorSpace();
            if (colorSpace == null) continue;
            return colorSpace;
        }
        return null;
    }
}

