/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.cos.GFCosLang;
import org.verapdf.gf.model.impl.pd.GFOutputIntents;
import org.verapdf.gf.model.impl.pd.GFPDAcroForm;
import org.verapdf.gf.model.impl.pd.GFPDMetadata;
import org.verapdf.gf.model.impl.pd.GFPDOCProperties;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.gf.model.impl.pd.GFPDPage;
import org.verapdf.gf.model.impl.pd.GFPDStructTreeRoot;
import org.verapdf.gf.model.impl.pd.actions.GFPDAction;
import org.verapdf.gf.model.impl.pd.actions.GFPDAdditionalActions;
import org.verapdf.gf.model.impl.pd.signature.GFPDPerms;
import org.verapdf.gf.model.tools.OutlinesHelper;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.pdlayer.OutputIntents;
import org.verapdf.model.pdlayer.PDAcroForm;
import org.verapdf.model.pdlayer.PDAction;
import org.verapdf.model.pdlayer.PDAdditionalActions;
import org.verapdf.model.pdlayer.PDDocument;
import org.verapdf.model.pdlayer.PDOCProperties;
import org.verapdf.model.pdlayer.PDOutline;
import org.verapdf.model.pdlayer.PDPage;
import org.verapdf.model.pdlayer.PDPerms;
import org.verapdf.pd.PDCatalog;
import org.verapdf.pd.PDMetadata;
import org.verapdf.pd.actions.PDAbstractAdditionalActions;
import org.verapdf.pd.actions.PDCatalogAdditionalActions;
import org.verapdf.pd.optionalcontent.PDOptionalContentProperties;
import org.verapdf.pd.structure.PDStructTreeRoot;
import org.verapdf.tools.StaticResources;

public class GFPDDocument
extends GFPDObject
implements PDDocument {
    public static final String PD_DOCUMENT_TYPE = "PDDocument";
    public static final String PAGES = "pages";
    public static final String METADATA = "metadata";
    public static final String OUTPUT_INTENTS = "outputIntents";
    public static final String ACRO_FORMS = "AcroForm";
    public static final String ACTIONS = "AA";
    public static final String OPEN_ACTION = "OpenAction";
    public static final String OUTLINES = "Outlines";
    public static final String STRUCTURE_TREE_ROOT = "StructTreeRoot";
    public static final String ALTERNATE_PRESENTATIONS = "AlternatePresentations";
    public static final String OC_PROPERTIES = "OCProperties";
    public static final String LANG = "Lang";
    public static final String PERMS = "Perms";
    private final PDCatalog catalog;
    private OutputIntents outputIntents = null;

    public GFPDDocument(org.verapdf.pd.PDDocument document) {
        super(document, PD_DOCUMENT_TYPE);
        PDCatalog catalog;
        this.catalog = catalog = document.getCatalog();
    }

    public Boolean getcontainsAlternatePresentations() {
        COSObject alternatePresentations;
        COSObject namesDictionary;
        COSObject rawCatalog;
        if (this.catalog != null && (rawCatalog = this.catalog.getObject()) != null && rawCatalog.getType().isDictionaryBased() && (namesDictionary = rawCatalog.getKey(ASAtom.NAMES)) != null && namesDictionary.getType().isDictionaryBased() && (alternatePresentations = namesDictionary.getKey(ASAtom.getASAtom((String)ALTERNATE_PRESENTATIONS))) != null && !alternatePresentations.empty() && alternatePresentations.getType() != COSObjType.COS_NULL) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean getvalidPDF() {
        return StaticContainers.getValidPDF();
    }

    public Boolean getcontainsAA() {
        return this.catalog != null && this.catalog.getObject().getType().isDictionaryBased() && this.catalog.knownKey(ASAtom.AA);
    }

    public String getoutputColorSpace() {
        if (this.outputIntents == null) {
            this.outputIntents = this.parseOutputIntents();
        }
        if (this.outputIntents != null) {
            return ((GFOutputIntents)this.outputIntents).getColorSpace();
        }
        return null;
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Outlines": {
                return this.getOutlines();
            }
            case "OpenAction": {
                return this.getOpenAction();
            }
            case "AA": {
                return this.getActions();
            }
            case "pages": {
                return GFPDDocument.getPages();
            }
            case "metadata": {
                return this.getMetadata();
            }
            case "outputIntents": {
                return this.getOutputIntents();
            }
            case "AcroForm": {
                return this.getAcroForms();
            }
            case "StructTreeRoot": {
                return this.getStructureTreeRoot();
            }
            case "OCProperties": {
                return this.getOCProperties();
            }
            case "Lang": {
                return this.getLang();
            }
            case "Perms": {
                return this.getPerms();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<PDOutline> getOutlines() {
        return OutlinesHelper.getOutlines(this.catalog);
    }

    private List<PDAction> getOpenAction() {
        ArrayList<PDAction> actions = new ArrayList<PDAction>(1);
        org.verapdf.pd.actions.PDAction action = this.catalog.getOpenAction();
        if (action != null) {
            actions.add(GFPDAction.getAction(action));
        }
        return Collections.unmodifiableList(actions);
    }

    private List<PDAdditionalActions> getActions() {
        PDCatalogAdditionalActions additionalActions;
        if (this.catalog != null && (additionalActions = this.catalog.getAdditionalActions()) != null) {
            ArrayList<GFPDAdditionalActions> actions = new ArrayList<GFPDAdditionalActions>(1);
            actions.add(new GFPDAdditionalActions((PDAbstractAdditionalActions)additionalActions));
            return Collections.unmodifiableList(actions);
        }
        return Collections.emptyList();
    }

    private static List<PDPage> getPages() {
        ArrayList<GFPDPage> result = new ArrayList<GFPDPage>();
        List rawPages = StaticResources.getDocument().getPages();
        for (org.verapdf.pd.PDPage rawPage : rawPages) {
            result.add(new GFPDPage(rawPage));
        }
        return Collections.unmodifiableList(result);
    }

    private List<org.verapdf.model.pdlayer.PDMetadata> getMetadata() {
        PDMetadata meta;
        if (this.catalog != null && (meta = this.catalog.getMetadata()) != null && PDMetadata.isMetadataObject((COSObject)meta.getObject())) {
            ArrayList<GFPDMetadata> metadata = new ArrayList<GFPDMetadata>(1);
            metadata.add(new GFPDMetadata(meta, Boolean.TRUE));
            return Collections.unmodifiableList(metadata);
        }
        return Collections.emptyList();
    }

    private List<OutputIntents> getOutputIntents() {
        if (this.outputIntents == null) {
            this.outputIntents = this.parseOutputIntents();
        }
        if (this.outputIntents != null) {
            ArrayList<OutputIntents> array = new ArrayList<OutputIntents>(1);
            array.add(this.outputIntents);
            return array;
        }
        return Collections.emptyList();
    }

    private OutputIntents parseOutputIntents() {
        List outInts = this.document.getOutputIntents();
        if (outInts.size() > 0) {
            return new GFOutputIntents(outInts);
        }
        return null;
    }

    private List<PDAcroForm> getAcroForms() {
        org.verapdf.pd.form.PDAcroForm acroForm = this.document.getAcroForm();
        if (acroForm != null) {
            ArrayList<GFPDAcroForm> forms = new ArrayList<GFPDAcroForm>(1);
            forms.add(new GFPDAcroForm(acroForm));
            return Collections.unmodifiableList(forms);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.pdlayer.PDStructTreeRoot> getStructureTreeRoot() {
        PDStructTreeRoot root = this.document.getStructTreeRoot();
        if (root != null) {
            ArrayList<GFPDStructTreeRoot> res = new ArrayList<GFPDStructTreeRoot>(1);
            res.add(new GFPDStructTreeRoot(root));
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    private List<PDPerms> getPerms() {
        COSObject perms;
        if (this.catalog != null && (perms = this.catalog.getKey(ASAtom.PERMS)) != null && perms.getType().isDictionaryBased()) {
            ArrayList<GFPDPerms> list = new ArrayList<GFPDPerms>(1);
            list.add(new GFPDPerms(perms));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<PDOCProperties> getOCProperties() {
        PDOptionalContentProperties ocProperties;
        if (this.catalog != null && (ocProperties = this.catalog.getOCProperties()) != null) {
            ArrayList<PDOCProperties> result = new ArrayList<PDOCProperties>();
            GFPDOCProperties pdOCProperties = new GFPDOCProperties(ocProperties);
            result.add(pdOCProperties);
            return result;
        }
        return Collections.emptyList();
    }

    private List<CosLang> getLang() {
        COSObject baseLang;
        if (this.catalog != null && (baseLang = this.catalog.getKey(ASAtom.LANG)) != null && baseLang.getType() == COSObjType.COS_STRING) {
            ArrayList<GFCosLang> list = new ArrayList<GFCosLang>(1);
            list.add(new GFCosLang((COSString)baseLang.getDirectBase()));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public String getVersion() {
        return this.catalog != null ? this.catalog.getVersion() : null;
    }

    public String getmostCommonOrientation() {
        List twoTheMostFrequent = GFPDDocument.getPages().stream().map(PDPage::getorientation).collect(Collectors.groupingBy(a -> a, Collectors.counting())).entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(2L).map(Map.Entry::getKey).collect(Collectors.toList());
        return "Square".equals(twoTheMostFrequent.get(0)) && twoTheMostFrequent.size() == 2 ? (String)twoTheMostFrequent.get(1) : (String)twoTheMostFrequent.get(0);
    }
}

