/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.images;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.external.JPEG2000;
import org.verapdf.gf.model.factory.colors.ColorSpaceFactory;
import org.verapdf.gf.model.impl.cos.GFCosRenderingIntent;
import org.verapdf.gf.model.impl.external.GFJPEG2000;
import org.verapdf.gf.model.impl.pd.images.GFPDXObject;
import org.verapdf.gf.model.impl.pd.util.PDResourcesHandler;
import org.verapdf.model.coslayer.CosRenderingIntent;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.images.PDXImage;
import org.verapdf.pd.images.PDXObject;

public class GFPDXImage
extends GFPDXObject
implements org.verapdf.model.pdlayer.PDXImage {
    public static final String X_IMAGE_TYPE = "PDXImage";
    public static final String IMAGE_CS = "imageCS";
    public static final String ALTERNATES = "Alternates";
    public static final String INTENT = "Intent";
    public static final String JPX_STREAM = "jpxStream";
    private List<org.verapdf.model.external.JPEG2000> jpeg2000List = null;

    protected GFPDXImage(PDXImage simplePDObject, PDResourcesHandler resourcesHandler) {
        this(simplePDObject, resourcesHandler, X_IMAGE_TYPE);
    }

    protected GFPDXImage(PDXImage simplePDObject, PDResourcesHandler resourcesHandler, String type) {
        super((PDXObject)simplePDObject, resourcesHandler, type);
    }

    public Boolean getInterpolate() {
        return ((PDXImage)this.simplePDObject).isInterpolate();
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Intent": {
                return this.getIntent();
            }
            case "imageCS": {
                return this.getImageCS();
            }
            case "Alternates": {
                return this.getAlternates();
            }
            case "jpxStream": {
                return this.getJPXStream();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<CosRenderingIntent> getIntent() {
        COSName intent = ((PDXImage)this.simplePDObject).getIntent();
        if (intent != null) {
            ArrayList<GFCosRenderingIntent> intents = new ArrayList<GFCosRenderingIntent>(1);
            intents.add(new GFCosRenderingIntent(intent));
            return Collections.unmodifiableList(intents);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.pdlayer.PDColorSpace> getImageCS() {
        PDXImage image;
        if (this.jpeg2000List == null) {
            this.jpeg2000List = this.parseJPXStream();
        }
        if (!(image = (PDXImage)this.simplePDObject).getImageMask()) {
            ArrayList<org.verapdf.model.pdlayer.PDColorSpace> colorSpaces = new ArrayList<org.verapdf.model.pdlayer.PDColorSpace>(1);
            ASAtom csName = image.getImageCSName();
            if (csName != null) {
                PDColorSpace buffer = this.resourcesHandler.getColorSpace(csName);
                if (buffer != null) {
                    colorSpaces.add(ColorSpaceFactory.getColorSpace(buffer));
                    return Collections.unmodifiableList(colorSpaces);
                }
            } else {
                PDColorSpace buffer = image.getImageCS();
                if (buffer != null) {
                    colorSpaces.add(ColorSpaceFactory.getColorSpace(buffer));
                    return Collections.unmodifiableList(colorSpaces);
                }
            }
        }
        return Collections.emptyList();
    }

    private List<? extends org.verapdf.model.pdlayer.PDXImage> getAlternates() {
        List alternates = ((PDXImage)this.simplePDObject).getAlternates();
        ArrayList<GFPDXImage> res = new ArrayList<GFPDXImage>(alternates.size());
        for (PDXImage image : alternates) {
            res.add(new GFPDXImage(image, this.resourcesHandler));
        }
        return res;
    }

    private List<org.verapdf.model.external.JPEG2000> getJPXStream() {
        if (this.jpeg2000List == null) {
            this.jpeg2000List = this.parseJPXStream();
        }
        return this.jpeg2000List;
    }

    private List<org.verapdf.model.external.JPEG2000> parseJPXStream() {
        JPEG2000 jpeg = ((PDXImage)this.simplePDObject).getJPXStream();
        if (jpeg != null) {
            ArrayList<GFJPEG2000> list = new ArrayList<GFJPEG2000>(1);
            list.add(new GFJPEG2000(jpeg));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public boolean containsTransparency() {
        COSObject smask = this.simplePDObject.getKey(ASAtom.SMASK);
        return smask != null && smask.getType() == COSObjType.COS_STREAM || ((PDXImage)this.simplePDObject).getSMaskInData() > 0;
    }
}

