/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.factory.operators;

import org.verapdf.cos.COSName;
import org.verapdf.gf.model.factory.operators.RenderingMode;
import org.verapdf.pd.PDExtGState;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.colors.PDDeviceGray;

public class GraphicState
implements Cloneable {
    private PDColorSpace fillColorSpace = PDDeviceGray.INSTANCE;
    private PDColorSpace strokeColorSpace = PDDeviceGray.INSTANCE;
    private RenderingMode renderingMode = RenderingMode.FILL;
    private COSName fontName;
    private boolean overprintingFlagStroke = false;
    private boolean overprintingFlagNonStroke = false;
    private int opm = 0;

    public PDColorSpace getFillColorSpace() {
        return this.fillColorSpace;
    }

    public void setFillColorSpace(PDColorSpace fillColorSpace) {
        this.fillColorSpace = fillColorSpace;
    }

    public PDColorSpace getStrokeColorSpace() {
        return this.strokeColorSpace;
    }

    public void setStrokeColorSpace(PDColorSpace strokeColorSpace) {
        this.strokeColorSpace = strokeColorSpace;
    }

    public RenderingMode getRenderingMode() {
        return this.renderingMode;
    }

    public void setRenderingMode(RenderingMode renderingMode) {
        this.renderingMode = renderingMode;
    }

    public COSName getFontName() {
        return this.fontName;
    }

    public void setFontName(COSName fontName) {
        this.fontName = fontName;
    }

    public boolean isOverprintingFlagStroke() {
        return this.overprintingFlagStroke;
    }

    public void setOverprintingFlagStroke(boolean overprintingFlagStroke) {
        this.overprintingFlagStroke = overprintingFlagStroke;
    }

    public boolean isOverprintingFlagNonStroke() {
        return this.overprintingFlagNonStroke;
    }

    public void setOverprintingFlagNonStroke(boolean overprintingFlagNonStroke) {
        this.overprintingFlagNonStroke = overprintingFlagNonStroke;
    }

    public int getOpm() {
        return this.opm;
    }

    public void setOpm(int opm) {
        this.opm = opm;
    }

    public void copyProperties(GraphicState graphicState) {
        this.fillColorSpace = graphicState.getFillColorSpace();
        this.strokeColorSpace = graphicState.getStrokeColorSpace();
        this.renderingMode = graphicState.getRenderingMode();
        this.fontName = graphicState.getFontName();
        this.overprintingFlagStroke = graphicState.isOverprintingFlagStroke();
        this.overprintingFlagNonStroke = graphicState.isOverprintingFlagNonStroke();
        this.opm = graphicState.getOpm();
    }

    public void copyPropertiesFormExtGState(PDExtGState extGState) {
        if (extGState != null) {
            Long opm;
            Boolean oFNS;
            Boolean oFS = extGState.getStrokingOverprintControl();
            if (oFS != null) {
                this.overprintingFlagStroke = oFS;
            }
            if ((oFNS = extGState.getNonStrokingOverprintControl()) != null) {
                this.overprintingFlagNonStroke = oFNS;
            }
            if ((opm = extGState.getOverprintMode()) != null) {
                this.opm = opm.intValue();
            }
        }
    }

    protected GraphicState clone() {
        GraphicState clone = new GraphicState();
        clone.fillColorSpace = this.fillColorSpace;
        clone.strokeColorSpace = this.strokeColorSpace;
        clone.renderingMode = this.renderingMode;
        clone.fontName = this.fontName;
        clone.overprintingFlagStroke = this.overprintingFlagStroke;
        clone.overprintingFlagNonStroke = this.overprintingFlagNonStroke;
        clone.opm = this.opm;
        return clone;
    }
}

