/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.operator.textshow;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.gf.model.tools.GFIDGenerator;
import org.verapdf.model.GenericModelObject;
import org.verapdf.model.operator.Glyph;
import org.verapdf.pd.font.Encoding;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.font.PDSimpleFont;
import org.verapdf.pd.font.PDType0Font;

public class GFGlyph
extends GenericModelObject
implements Glyph {
    private static final Logger LOGGER = Logger.getLogger(GFGlyph.class.getCanonicalName());
    public static final String GLYPH_TYPE = "Glyph";
    private final String id;
    private Boolean glyphPresent;
    private Boolean widthsConsistent;
    private String name;
    private String toUnicode;
    private Long renderingMode;

    public GFGlyph(Boolean glyphPresent, Boolean widthsConsistent, PDFont font, int glyphCode, int renderingMode) {
        this(glyphPresent, widthsConsistent, font, glyphCode, GLYPH_TYPE, renderingMode);
    }

    public GFGlyph(Boolean glyphPresent, Boolean widthsConsistent, PDFont font, int glyphCode, String type, int renderingMode) {
        super(type);
        this.glyphPresent = glyphPresent;
        this.widthsConsistent = widthsConsistent;
        this.renderingMode = renderingMode;
        if (font instanceof PDSimpleFont) {
            Encoding encoding = font.getEncodingMapping();
            this.name = encoding == null ? null : encoding.getName(glyphCode);
        } else if (font instanceof PDType0Font) {
            try {
                FontProgram pr = font.getFontProgram();
                if (pr == null) {
                    this.name = null;
                } else {
                    pr.parseFont();
                    this.name = glyphCode == 0 || !pr.containsCode(glyphCode) ? ".notdef" : null;
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Can't convert code to glyph", e);
                this.name = null;
            }
        }
        this.toUnicode = font.toUnicode(glyphCode);
        this.id = GFIDGenerator.generateID(font.getDictionary().hashCode(), font.getName(), glyphCode, renderingMode);
    }

    public String getname() {
        return this.name;
    }

    public Boolean getisWidthConsistent() {
        return this.widthsConsistent;
    }

    public Boolean getisGlyphPresent() {
        return this.glyphPresent;
    }

    public String gettoUnicode() {
        return this.toUnicode;
    }

    public Long getrenderingMode() {
        return this.renderingMode;
    }

    public String getID() {
        return this.id;
    }
}

